/*
 * Decompiled with CFR 0.152.
 */
package specialAlgorithm;

import entities.ByteArray;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;
import specialAlgorithm.SpecialAlgorithm;

public class PostgreSQL
implements SpecialAlgorithm {
    private static byte[] magicNumber = DatatypeConverter.parseHexBinary((String)"0123456789ABCDEF");
    private MessageDigest m = null;
    private byte[] hashPrefix = null;

    public PostgreSQL() {
        try {
            this.m = MessageDigest.getInstance("MD5");
            this.hashPrefix = new byte[4];
            this.hashPrefix[0] = 47;
            this.hashPrefix[1] = 109;
            this.hashPrefix[2] = 100;
            this.hashPrefix[3] = 53;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    private final String bytes2Utf8(byte[] ba) {
        try {
            return new String(ba, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public final String toHash(byte[] hash) {
        byte[] salt = this.getSaltFromHash(hash);
        int auxIndex = 0;
        int i = 0;
        while (i < hash.length) {
            if (hash[i] == 47) {
                auxIndex = i;
                break;
            }
            ++i;
        }
        byte[] rest = ByteArray.getSubArray(hash, auxIndex + 4, hash.length - 1);
        return String.valueOf(this.bytes2Utf8(salt)) + "/md5" + DatatypeConverter.printHexBinary((byte[])rest).toLowerCase();
    }

    @Override
    public final String crypt(String password, String salt) {
        return this.toHash(this.cryptPerf(password.getBytes(), salt.getBytes()));
    }

    @Override
    public byte[] cryptPerf(byte[] password, byte[] salt) {
        byte[] lowerSalt = ByteArray.toLowerCase(salt);
        byte[] prepared = ByteArray.concat(password, lowerSalt);
        this.m.update(prepared);
        return this.insertPreSaltForCompatibilityWithJBrute(this.m.digest(), lowerSalt);
    }

    private byte[] insertPreSaltForCompatibilityWithJBrute(byte[] b, byte[] username) {
        byte[] returnValue = new byte[username.length];
        int i = 0;
        while (i < username.length) {
            returnValue[i] = username[i];
            ++i;
        }
        returnValue = ByteArray.concat(returnValue, this.hashPrefix);
        returnValue = ByteArray.concat(returnValue, b);
        return returnValue;
    }

    @Override
    public byte[] getSaltFromHash(byte[] hash) {
        int myIndex = 0;
        int i = 0;
        while (i < hash.length) {
            if ((char)hash[i] == '/') {
                myIndex = i;
                break;
            }
            ++i;
        }
        byte[] lowerSalt = ByteArray.toLowerCase(ByteArray.getSubArray(hash, 0, myIndex - 1));
        return lowerSalt;
    }

    @Override
    public byte[] appendSaltToWord(byte[] word, byte[] salt) {
        byte[] saltedWord = new byte[salt.length + 1];
        int i = 0;
        while (i < salt.length) {
            saltedWord[i] = salt[i];
            ++i;
        }
        saltedWord[salt.length] = 47;
        saltedWord = ByteArray.concat(saltedWord, word);
        return saltedWord;
    }

    @Override
    public final byte[] toByteArray(String hash) {
        int separatorPos = hash.indexOf(47);
        String salt = hash.substring(0, separatorPos);
        byte[] bsalt = salt.getBytes();
        String rest = hash.substring(separatorPos + 1 + 3, hash.length());
        byte[] brest = DatatypeConverter.parseHexBinary((String)rest);
        byte[] bhash = new byte[bsalt.length + 1 + 3];
        int i = 0;
        while (i < bsalt.length) {
            bhash[i] = bsalt[i];
            ++i;
        }
        bhash[bsalt.length] = 47;
        bhash[bsalt.length + 1] = 109;
        bhash[bsalt.length + 2] = 100;
        bhash[bsalt.length + 3] = 53;
        bhash = ByteArray.concat(bhash, brest);
        return bhash;
    }
}

