/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.api.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.paterva.maltego.seeds.api.json.JsonHubInput;
import com.paterva.maltego.seeds.api.json.JsonHubProvider;
import com.paterva.maltego.seeds.api.json.JsonHubUrl;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JsonHubItem {
    private final String name;
    private final String description;
    private final String details;
    private final String display;
    private final boolean showRestricted;
    private final boolean preInstall;
    private final int sort;
    private final String id;
    private final String restrictedInformation;
    private final JsonHubProvider provider;
    private final String updatedAt;
    private final List<JsonHubUrl> urls;
    private final List<String> tagIds;
    private final List<String> badgeIds;
    private final List<String> grantedSeedUrls;
    private final List<JsonHubInput> inputs;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public JsonHubItem(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="description", required=true) String description, @JsonProperty(value="details", required=true) String details, @JsonProperty(value="display", required=true) String display, @JsonProperty(value="showRestricted", required=true) boolean showRestricted, @JsonProperty(value="preInstall", required=true) boolean preInstall, @JsonProperty(value="sort", required=true) int sort, @JsonProperty(value="id", required=true) String id, @JsonProperty(value="restrictedInformation", required=false) String restrictedInformation, @JsonProperty(value="provider", required=true) JsonHubProvider provider, @JsonProperty(value="updatedAt", required=false) String updatedAt, @JsonProperty(value="urls", required=false) List<JsonHubUrl> urls, @JsonProperty(value="tags", required=false) List<String> tagIds, @JsonProperty(value="badges", required=false) List<String> badgeIds, @JsonProperty(value="grantedSeedUrls", required=false) List<String> grantedSeedUrls, @JsonProperty(value="inputs", required=false) List<JsonHubInput> inputs) {
        this.name = name;
        this.description = description;
        this.details = details;
        this.display = display;
        this.showRestricted = showRestricted;
        this.preInstall = preInstall;
        this.sort = sort;
        this.id = id;
        this.restrictedInformation = restrictedInformation;
        this.updatedAt = updatedAt;
        this.provider = provider;
        this.urls = urls;
        this.tagIds = tagIds;
        this.badgeIds = badgeIds;
        this.grantedSeedUrls = grantedSeedUrls;
        this.inputs = inputs;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDetails() {
        return this.details;
    }

    public String getDisplay() {
        return this.display;
    }

    public boolean getShowRestricted() {
        return this.showRestricted;
    }

    public boolean getPreInstall() {
        return this.preInstall;
    }

    public int getSort() {
        return this.sort;
    }

    public String getId() {
        return this.id;
    }

    public String getRestrictedInformation() {
        return this.restrictedInformation;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public JsonHubProvider getProvider() {
        return this.provider;
    }

    public List<JsonHubUrl> getUrls() {
        return this.urls != null ? this.urls : Collections.emptyList();
    }

    public List<String> getTagIds() {
        return this.tagIds != null ? this.tagIds : Collections.emptyList();
    }

    public List<String> getBadgeIds() {
        return this.badgeIds != null ? this.badgeIds : Collections.emptyList();
    }

    public List<JsonHubInput> getInputs() {
        return this.inputs != null ? this.inputs : Collections.emptyList();
    }

    public List<String> getGrantedSeedUrls() {
        return this.grantedSeedUrls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonHubItem that = (JsonHubItem)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "JsonHubContent{name='" + this.name + '\'' + '}';
    }
}

