/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config.jre;

import com.paterva.maltego.java.config.jre.LogManager;
import com.paterva.maltego.java.config.jre.StringUtils;
import com.paterva.maltego.java.config.jre.Version;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaInfo {
    private Version version;
    private String vendor;
    private boolean nonFinal;
    private String arch;

    public static JavaInfo getInfo(String string, boolean silent) {
        String[] lines = StringUtils.splitByLines(string);
        Version version = null;
        boolean nonFinal = false;
        if (lines.length == 6) {
            Matcher matcher;
            String javaVersion = lines[0];
            String javaVmVersion = lines[1];
            String vendor = lines[2];
            String osName = lines[3];
            String osArch = lines[4];
            if (!silent) {
                LogManager.log(String.format(" out: %s, %s, %s, %s, %s", javaVersion, javaVmVersion, vendor, osName, osArch));
            }
            String versionString = javaVmVersion.indexOf(javaVersion) != -1 ? javaVmVersion.substring(javaVmVersion.indexOf(javaVersion)) : javaVersion;
            Matcher nonFinalMatcher = Pattern.compile("-(ea|rc[0-9]*|beta[0-9]*|preview[0-9]*|dp[0-9]*|alpha[0-9]*|fcs)").matcher(versionString);
            if (nonFinalMatcher.find()) {
                versionString = versionString.replaceAll("-(ea|rc[0-9]*|beta[0-9]*|preview[0-9]*|dp[0-9]*|alpha[0-9]*|fcs)", "");
                nonFinal = true;
            }
            if (versionString.matches("[0-9]+\\.[0-9]+\\.[0-9]+-b[0-9]+")) {
                versionString = versionString.replace("-b", ".0.");
            }
            if (versionString.matches("[0-9]+\\.[0-9]+\\.[0-9]+_[0-9]+-b[0-9]+")) {
                versionString = versionString.replace("-b", ".");
            }
            if (vendor.indexOf("BEA") != -1) {
                versionString = versionString.replaceAll("([0-9]+\\.[0-9]+\\.[0-9])+-([0-9]+)", "$1.0.$2");
            }
            if ((matcher = Pattern.compile(Version.VERSION_PATTERN).matcher(versionString)).find()) {
                version = Version.getVersion(matcher.group());
            }
            if (version != null) {
                return new JavaInfo(version, vendor, osArch, nonFinal);
            }
        } else if (!silent) {
            LogManager.log(" different lines number [" + lines.length + "]");
            for (int j = 0; j < lines.length; ++j) {
                LogManager.log(" line [" + j + "] = [" + lines[j] + "]");
            }
        }
        return null;
    }

    public JavaInfo(Version version, String vendor) {
        this.arch = version.toString().endsWith("64") ? "x64" : "";
        this.version = version;
        this.vendor = vendor;
        this.nonFinal = false;
    }

    public JavaInfo(Version version, String vendor, boolean nonFinal) {
        this(version, vendor);
        this.nonFinal = nonFinal;
    }

    public JavaInfo(Version version, String vendor, String arch, boolean nonFinal) {
        this(version, vendor);
        this.arch = arch;
        this.nonFinal = nonFinal;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getVendor() {
        return this.vendor;
    }

    public boolean isNonFinal() {
        return this.nonFinal;
    }

    public String getArch() {
        this.arch = this.arch.contains("64") ? "x64" : this.arch;
        return this.arch;
    }

    public boolean isArch64() {
        return this.getArch().contains("64");
    }

    public String toString() {
        return String.format("%s %s %s", this.getVersion().toJdkStyle(), this.getArch(), this.getVendor());
    }
}

