/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.recovery.ui.prompt;

import com.maltego.recovery.ui.BackupMetadata;
import com.maltego.recovery.ui.prompt.BackupMetadataChildren;
import com.paterva.maltego.util.ui.components.PanelWithMatteBorderAllSides;
import com.paterva.maltego.util.ui.outline.OutlineViewPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.swing.etable.ETableColumnModel;
import org.netbeans.swing.outline.DefaultOutlineCellRenderer;
import org.netbeans.swing.outline.Outline;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class RecoveryPromptPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private final OutlineViewPanel outlineViewPanel = new OutlineViewPanel("Recovered Graphs");
    private final ExplorerManager explorerManager = new ExplorerManager();
    private Box.Filler bottomFiller;
    private Box.Filler centerFiller;
    private JLabel headerLabel;
    private JPanel headerPanel;
    private JLabel iconLabel;
    private Box.Filler leftFiller;
    private JScrollPane messageScrollPane;
    private JTextArea messageTextArea;
    private JPanel recoveryPanel;
    private JScrollPane recoveryScrollPane;
    private Box.Filler rightFiller;

    public RecoveryPromptPanel() {
        this(Collections.EMPTY_LIST);
    }

    public RecoveryPromptPanel(List<BackupMetadata> backups) {
        this.initComponents();
        this.configureOutlineView();
        for (BackupMetadata backup : backups) {
            backup.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)backup));
        }
        BackupMetadataChildren children = new BackupMetadataChildren(backups);
        AbstractNode root = new AbstractNode((Children)children);
        this.explorerManager.setRootContext((Node)root);
        PanelWithMatteBorderAllSides outerPanel = new PanelWithMatteBorderAllSides((LayoutManager)new BorderLayout());
        outerPanel.add((Component)this.outlineViewPanel, "Center");
        outerPanel.setPreferredSize(this.recoveryScrollPane.getSize());
        this.recoveryScrollPane.setViewportView((Component)outerPanel);
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        SwingUtilities.invokeLater(() -> this.outlineViewPanel.getView().repaint());
    }

    private void configureOutlineView() {
        this.outlineViewPanel.setSearchable(false);
        OutlineView outlineView = this.outlineViewPanel.getView();
        Outline outline = outlineView.getOutline();
        outline.setColumnHidingAllowed(false);
        outline.setColumnModel((TableColumnModel)new ETableColumnModel(){

            public void moveColumn(int columnIndex, int newIndex) {
            }
        });
        outlineView.setPropertyColumns(new String[]{"last_backup", "Last Backup Time"});
        outlineView.setPropertyColumnDescription("last_backup", "Last Backup Time");
        outline.setAutoResizeMode(2);
        outline.setTableHeader(null);
        outline.setDefaultRenderer(Node.Property.class, (TableCellRenderer)((Object)new RecoveryCellRenderer()));
        TableColumnModel columns = outline.getColumnModel();
        columns.getColumn(0).setPreferredWidth(150);
        outline.setRowSorter(null);
        outline.setRowHeight(40);
        outline.setShowHorizontalLines(false);
        outline.setShowVerticalLines(false);
        outline.setRowSelectionAllowed(false);
        outline.setSelectionModel((ListSelectionModel)new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int index0, int index1) {
            }
        });
    }

    private void initComponents() {
        this.leftFiller = new Box.Filler(new Dimension(20, 0), new Dimension(20, 0), new Dimension(20, Short.MAX_VALUE));
        this.headerPanel = new JPanel();
        this.iconLabel = new JLabel();
        this.headerLabel = new JLabel();
        this.centerFiller = new Box.Filler(new Dimension(0, 20), new Dimension(0, 20), new Dimension(Short.MAX_VALUE, 20));
        this.messageScrollPane = new JScrollPane();
        this.messageTextArea = new JTextArea();
        this.recoveryPanel = new JPanel();
        this.recoveryScrollPane = new JScrollPane();
        this.bottomFiller = new Box.Filler(new Dimension(0, 20), new Dimension(0, 20), new Dimension(Short.MAX_VALUE, 20));
        this.rightFiller = new Box.Filler(new Dimension(20, 0), new Dimension(20, 0), new Dimension(20, Short.MAX_VALUE));
        this.iconLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/maltego/recovery/ui/prompt/alert-triangle.png")));
        this.headerLabel.setText(NbBundle.getMessage(RecoveryPromptPanel.class, (String)"RecoveryPromptPanel.headerLabel.text", (Object[])new Object[0]));
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanelLayout.createSequentialGroup().addComponent(this.iconLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headerLabel).addContainerGap(228, Short.MAX_VALUE)));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iconLabel, -1, -1, Short.MAX_VALUE).addComponent(this.headerLabel, -1, 24, Short.MAX_VALUE));
        this.messageScrollPane.setBorder(null);
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setColumns(20);
        this.messageTextArea.setFont(this.messageTextArea.getFont().deriveFont((float)this.messageTextArea.getFont().getSize() + 2.0f));
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setRows(2);
        this.messageTextArea.setText(NbBundle.getMessage(RecoveryPromptPanel.class, (String)"RecoveryPromptPanel.messageTextArea.text"));
        this.messageTextArea.setWrapStyleWord(true);
        this.messageTextArea.setBorder(null);
        this.messageTextArea.setDisabledTextColor(new Color(255, 255, 255));
        this.messageTextArea.setEnabled(false);
        this.messageScrollPane.setViewportView(this.messageTextArea);
        this.recoveryPanel.setLayout(new BorderLayout());
        this.recoveryPanel.add((Component)this.recoveryScrollPane, "Center");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.leftFiller, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bottomFiller, -1, -1, Short.MAX_VALUE).addComponent(this.headerPanel, -1, -1, Short.MAX_VALUE).addComponent(this.centerFiller, -1, -1, Short.MAX_VALUE).addComponent(this.recoveryPanel, -1, -1, Short.MAX_VALUE).addComponent(this.messageScrollPane)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rightFiller, -2, -1, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.headerPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.centerFiller, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.messageScrollPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.recoveryPanel, -1, 328, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bottomFiller, -2, -1, -2)).addComponent(this.leftFiller, -1, -1, Short.MAX_VALUE).addComponent(this.rightFiller, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
    }

    private class RecoveryCellRenderer
    extends DefaultOutlineCellRenderer {
        private RecoveryCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel cell = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Node.Property property = (Node.Property)value;
            cell.setText(property.getHtmlDisplayName());
            cell.setToolTipText(property.getShortDescription());
            return cell;
        }
    }
}

