/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.imex;

import com.paterva.maltego.graph.table.ui.imex.MappingExistInfo;
import com.paterva.maltego.graph.table.ui.imex.SelectableMapping;
import com.paterva.maltego.importexport.ConfigNode;
import java.awt.Image;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

class MappingNode
extends ConfigNode {
    private boolean _isCheckEnabled = true;

    public MappingNode(SelectableMapping mapping, MappingExistInfo existInfo) {
        this(mapping, new InstanceContent(), existInfo);
    }

    private MappingNode(SelectableMapping mapping, InstanceContent content, MappingExistInfo existInfo) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.addLookups(content, mapping);
        String displayName = mapping.getMapping().getName();
        if (existInfo != null && existInfo.exist(mapping.getMapping())) {
            if (existInfo.isReadOnly(mapping.getMapping())) {
                displayName = "<read-only> " + displayName;
                this._isCheckEnabled = false;
            } else {
                displayName = "<exist> " + displayName;
            }
        }
        this.setDisplayName(displayName);
        this.setShortDescription(mapping.getMapping().getDescription());
        this.setSelectedNonRecursive(mapping.isSelected());
    }

    public boolean isCheckEnabled() {
        return this._isCheckEnabled;
    }

    private void addLookups(InstanceContent content, SelectableMapping mapping) {
        content.add((Object)mapping);
        content.add((Object)this);
    }

    public final void setSelectedNonRecursive(Boolean selected) {
        if (!this.isSelected().equals(selected)) {
            super.setSelectedNonRecursive(selected);
            SelectableMapping mapping = (SelectableMapping)this.getLookup().lookup(SelectableMapping.class);
            mapping.setSelected(selected);
        }
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"com/paterva/maltego/graph/table/ui/resources/Table.png", (boolean)true);
    }
}

