/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.wizard;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.table.io.convert.TabularGraphConvertResult;
import com.paterva.maltego.graph.table.io.convert.TabularGraphImportResult;
import com.paterva.maltego.util.ui.components.MatteBorderLeft;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ImportSuccessPanel
extends JPanel {
    private TabularGraphImportResult _result;
    private final Color _errorDarkColor = UIManager.getLookAndFeelDefaults().getColor("7-dark-red");
    private JLabel _errorsLabel;
    private JPanel _errorsPanel;
    private JScrollPane _errorsScrollPane;
    private JTextArea _errorsTextArea;
    private JTextArea _overviewTextArea;
    private ButtonGroup buttonGroup1;

    public ImportSuccessPanel() {
        this.initComponents();
    }

    public void setResult(TabularGraphImportResult result) {
        this._result = result;
        this._overviewTextArea.setText(this.getOverviewText());
        this._errorsPanel.setVisible(false);
        this._errorsLabel.setVisible(false);
        this._errorsScrollPane.setVisible(false);
        this._errorsTextArea.setVisible(false);
        TabularGraphConvertResult convertResult = result.getConvertResult();
        if (!convertResult.getErrors().isEmpty()) {
            this._errorsPanel.setVisible(true);
            this._errorsLabel.setVisible(true);
            this._errorsScrollPane.setVisible(true);
            this._errorsTextArea.setVisible(true);
            StringBuilder errorText = new StringBuilder();
            for (String error : convertResult.getErrors()) {
                errorText.append(error);
                errorText.append("\n");
            }
            this._errorsTextArea.setText(errorText.toString());
        }
    }

    private String getOverviewText() {
        TabularGraphConvertResult result = this._result.getConvertResult();
        int entityCount = 0;
        int linkCount = 0;
        try {
            GraphID graphID = result.getGraphID();
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            entityCount = structureReader.getEntityCount();
            linkCount = structureReader.getLinkCount();
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        StringBuilder statsText = new StringBuilder();
        statsText.append("Imported items:\n");
        statsText.append(String.format("%6d", result.getRowsSucceeded() + result.getRowsFailed()));
        statsText.append(" Rows imported (");
        statsText.append(result.getRowsSucceeded());
        statsText.append(" succeeded - ");
        statsText.append(result.getRowsFailed());
        statsText.append(" failed)\n");
        statsText.append(String.format("%6d", entityCount));
        statsText.append(" Entities created\n");
        statsText.append(String.format("%6d", linkCount));
        statsText.append(" Links created\n\n");
        statsText.append("Click Finish to open the graph in a new window.\n");
        statsText.append("Click Cancel to discard the graph.");
        return statsText.toString();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        JPanel jPanel1 = new JPanel();
        JLabel jLabel1 = new JLabel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this._overviewTextArea = new JTextArea();
        this._errorsPanel = new JPanel();
        this._errorsLabel = new JLabel();
        this._errorsScrollPane = new JScrollPane();
        this._errorsTextArea = new JTextArea();
        this.setLayout(new GridBagLayout());
        jPanel1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel1.setLayout(new BorderLayout(10, 10));
        jLabel1.setFont(new JLabel().getFont().deriveFont(1, (float)new JLabel().getFont().getSize() + 1.0f));
        jLabel1.setText(NbBundle.getMessage(ImportSuccessPanel.class, (String)"ImportSuccessPanel.jLabel1.text"));
        jPanel1.add((Component)jLabel1, "North");
        jScrollPane1.setBackground(new JPanel().getBackground());
        jScrollPane1.setBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), NbBundle.getMessage(ImportSuccessPanel.class, (String)"ImportSuccessPanel.jScrollPane1.border.title")));
        this._overviewTextArea.setEditable(false);
        this._overviewTextArea.setBackground(this.getBackground());
        this._overviewTextArea.setColumns(20);
        this._overviewTextArea.setLineWrap(true);
        this._overviewTextArea.setRows(7);
        this._overviewTextArea.setText(NbBundle.getMessage(ImportSuccessPanel.class, (String)"ImportSuccessPanel._overviewTextArea.text"));
        this._overviewTextArea.setWrapStyleWord(true);
        this._overviewTextArea.setOpaque(false);
        jScrollPane1.setViewportView(this._overviewTextArea);
        jPanel1.add((Component)jScrollPane1, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel1, gridBagConstraints);
        this._errorsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._errorsPanel.setLayout(new BorderLayout(5, 5));
        this._errorsLabel.setFont(new JLabel().getFont().deriveFont(1));
        this._errorsLabel.setForeground(this._errorDarkColor);
        this._errorsLabel.setText(NbBundle.getMessage(ImportSuccessPanel.class, (String)"ImportSuccessPanel._errorsLabel.text"));
        this._errorsPanel.add((Component)this._errorsLabel, "North");
        this._errorsTextArea.setEditable(false);
        this._errorsTextArea.setForeground(this._errorDarkColor);
        this._errorsTextArea.setText(NbBundle.getMessage(ImportSuccessPanel.class, (String)"ImportSuccessPanel._errorsTextArea.text"));
        this._errorsTextArea.setWrapStyleWord(true);
        this._errorsScrollPane.setViewportView(this._errorsTextArea);
        this._errorsPanel.add((Component)this._errorsScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this._errorsPanel, gridBagConstraints);
    }
}

