/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.impl;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutMods;
import com.paterva.maltego.graph.store.views.collect.CollectionNodeLayoutReader;
import com.paterva.maltego.graph.store.views.impl.CollectionNodes;
import com.paterva.maltego.graph.store.views.impl.structures.ViewLink;
import com.paterva.maltego.graph.store.views.impl.tools.CollectionUtils;
import java.awt.Point;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class UpdateLayout {
    private final CollectionNodes _collectionNodes;

    UpdateLayout(CollectionNodes collectionNodes) {
        this._collectionNodes = collectionNodes;
    }

    private void updateViewCentersToModelAverage(GraphLayoutMods viewLayoutMods, Map<EntityID, Point> modelCenters) throws GraphStoreException {
        modelCenters = this.removeSamePointEntities(modelCenters);
        Map viewCenters = viewLayoutMods.getCenters();
        HashMap<EntityID, LinkedList<Point>> allViewCenters = new HashMap<EntityID, LinkedList<Point>>();
        for (Map.Entry<EntityID, Point> entry : modelCenters.entrySet()) {
            EntityID modelEntityID = entry.getKey();
            Point center = entry.getValue();
            EntityID viewEntityID = this._collectionNodes.getViewEntity(modelEntityID);
            LinkedList<Point> centers = (LinkedList<Point>)allViewCenters.get(viewEntityID);
            if (centers == null) {
                centers = new LinkedList<Point>();
                allViewCenters.put(viewEntityID, centers);
            }
            centers.add(center);
        }
        for (Map.Entry<Object, Point> entry : allViewCenters.entrySet()) {
            EntityID viewEntityID = (EntityID)entry.getKey();
            List centers = (List)((Object)entry.getValue());
            viewCenters.put(viewEntityID, CollectionUtils.getMean(centers));
        }
    }

    private Map<EntityID, Point> removeSamePointEntities(Map<EntityID, Point> modelCenters) {
        Point point;
        HashMap<Point, EntityID> points = new HashMap<Point, EntityID>();
        for (Map.Entry<EntityID, Point> entry : modelCenters.entrySet()) {
            EntityID entityID = entry.getKey();
            point = entry.getValue();
            points.put(point, entityID);
        }
        HashMap<EntityID, Point> entities = new HashMap<EntityID, Point>();
        for (Map.Entry entry : points.entrySet()) {
            point = (Point)entry.getKey();
            EntityID entityID = (EntityID)entry.getValue();
            entities.put(entityID, point);
        }
        return entities;
    }

    public GraphLayoutMods update(GraphLayoutMods modelMods) throws GraphStoreException {
        Map modelCenters = modelMods.getCenters();
        GraphLayoutMods viewLayoutMods = new GraphLayoutMods();
        this.updateViewCentersToModelAverage(viewLayoutMods, modelCenters);
        Map modelPaths = modelMods.getPaths();
        Map<LinkID, ViewLink> viewLinks = this._collectionNodes.getViewLinks(modelPaths.keySet());
        Map viewPaths = viewLayoutMods.getPaths();
        for (Map.Entry<LinkID, ViewLink> entry : viewLinks.entrySet()) {
            LinkID viewLinkID = entry.getKey();
            ViewLink viewLink = entry.getValue();
            List modelPath = null;
            if (!viewLink.isCollection()) {
                modelPath = (List)modelPaths.get(viewLinkID);
            } else {
                LinkID modelLinkID;
                Iterator<LinkID> iterator = viewLink.getCollection().iterator();
                while (iterator.hasNext() && (modelPath = (List)modelPaths.get(modelLinkID = iterator.next())) == null) {
                }
            }
            if (modelPath == null) continue;
            List viewPath = (List)viewPaths.get(viewLinkID);
            if (viewPath == null) {
                viewPaths.put(viewLinkID, modelPath);
                continue;
            }
            if (viewPath.equals(modelPath)) continue;
            viewPaths.put(viewLinkID, CollectionNodeLayoutReader.STRAIGHT_PATH);
        }
        return viewLayoutMods;
    }
}

