/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.bookmarks.ui.BookmarkFactory;
import com.paterva.maltego.ui.graph.BookmarkUtils;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ui.GraphicsUtils;
import com.pinkmatter.api.flamingo.RibbonPresenter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.UIManager;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;

public class SelectBookmarkedAction
extends TopGraphAction
implements RibbonPresenter.Button {
    private JCommandButton _button;
    private static final int ICON_SIZE_LARGE_48 = IconSize.LARGE.getSize();

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.getRibbonButtonPresenter().setEnabled(value);
    }

    public String getName() {
        return "Select Bookmarked";
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/actions/Zoom.png";
    }

    public AbstractCommandButton getRibbonButtonPresenter() {
        if (this._button == null) {
            BookmarkFactory bookmarkFactory = BookmarkFactory.getDefault();
            final JCommandPopupMenu bookmarkMenu = new JCommandPopupMenu();
            int i = -1;
            while (i < bookmarkFactory.getBookmarkCount()) {
                final int bookmark = i++;
                JCommandMenuButton b2 = new JCommandMenuButton(null, (ResizableIcon)new ResizableBookmarkIcon(bookmark));
                b2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        SelectBookmarkedAction.this.selectBookmarked(bookmark, false);
                    }
                });
                bookmarkMenu.addMenuButton(b2);
            }
            MultiColorBookmarkIcon icon = new MultiColorBookmarkIcon();
            this._button = new JCommandButton(this.getName(), (ResizableIcon)icon);
            this._button.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
            MultiColorBookmarkIcon resizableIcon = new MultiColorBookmarkIcon();
            resizableIcon.setDimension(new Dimension(ICON_SIZE_LARGE_48, ICON_SIZE_LARGE_48));
            BufferedImage iconImage = new BufferedImage(ICON_SIZE_LARGE_48, ICON_SIZE_LARGE_48, 2);
            resizableIcon.paintIcon((Component)this._button, iconImage.createGraphics(), 0, 0);
            RichTooltip tooltip = new RichTooltip("Select Bookmarked", "Select bookmarked entities");
            tooltip.setMainImage((Image)iconImage);
            tooltip.addFooterSection("Click the help button to get more help on Maltego features");
            tooltip.setFooterImage(ImageUtilities.loadImage((String)"com/paterva/maltego/welcome/resources/Help.png"));
            this._button.setActionRichTooltip(tooltip);
            this._button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    SelectBookmarkedAction.this.selectBookmarked(-1, true);
                }
            });
            this._button.setPopupCallback(new PopupPanelCallback(){

                public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                    return bookmarkMenu;
                }
            });
        }
        return this._button;
    }

    @Override
    protected void actionPerformed(TopComponent tc) {
    }

    private void selectBookmarked(int bookmark, boolean invert) {
        TopComponent activated = this.getTopComponent();
        BookmarkUtils.selectBookmarked(activated, this.getTopGraphID(), bookmark, invert);
    }

    private static class MultiColorBookmarkIcon
    extends ResizableSquareIcon {
        private MultiColorBookmarkIcon() {
        }

        public void paintIcon(Component c, Graphics g, int xPos, int yPos) {
            if (g instanceof Graphics2D) {
                Graphics2D g2D = (Graphics2D)g;
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                AffineTransform oldTransform = g2D.getTransform();
                double scale = 0.1f;
                g2D.scale(scale, scale);
                int x = (int)((double)xPos / scale);
                int y2 = (int)((double)yPos / scale);
                int h = (int)((double)this.getIconHeight() / scale);
                g2D.translate(x, y2);
                Color color = UIManager.getLookAndFeelDefaults().getColor("bookmark-none-color");
                GraphicsUtils.drawBookMark((Graphics2D)g2D, (int)0, (int)0, (int)h, (int)h, (Color)color, (boolean)false);
                g2D.setTransform(oldTransform);
            }
        }
    }

    private static class ResizableBookmarkIcon
    extends ResizableSquareIcon {
        private final int _bookmark;

        public ResizableBookmarkIcon(int bookmark) {
            this._bookmark = bookmark;
        }

        public void paintIcon(Component c, Graphics g, int x, int y2) {
            BookmarkFactory.getDefault().getIcon(Integer.valueOf(this._bookmark), this.getIconWidth()).paintIcon(c, g, x, y2);
        }
    }

    private static abstract class ResizableSquareIcon
    implements ResizableIcon {
        private int _size;

        private ResizableSquareIcon() {
        }

        public void setDimension(Dimension d) {
            this._size = Math.min(d.width, d.height);
        }

        public int getIconWidth() {
            return this._size;
        }

        public int getIconHeight() {
            return this._size;
        }
    }
}

