/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.treelist.parts.link;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.treelist.lazy.LazyTreelistSettings;
import com.paterva.maltego.treelist.parts.PartNode;
import com.paterva.maltego.treelist.parts.PartsTable;
import com.paterva.maltego.treelist.parts.link.LinkTable;
import com.paterva.maltego.util.ui.GraphicsUtils;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openide.util.Exceptions;

class LinkHoverableIconRenderer
extends JLabel
implements TableCellRenderer {
    private static final Logger LOG = Logger.getLogger(LinkHoverableIconRenderer.class.getName());
    private final LinkTable _table;
    private final int _iconSize;

    LinkHoverableIconRenderer(LinkTable table) {
        this.setOpaque(true);
        this._table = table;
        this._iconSize = LazyTreelistSettings.getDefault().getIconSize()[this._table.isSmall() ? 0 : 1];
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        PartsTable partsTable = (PartsTable)((Object)table);
        PartNode partNode = (PartNode)value;
        GraphID graphID = this._table.getTreelistModel().getGraphID();
        LinkID linkID = (LinkID)partNode.getPartID();
        if (LOG.isLoggable(Level.FINE)) {
            try {
                GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
                GraphModelViewMappings mappings = view.getModelViewMappings();
                if (mappings.getViewLink(linkID) == null) {
                    LOG.log(Level.FINE, "Entity: {0} {1} {2} {3}", new Object[]{linkID, mappings.isViewLink(linkID), mappings.isModelLink(linkID), mappings.getViewLink(linkID)});
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        column = table.convertColumnIndexToModel(column);
        boolean hovered = partsTable.isHovered(linkID, column);
        Icon icon = null;
        switch (column - 1) {
            case 0: {
                icon = this.getInspectIcon(hovered);
            }
        }
        this.setIcon(icon);
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        this.setHorizontalAlignment(0);
        return this;
    }

    private Icon getInspectIcon(boolean hovered) {
        return GraphicsUtils.getInspectIcon((int)this._iconSize, (boolean)hovered);
    }
}

