/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui.serialize;

import com.paterva.maltego.util.XmlSerializationException;
import com.paterva.maltego.util.XmlSerializer;
import com.paterva.maltego.view.customization.api.Binding;
import com.paterva.maltego.view.customization.api.Customizable;
import com.paterva.maltego.view.customization.api.CustomizableRegistry;
import com.paterva.maltego.view.customization.api.Viewlet;
import com.paterva.maltego.view.customization.api.ViewletSerializer;
import com.paterva.maltego.view.customization.ui.binding.BindingImpl;
import com.paterva.maltego.view.customization.ui.main.ViewletImpl;
import com.paterva.maltego.view.customization.ui.script.BindingScriptImpl;
import com.paterva.maltego.view.customization.ui.serialize.BindingScriptStub;
import com.paterva.maltego.view.customization.ui.serialize.BindingStub;
import com.paterva.maltego.view.customization.ui.serialize.ViewletStub;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class DefaultViewletSerializer
extends ViewletSerializer {
    public Viewlet read(String viewID, InputStream is) throws XmlSerializationException {
        XmlSerializer serializer = new XmlSerializer();
        ViewletStub stub = (ViewletStub)serializer.read(ViewletStub.class, is);
        return this.translate(viewID, stub);
    }

    public void write(String viewID, Viewlet viewlet, OutputStream os) throws XmlSerializationException {
        XmlSerializer serializer = new XmlSerializer();
        ViewletStub stub = this.translate(viewlet);
        serializer.write((Object)stub, os);
    }

    private Viewlet translate(String viewID, ViewletStub stub) {
        ViewletImpl viewlet = new ViewletImpl(stub.getName());
        for (BindingStub bindingStub : stub.getBindings()) {
            Binding binding = this.translate(viewID, bindingStub);
            if (binding == null) continue;
            viewlet.getBindings().add(binding);
        }
        return viewlet;
    }

    private ViewletStub translate(Viewlet viewlet) {
        ViewletStub viewletStub = new ViewletStub();
        viewletStub.setName(viewlet.getName());
        ArrayList<BindingStub> bindingStubs = new ArrayList<BindingStub>();
        for (Binding binding : viewlet.getBindings()) {
            BindingStub bindingStub = this.translate(binding);
            bindingStubs.add(bindingStub);
        }
        viewletStub.setBindings(bindingStubs);
        return viewletStub;
    }

    private BindingStub translate(Binding binding) {
        BindingStub stub = new BindingStub();
        stub.setCustomizable(binding.getCustomizable().getName());
        BindingScriptStub scriptStub = new BindingScriptStub();
        scriptStub.setEngine(binding.getScript().getScriptEngineName());
        scriptStub.setText(binding.getScript().getText());
        stub.setScript(scriptStub);
        return stub;
    }

    private Binding translate(String viewID, BindingStub stub) {
        BindingImpl binding = new BindingImpl();
        List customizables = CustomizableRegistry.getDefault().get(viewID);
        Customizable customizable = null;
        for (Customizable c : customizables) {
            if (!stub.getCustomizable().equals(c.getName())) continue;
            customizable = c;
            break;
        }
        if (customizable == null) {
            System.out.println("WARNING - View \"" + viewID + "\" does not support customizable \"" + stub.getCustomizable() + "\"");
            return null;
        }
        binding.setCustomizable(customizable);
        BindingScriptStub scriptStub = stub.getScript();
        BindingScriptImpl script = new BindingScriptImpl(scriptStub.getEngine(), scriptStub.getText());
        binding.setScript(script);
        return binding;
    }
}

