/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import org.openide.util.ChangeSupport;

public class InactivityListener
implements ActionListener {
    private static InactivitySingleton _singleton = null;
    public static final long KEY_EVENTS = 8L;
    public static final long MOUSE_EVENTS = 48L;
    public static final long USER_EVENTS = 56L;
    private AWTListener _awtListener;
    private boolean _isActive = true;
    private ActionListener _inactiveAction;
    private ActionListener _activeAction;
    private Timer _timer = new Timer(0, this);

    public InactivityListener(ActionListener inactiveAction, ActionListener activeAction, int timeOutMillis) {
        this._inactiveAction = inactiveAction;
        this._activeAction = activeAction;
        this._timer.setInitialDelay(timeOutMillis);
        this._timer.setRepeats(false);
    }

    public static synchronized InactivitySingleton getSingleton() {
        if (_singleton == null) {
            _singleton = new InactivitySingleton();
        }
        return _singleton;
    }

    public boolean isActive() {
        return this._isActive;
    }

    protected void setActive(boolean isActive) {
        if (isActive != this._isActive) {
            ActionListener action;
            this._isActive = isActive;
            ActionListener actionListener = action = this._isActive ? this._activeAction : this._inactiveAction;
            if (action != null) {
                action.actionPerformed(null);
            }
        }
    }

    public synchronized void start() {
        if (!this._timer.isRunning()) {
            this._timer.start();
        }
        if (this._awtListener == null) {
            this._awtListener = new AWTListener();
            Toolkit.getDefaultToolkit().addAWTEventListener(this._awtListener, 56L);
        }
    }

    public synchronized void stop() {
        if (this._awtListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this._awtListener);
            this._awtListener = null;
        }
        if (this._timer.isRunning()) {
            this._timer.stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setActive(false);
    }

    public static class InactivitySingleton
    extends InactivityListener {
        private ChangeSupport _changeSupport = new ChangeSupport((Object)this);

        public InactivitySingleton() {
            super(null, null, 300000);
        }

        @Override
        protected void setActive(boolean isActive) {
            if (isActive != this.isActive()) {
                super.setActive(isActive);
                this._changeSupport.fireChange();
            }
        }

        public void addChangeListener(ChangeListener listener) {
            this._changeSupport.addChangeListener(listener);
            this.start();
        }

        public void removeChangeListener(ChangeListener listener) {
            this._changeSupport.removeChangeListener(listener);
            if (!this._changeSupport.hasListeners()) {
                this.stop();
            }
        }
    }

    private class AWTListener
    implements AWTEventListener {
        private AWTListener() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (InactivityListener.this._timer.isRunning()) {
                InactivityListener.this._timer.restart();
            } else {
                InactivityListener.this._timer.start();
            }
            InactivityListener.this.setActive(true);
        }
    }
}

