/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion.inference;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.groovy.editor.api.ASTUtils;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.completion.inference.TypeInferenceVisitor;

public final class MethodInference {
    private MethodInference() {
    }

    @CheckForNull
    public static ClassNode findCallerType(@NonNull ASTNode expression, @NonNull AstPath path, BaseDocument baseDocument, int offset) {
        MethodCallExpression methodCall;
        ClassNode callerType;
        if (expression instanceof MethodCallExpression && (callerType = MethodInference.findCallerType((ASTNode)(methodCall = (MethodCallExpression)expression).getObjectExpression(), path, baseDocument, offset)) != null) {
            return MethodInference.findReturnTypeFor(callerType.redirect(), methodCall.getMethodAsString(), methodCall.getArguments(), path, false, baseDocument, offset);
        }
        if (expression instanceof VariableExpression) {
            int newOffset = ASTUtils.getOffset(baseDocument, expression.getLineNumber(), expression.getColumnNumber());
            AstPath newPath = new AstPath(path.root(), newOffset, baseDocument);
            TypeInferenceVisitor tiv = new TypeInferenceVisitor(((ModuleNode)path.root()).getContext(), newPath, baseDocument, newOffset);
            tiv.collect();
            return tiv.getGuessedType();
        }
        if (expression instanceof ConstantExpression) {
            return ((ConstantExpression)expression).getType();
        }
        if (expression instanceof ClassExpression) {
            return ClassHelper.make((String)((ClassExpression)expression).getType().getName());
        }
        if (expression instanceof StaticMethodCallExpression) {
            StaticMethodCallExpression staticMethodCall = (StaticMethodCallExpression)expression;
            return MethodInference.findReturnTypeFor(staticMethodCall.getOwnerType().redirect(), staticMethodCall.getMethod(), staticMethodCall.getArguments(), path, true, baseDocument, offset);
        }
        return null;
    }

    @CheckForNull
    private static ClassNode findReturnTypeFor(@NonNull ClassNode callerType, @NonNull String methodName, @NonNull Expression arguments, @NonNull AstPath path, @NonNull boolean isStatic, @NonNull BaseDocument baseDocument, @NonNull int offset) {
        MethodNode possibleMethod;
        ArrayList<ClassNode> paramTypes = new ArrayList<ClassNode>();
        if (arguments instanceof ArgumentListExpression) {
            ArgumentListExpression argExpression = (ArgumentListExpression)arguments;
            for (Expression e : argExpression.getExpressions()) {
                if (e instanceof VariableExpression) {
                    ModuleNode moduleNode = (ModuleNode)path.root();
                    int newOffset = ASTUtils.getOffset(baseDocument, e.getLineNumber(), e.getColumnNumber());
                    AstPath newPath = new AstPath((ASTNode)moduleNode, newOffset, baseDocument);
                    TypeInferenceVisitor tiv = new TypeInferenceVisitor(moduleNode.getContext(), newPath, baseDocument, newOffset);
                    tiv.collect();
                    ClassNode guessedType = tiv.getGuessedType();
                    if (null == guessedType) {
                        System.out.println("Bad guessed type");
                        continue;
                    }
                    paramTypes.add(tiv.getGuessedType());
                    continue;
                }
                if (e instanceof ConstantExpression) {
                    paramTypes.add(((ConstantExpression)e).getType());
                    continue;
                }
                if (e instanceof MethodCallExpression) {
                    paramTypes.add(MethodInference.findCallerType((ASTNode)e, path, baseDocument, offset));
                    continue;
                }
                if (e instanceof BinaryExpression) {
                    BinaryExpression binExpression = (BinaryExpression)e;
                    paramTypes.add(binExpression.getType());
                    continue;
                }
                if (e instanceof ClassExpression) {
                    ClassExpression classExpression = (ClassExpression)e;
                    paramTypes.add(GenericsUtils.makeClassSafeWithGenerics(Class.class, (ClassNode)classExpression.getType()));
                    continue;
                }
                System.out.println(e.getClass());
            }
        }
        if ((possibleMethod = MethodInference.tryFindPossibleMethod(callerType, methodName, paramTypes, isStatic)) != null) {
            return possibleMethod.getReturnType();
        }
        return null;
    }

    private static MethodNode tryFindPossibleMethod(ClassNode callerType, String methodName, List<ClassNode> paramTypes, boolean isStatic) {
        int count = paramTypes.size();
        MethodNode res = null;
        ClassNode node = callerType;
        ArrayDeque<ClassNode> tq = new ArrayDeque<ClassNode>();
        tq.add(callerType.redirect());
        while ((node = (ClassNode)tq.poll()) != null) {
            for (ClassNode in : node.getInterfaces()) {
                tq.add(in.redirect());
            }
            for (MethodNode method : node.getMethods(methodName)) {
                int i;
                if (isStatic && !method.isStatic() || method.getParameters().length != count) continue;
                boolean match = true;
                for (i = 0; i != count; ++i) {
                    if (paramTypes.get(i).isDerivedFrom(method.getParameters()[i].getType())) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                if (res == null) {
                    res = method;
                    continue;
                }
                if (res.getParameters().length != count) {
                    return null;
                }
                if (node.equals((Object)callerType)) {
                    return null;
                }
                match = true;
                for (i = 0; i != count; ++i) {
                    if (res.getParameters()[i].getType().equals((Object)method.getParameters()[i].getType())) continue;
                    match = false;
                    break;
                }
                if (match) continue;
                return null;
            }
            if ((node = node.getSuperClass()) == null) continue;
            tq.add(node.redirect());
        }
        return res;
    }
}

