/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.imex;

import com.paterva.maltego.util.XMLEscapeUtils;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import yguard.A.H.B.B.Z;

public class StaxHelper {
    private StaxHelper() {
    }

    public static String getRequiredAttribute(XMLStreamReader reader, String name) throws IOException {
        String attr = XMLEscapeUtils.unescapeUnicode((String)reader.getAttributeValue(null, name));
        if (attr == null) {
            throw new Z("Mandatory attribute does not exist: " + name);
        }
        return attr;
    }

    public static String getOptionalAttribute(XMLStreamReader reader, String name, String defaultValue) {
        String attr = XMLEscapeUtils.unescapeUnicode((String)reader.getAttributeValue(null, name));
        if (attr == null) {
            attr = defaultValue;
        }
        return attr;
    }

    public static boolean getBooleanAttribute(XMLStreamReader reader, String name, boolean defaultValue) {
        String attr = reader.getAttributeValue(null, name);
        return attr == null ? defaultValue : attr.equalsIgnoreCase("true");
    }

    public static boolean isStartElement(XMLStreamReader reader, String name) {
        return reader.isStartElement() && name.equals(reader.getLocalName());
    }

    public static boolean isEndElement(XMLStreamReader reader, String name) {
        return reader.isEndElement() && name.equals(reader.getLocalName());
    }

    public static boolean skipToElement(XMLStreamReader reader, String name) throws XMLStreamException {
        while (reader.hasNext()) {
            if (reader.next() != 1 || !name.equals(reader.getLocalName())) continue;
            return true;
        }
        return false;
    }

    public static String readCData(XMLStreamReader reader, String nodeName) throws XMLStreamException {
        StringBuilder sb = new StringBuilder();
        do {
            int event;
            if ((event = reader.next()) != 12) continue;
            sb.append(XMLEscapeUtils.unescapeUnicode((String)reader.getText()));
        } while (!StaxHelper.isEndElement(reader, nodeName));
        return sb.toString();
    }
}

