/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.nodes;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import com.paterva.maltego.transform.descriptor.Visibility;
import com.paterva.maltego.transform.manager.nodes.TransformNode;
import com.paterva.maltego.util.repository.RepositoryEvent;
import com.paterva.maltego.util.repository.RepositoryListener;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.WeakListeners;

public class AllTransformsChildFactory
extends ChildFactory<TransformDefinition>
implements NodeListener,
RepositoryListener {
    private String[] _repositories;
    private boolean _checked;

    public AllTransformsChildFactory(String[] repositories) {
        this(repositories, false);
    }

    public AllTransformsChildFactory(String[] repositories, boolean checked) {
        this._repositories = repositories;
        this._checked = checked;
    }

    public void onShow() {
        TransformRepositoryRegistry registry = TransformRepositoryRegistry.getDefault();
        for (String repo : this._repositories) {
            TransformRepository repository = registry.getRepository(repo);
            repository.addRepositoryListener((RepositoryListener)this);
        }
    }

    public void onHide() {
        TransformRepositoryRegistry registry = TransformRepositoryRegistry.getDefault();
        for (String repo : this._repositories) {
            TransformRepository repository = registry.getRepository(repo);
            repository.removeRepositoryListener((RepositoryListener)this);
        }
    }

    protected boolean createKeys(List<TransformDefinition> toFill) {
        TransformRepositoryRegistry registry = TransformRepositoryRegistry.getDefault();
        for (String repo : this._repositories) {
            this.addRepository(registry.getRepository(repo), toFill);
        }
        Collections.sort(toFill, new Comparator<TransformDefinition>(){

            @Override
            public int compare(TransformDefinition o1, TransformDefinition o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        return true;
    }

    private void addRepository(TransformRepository repository, List<TransformDefinition> toFill) {
        if (repository != null) {
            TransformServerRegistry servers = TransformServerRegistry.getDefault();
            for (TransformDefinition def : repository.getAll()) {
                if (def.getVisibility() == Visibility.Hidden || !servers.exists(def.getName(), true)) continue;
                toFill.add(def);
            }
        }
    }

    protected Node createNodeForKey(TransformDefinition key) {
        TransformNode node = new TransformNode(key, this._checked);
        node.addNodeListener((NodeListener)WeakListeners.create(NodeListener.class, (EventListener)((Object)this), (Object)node));
        return node;
    }

    protected Node createWaitNode() {
        AbstractNode wait = new AbstractNode(Children.LEAF);
        wait.setDisplayName("Getting transforms...");
        return wait;
    }

    public void childrenAdded(NodeMemberEvent nme) {
    }

    public void childrenRemoved(NodeMemberEvent nme) {
    }

    public void childrenReordered(NodeReorderEvent nre) {
    }

    public void nodeDestroyed(NodeEvent ne) {
        this.refresh(true);
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void onItemAdded(RepositoryEvent evt) {
        this.refresh(true);
    }

    public void onItemChanged(RepositoryEvent evt) {
        this.refresh(true);
    }

    public void onItemRemoved(RepositoryEvent evt) {
        this.refresh(true);
    }
}

