/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol;

import com.paterva.maltego.transform.descriptor.ProtocolVersion;
import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.protocol.api.TransformTranslator;
import com.paterva.maltego.transform.protocol.v2api.V2TransformTranslator;
import com.paterva.maltego.transform.protocol.v3.api.V3TransformTranslator;
import java.util.Set;

public class TransformTranslatorFactory {
    private static TransformTranslatorFactory instance;

    public static synchronized TransformTranslatorFactory getDefault() {
        if (instance == null) {
            instance = new TransformTranslatorFactory();
        }
        return instance;
    }

    public TransformTranslator get(ProtocolVersion protocolVersion, Set<TransformSet> sets) {
        if (protocolVersion.equals((Object)ProtocolVersion.V2_0)) {
            return new V2TransformTranslator(sets);
        }
        if (protocolVersion.compareTo(ProtocolVersion.V3_0) >= 0) {
            return new V3TransformTranslator(sets);
        }
        throw new IllegalArgumentException(String.format("Failed to create a TransformSource for unsupported protocol version %s", protocolVersion));
    }
}

