/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph.state;

import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.Payload;
import com.paterva.maltego.collab.PayloadCollection;
import com.paterva.maltego.collab.graph.state.StateConnecting;
import com.paterva.maltego.collab.graph.state.StateGetHistoryGraph;
import com.paterva.maltego.collab.graph.state.StateSendingLocal;
import com.paterva.maltego.collab.graph.state.TxQueue;
import com.paterva.maltego.collab.session.PayloadHelper;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.SwingUtilities;

class StateGraphMerge
extends StateConnecting {
    private volatile boolean _transactionsDone = false;

    StateGraphMerge() {
    }

    @Override
    protected void run() {
        this.progress(LogMessageLevel.Info, "Attempting graph sync", 45);
        String id = this.lastAppliedTransactionID();
        this.debug("starting sync with ID " + id);
        PayloadCollection syncPoint = this.getSyncPoint(this.historyQueue().payloads(), id);
        if (syncPoint != null) {
            try {
                this.debug("found sync point");
                this.rx().payloadsReceived(syncPoint);
                this.rx().payloadsReceived(this.liveQueue().payloads());
                this.historyQueue().clear();
                this.liveQueue().clear();
                this.waitForEDT();
                this.setNextState(new StateSendingLocal());
            }
            catch (CollaborationException ex) {
                this.handleError("Error applying sync", (Exception)((Object)ex));
            }
        } else {
            this.debug("no sync point found - retrieving graph");
            this.setNextState(new StateGetHistoryGraph());
        }
    }

    private PayloadCollection getSyncPoint(PayloadCollection payloads, String id) {
        boolean startSync = false;
        PayloadCollection.List list = new PayloadCollection.List();
        for (Payload p : payloads) {
            if (startSync) {
                this.debug(String.format("history to apply: %s - %s", p.getType(), p.getID()));
                list.add(p);
            }
            if (!p.getID().equals(id)) continue;
            startSync = true;
        }
        if (startSync) {
            return list;
        }
        return null;
    }

    private Collection<String> getTransactions(Collection<TxQueue.Entry> localQueue) throws CollaborationException {
        ArrayList<String> batches = new ArrayList<String>();
        for (TxQueue.Entry entry : localQueue) {
            if (!PayloadHelper.isType("xaction", entry.getBody())) continue;
            batches.add(entry.getBody());
        }
        return batches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEDT() {
        this._transactionsDone = false;
        final Object waitObj = this.getStateMachine();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = waitObj;
                synchronized (object) {
                    StateGraphMerge.this._transactionsDone = true;
                    waitObj.notifyAll();
                }
            }
        });
        Object TStateMachine = waitObj;
        synchronized (TStateMachine) {
            while (!this._transactionsDone) {
                try {
                    waitObj.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

