/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.data;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.manager.data.CookieToSpecConverter;
import com.paterva.maltego.entity.manager.data.EntityDataNode;
import com.paterva.maltego.entity.manager.data.EntitySpecCookie;
import com.paterva.maltego.entity.manager.palette.FavouriteEntities;
import java.io.IOException;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;

public class EntityDataObject
extends MultiDataObject
implements EntitySpecCookie {
    private final Lookup _lookup;
    private MaltegoEntitySpec _spec;

    public EntityDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(pf, loader);
        CookieSet cookies = this.getCookieSet();
        cookies.add((Node.Cookie)DataEditorSupport.create((DataObject)this, (MultiDataObject.Entry)this.getPrimaryEntry(), (CookieSet)cookies));
        InstanceContent content = new InstanceContent();
        content.add((Object)this, (InstanceContent.Convertor)CookieToSpecConverter.instance());
        this._lookup = new ProxyLookup(new Lookup[]{this.getCookieSet().getLookup(), new AbstractLookup((AbstractLookup.Content)content)});
        this.setSpecAsync(pf);
    }

    protected Node createNodeDelegate() {
        return new EntityDataNode((DataObject)this, this.getLookup());
    }

    public Lookup getLookup() {
        return this._lookup != null ? this._lookup : Lookup.EMPTY;
    }

    @Override
    public MaltegoEntitySpec getEntitySpec() {
        return this._spec;
    }

    private void setSpecAsync(FileObject pf) {
        String typename = FavouriteEntities.stripFavHash(pf.getName());
        EntityRegistry.getDefault().getAsync(typename, spec -> {
            this._spec = spec;
        });
    }

    protected FileObject handleMove(DataFolder targetFolder) throws IOException {
        FileObject fo = this.getPrimaryFile();
        if (fo == null) {
            fo = super.getPrimaryFile();
        }
        if (targetFolder != null && FavouriteEntities.isFavCategory(targetFolder.getName()) || this.isNodeWithSameNameInCategory(targetFolder, fo)) {
            return fo;
        }
        return super.handleMove(targetFolder);
    }

    protected DataObject handleCopy(DataFolder targetFolder) throws IOException {
        FileObject fo = this.getPrimaryFile();
        if (fo == null) {
            fo = super.getPrimaryFile();
        }
        if (fo != null && (targetFolder != null && FavouriteEntities.isFavCategory(targetFolder.getName()) || this.isNodeWithSameNameInCategory(targetFolder, fo))) {
            return DataObject.find((FileObject)fo);
        }
        return super.handleCopy(targetFolder);
    }

    private boolean isNodeWithSameNameInCategory(DataFolder targetFolder, FileObject fo) {
        if (targetFolder != null) {
            DataObject[] children = targetFolder.getChildren();
            if (fo != null && children != null) {
                for (DataObject child : children) {
                    FileObject childFo = child.getPrimaryFile();
                    String foName = fo.getName();
                    if (foName == null || childFo == null || !foName.equalsIgnoreCase(childFo.getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

