/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions;

import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.actions.InvertEntityFilter;
import com.paterva.maltego.automation.actions.InvertFilter;

abstract class NumericFilterSupport
extends InvertFilter {
    public NumericFilterSupport(String name) {
        super(name);
    }

    public NumericFilterSupport(String name, double equalTo) {
        this(name);
        this.setValue(equalTo);
    }

    public NumericFilterSupport(String name, double moreThan, double lessThan) {
        this(name);
        this.putProperty("moreThan", moreThan);
        this.putProperty("lessThan", lessThan);
    }

    public double getMoreThan() {
        return NumericFilterSupport.getNumber(this.getProperty("moreThan"), Double.MIN_VALUE);
    }

    public double getMoreThanOrEqual() {
        return NumericFilterSupport.getNumber(this.getProperty("equalOrMoreThan"), Double.MIN_VALUE);
    }

    public double getLessThan() {
        return NumericFilterSupport.getNumber(this.getProperty("lessThan"), Double.MAX_VALUE);
    }

    public double getLessThanOrEqual() {
        return NumericFilterSupport.getNumber(this.getProperty("equalOrLessThan"), Double.MAX_VALUE);
    }

    public double getNumericEqualTo() {
        return NumericFilterSupport.getNumber(this.getValue(), Double.MIN_VALUE);
    }

    protected static boolean check(double value, double equalTo, double moreThan, double lessThan, double moreThanOrEqual, double lessThanOrEqual) {
        boolean result;
        if (equalTo != Double.MIN_VALUE) {
            return value == equalTo;
        }
        if (moreThanOrEqual != Double.MIN_VALUE) {
            result = value >= moreThanOrEqual;
        } else {
            boolean bl = result = value > moreThan;
        }
        result = lessThanOrEqual != Double.MAX_VALUE ? result && value <= lessThanOrEqual : result && value < lessThan;
        return result;
    }

    protected static abstract class NumericEntityFilter
    extends InvertEntityFilter {
        private double _lessThan;
        private double _lessThanOrEqual;
        private double _moreThan;
        private double _moreThanOrEqual;
        private double _equalTo;

        public NumericEntityFilter(AutomationContext ctx, double equalTo, double moreThan, double lessThan, double moreThanOrEqual, double lessThanOrEqual, boolean invert) {
            super(ctx, invert);
            this._lessThan = lessThan;
            this._moreThan = moreThan;
            this._lessThanOrEqual = lessThanOrEqual;
            this._moreThanOrEqual = moreThanOrEqual;
            this._equalTo = equalTo;
        }

        public double getLessThan() {
            return this._lessThan;
        }

        public double getMoreThan() {
            return this._moreThan;
        }

        public double getEqualTo() {
            return this._equalTo;
        }

        public double getMoreThanOrEqual() {
            return this._moreThanOrEqual;
        }

        public double getLessThanOrEqual() {
            return this._lessThanOrEqual;
        }
    }
}

