/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view.editor;

import com.paterva.maltego.automation.view.editor.MachineEditorControl;
import com.paterva.maltego.automation.view.editor.TransformDefinitionWrapper;
import com.paterva.maltego.automation.view.editor.TransformFilterUtils;
import com.paterva.maltego.automation.view.editor.TransformNode;
import com.paterva.maltego.automation.view.editor.TransformServerInfoWrapper;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.util.ui.outline.Filterable;
import com.paterva.maltego.util.ui.outline.FilterableHierarchySupport;
import java.awt.Image;
import java.util.List;
import java.util.stream.Collectors;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.lookup.Lookups;

class TasNode
extends AbstractNode {
    public TasNode(TransformServerInfo tas, MachineEditorControl machineEditControl) {
        this(tas, new TransformDefinitions(new TransformServerInfoWrapper(tas), machineEditControl));
    }

    private TasNode(TransformServerInfo tas, TransformDefinitions transformDefinitions) {
        super(Children.create((ChildFactory)new TasTransformChildFactory(transformDefinitions), (boolean)true), Lookups.fixed((Object[])new Object[]{tas, new FilterableHierarchySupport.Builder((Filterable)transformDefinitions.getTasWrapper()).child((Filterable)transformDefinitions).build()}));
        this.setDisplayName(tas.getDisplayName());
        this.setShortDescription(tas.getDescription());
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"com/paterva/maltego/transform/manager/resources/TAS.png");
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    private static class TasTransformChildFactory
    extends ChildFactory<TransformDefinitionWrapper> {
        private final TransformDefinitions transformDefinitions;

        public TasTransformChildFactory(TransformDefinitions transformDefinitions) {
            this.transformDefinitions = transformDefinitions;
        }

        protected boolean createKeys(List<TransformDefinitionWrapper> fill) {
            fill.addAll(this.transformDefinitions.getTransformList());
            return true;
        }

        protected Node createNodeForKey(TransformDefinitionWrapper key) {
            return new TransformNode(key, this.transformDefinitions.getTasWrapper());
        }

        protected Node createWaitNode() {
            AbstractNode wait = new AbstractNode(Children.LEAF);
            wait.setDisplayName("Getting transforms...");
            return wait;
        }
    }

    private static class TransformDefinitions
    implements Filterable {
        private final TransformServerInfoWrapper tasWrapper;
        private final MachineEditorControl machineEditControl;
        private List<TransformDefinitionWrapper> transformList;

        public TransformDefinitions(TransformServerInfoWrapper tasWrapper, MachineEditorControl machineEditControl) {
            this.tasWrapper = tasWrapper;
            this.machineEditControl = machineEditControl;
        }

        public TransformServerInfoWrapper getTasWrapper() {
            return this.tasWrapper;
        }

        synchronized List<TransformDefinitionWrapper> getTransformList() {
            if (this.transformList == null) {
                String selectedType = TransformFilterUtils.getSelectedType(this.machineEditControl.getSelectedOption());
                List<TransformDefinition> transforms = TransformFilterUtils.getTransforms(this.tasWrapper.getTransformServerInfo(), selectedType);
                this.transformList = transforms.stream().sorted((definition1, definition2) -> definition1.getDisplayName().compareTo(definition2.getDisplayName())).map(td -> new TransformDefinitionWrapper((TransformDefinition)td)).collect(Collectors.toList());
            }
            return this.transformList;
        }

        public boolean match(String filterText) {
            for (TransformDefinitionWrapper tdw : this.getTransformList()) {
                if (!tdw.match(filterText)) continue;
                return true;
            }
            return false;
        }
    }
}

