/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.nbjavac.services;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public final class NBLog
extends Log {
    private static final String ERR_NOT_IN_PROFILE = "not.in.profile";
    private final Map<URI, Collection<Symbol.ClassSymbol>> notInProfiles = new HashMap<URI, Collection<Symbol.ClassSymbol>>();
    private JavaFileObject partialReparseFile;
    private Set<Integer> seenPartialReparsePositions = new HashSet<Integer>();

    private NBLog(Context context, PrintWriter output) {
        super(context, output);
    }

    public static NBLog instance(Context context) {
        Log log = Log.instance(context);
        if (!(log instanceof NBLog)) {
            throw new InternalError("No NBLog instance!");
        }
        return (NBLog)log;
    }

    public static void preRegister(Context context, final PrintWriter errWriter, PrintWriter warnWriter, PrintWriter noticeWriter) {
        context.put(logKey, new Context.Factory<Log>(){

            @Override
            public Log make(Context c) {
                return new NBLog(c, errWriter);
            }
        });
    }

    public static void preRegister(Context context, final PrintWriter output) {
        context.put(logKey, new Context.Factory<Log>(){

            @Override
            public Log make(Context c) {
                return new NBLog(c, output);
            }
        });
    }

    @Override
    public void report(JCDiagnostic diagnostic) {
        JavaFileObject currentFile;
        if (diagnostic.getKind() == Diagnostic.Kind.ERROR && ERR_NOT_IN_PROFILE.equals(diagnostic.getCode()) && (currentFile = this.currentSourceFile()) != null) {
            URI uri = currentFile.toUri();
            Symbol.ClassSymbol type = (Symbol.ClassSymbol)diagnostic.getArgs()[0];
            Collection<Symbol.ClassSymbol> types = this.notInProfiles.get(uri);
            if (types == null) {
                types = new ArrayList<Symbol.ClassSymbol>();
                this.notInProfiles.put(uri, types);
            }
            types.add(type);
        }
        super.report(diagnostic);
    }

    @Override
    protected boolean shouldReport(JavaFileObject file, int pos) {
        if (this.partialReparseFile != null) {
            return file == this.partialReparseFile && this.seenPartialReparsePositions.add(pos);
        }
        return super.shouldReport(file, pos);
    }

    Collection<? extends Symbol.ClassSymbol> removeNotInProfile(URI uri) {
        return uri == null ? null : this.notInProfiles.remove(uri);
    }

    @Override
    protected int getDefaultMaxWarnings() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected int getDefaultMaxErrors() {
        return Integer.MAX_VALUE;
    }

    public void startPartialReparse(JavaFileObject inFile) {
        this.partialReparseFile = inFile;
    }

    public void endPartialReparse(JavaFileObject inFile) {
        this.partialReparseFile = null;
        this.seenPartialReparsePositions.clear();
    }
}

