/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.crypto.util;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;

public final class CryptoUtilities {
    private CryptoUtilities() {
    }

    public static SecretKey createMasterKey(char[] masterPassword, byte[] salt, int iterations, int keyLength) throws GeneralSecurityException {
        PBEKeySpec spec = new PBEKeySpec(masterPassword, salt, iterations, keyLength);
        SecretKey derivedKey = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256").generateSecret(spec);
        return new SecretKeySpec(derivedKey.getEncoded(), "AES");
    }

    public static PrivateKey decryptPrivateKey(byte[] encryptedPrivateKey, SecretKey masterKey, byte[] iv) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)masterKey, new GCMParameterSpec(128, iv));
        byte[] decryptedKeyBytes = cipher.doFinal(encryptedPrivateKey);
        return KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(decryptedKeyBytes));
    }

    public static byte[] encryptCaseKey(SecretKey caseKey, PublicKey publicKey) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPPadding");
        OAEPParameterSpec oaepParams = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
        cipher.init(1, (Key)publicKey, oaepParams);
        return cipher.doFinal(caseKey.getEncoded());
    }

    public static SecretKey decryptCaseKey(byte[] encryptedCaseKey, PrivateKey privateKey) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPPadding");
        OAEPParameterSpec oaepParams = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
        cipher.init(2, (Key)privateKey, oaepParams);
        byte[] decodedKey = cipher.doFinal(encryptedCaseKey);
        return new SecretKeySpec(decodedKey, "AES");
    }

    public static byte[] encryptGraphKey(SecretKey graphKey, SecretKey caseKey, byte[] iv) throws GeneralSecurityException {
        return CryptoUtilities.encryptByteContent(graphKey.getEncoded(), caseKey, iv);
    }

    public static SecretKey decryptGraphKey(byte[] encodedGraphKey, SecretKey caseKey, byte[] iv) throws GeneralSecurityException {
        byte[] graphKeyBytes = CryptoUtilities.decryptByteContent(encodedGraphKey, caseKey, iv);
        return new SecretKeySpec(graphKeyBytes, "AES");
    }

    public static byte[] encryptByteContent(byte[] byteContent, SecretKey aesKey, byte[] iv) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(1, (Key)aesKey, new GCMParameterSpec(128, iv));
        return cipher.doFinal(byteContent);
    }

    public static byte[] decryptByteContent(byte[] encodedGraphKey, SecretKey aesKey, byte[] iv) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)aesKey, new GCMParameterSpec(128, iv));
        return cipher.doFinal(encodedGraphKey);
    }

    public static SecretKey generateAESKey() throws NoSuchAlgorithmException {
        KeyGenerator kg = KeyGenerator.getInstance("AES");
        kg.init(256);
        return kg.generateKey();
    }

    public static byte[] generateBytes(int byteLength) {
        byte[] bytes = new byte[byteLength];
        new SecureRandom().nextBytes(bytes);
        return bytes;
    }

    public static byte[] generateIV() {
        return CryptoUtilities.generateBytes(12);
    }

    public static byte[] generateSalt() {
        return CryptoUtilities.generateBytes(32);
    }
}

