/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf.ribbon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.officelaf.ribbon.OfficeCommandButtonUI;
import org.officelaf.util.CommandButtonPainter;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.internal.ui.common.BasicCommandMenuButtonUI;

public class OfficeCommandMenuButtonUI
extends BasicCommandMenuButtonUI {
    private CommandButtonPainter painter;

    public static ComponentUI createUI(JComponent c) {
        return new OfficeCommandMenuButtonUI();
    }

    protected void installDefaults() {
        this.commandButton.setFont(UIManager.getLookAndFeelDefaults().getFont("ribbon-button-font"));
        super.installDefaults();
        this.painter = new CommandButtonPainter(this.commandButton);
    }

    protected void paintButtonBackground(Graphics g, Rectangle toFill) {
        this.painter.paintBackground(g, toFill);
    }

    protected void paintButtonHorizontalSeparator(Graphics g, Rectangle rect) {
        g.setColor(OfficeCommandButtonUI.SEPARATOR_COLOR);
        g.drawLine(1, rect.y, this.commandButton.getBounds().width - 2, rect.y);
    }

    protected void paintButtonVerticalSeparator(Graphics g, Rectangle separatorArea) {
        g.setColor(OfficeCommandButtonUI.SEPARATOR_COLOR);
        g.drawLine(separatorArea.x, 1, separatorArea.x, this.commandButton.getBounds().height - 2);
    }

    protected ResizableIcon createPopupActionIcon() {
        return new PopupArrowIcon(((JCommandButton)this.commandButton).getPopupOrientationKind());
    }

    protected int getLayoutGap() {
        return 2;
    }

    protected Color getForegroundColor(boolean isTextPaintedEnabled) {
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        return laf.getColor(isTextPaintedEnabled ? "ribbon-button-text-color" : "ribbon-button-disabled-text-color");
    }

    public static class PopupArrowIcon
    implements ResizableIcon {
        private static final Color C1 = new Color(0x4E4E4F);
        private static final Color C2 = UIManager.getLookAndFeelDefaults().getColor("ribbon-app-menu-description-fg");
        private static final int ICON_WIDTH = 7;
        private static final int ICON_HEIGHT = 4;
        private final JCommandButton.CommandButtonPopupOrientationKind orientationKind;

        public PopupArrowIcon(JCommandButton.CommandButtonPopupOrientationKind orientationKind) {
            this.orientationKind = orientationKind;
        }

        public void setDimension(Dimension newDimension) {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            if (this.orientationKind == JCommandButton.CommandButtonPopupOrientationKind.DOWNWARD) {
                g2d.setPaint(new LinearGradientPaint(0.0f, 0.0f, 0.0f, 3.0f, new float[]{0.0f, 1.0f}, new Color[]{C1, C2}));
                g.drawLine(x, y, x + 6, y);
                g.drawLine(x + 1, y + 1, x + 5, y + 1);
                g.drawLine(x + 2, y + 2, x + 4, y + 2);
                g.drawLine(x + 3, y + 3, x + 3, y + 3);
            } else {
                g2d.setPaint(new LinearGradientPaint(0.0f, 0.0f, 6.0f, 0.0f, new float[]{0.0f, 1.0f}, new Color[]{C1, C2}));
                g.drawLine(x, y, x, y + 6);
                g.drawLine(x + 1, y + 1, x + 1, y + 5);
                g.drawLine(x + 2, y + 2, x + 2, y + 4);
                g.drawLine(x + 3, y + 3, x + 3, y + 3);
            }
        }

        public int getIconWidth() {
            return this.orientationKind == JCommandButton.CommandButtonPopupOrientationKind.DOWNWARD ? 7 : 4;
        }

        public int getIconHeight() {
            return this.orientationKind == JCommandButton.CommandButtonPopupOrientationKind.DOWNWARD ? 4 : 7;
        }
    }
}

