/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tiff;

import com.twelvemonkeys.lang.Validate;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

final class HorizontalDeDifferencingFloatingPointStream
extends InputStream {
    private final int columns;
    private final int samplesPerPixel;
    private final int bytesPerSample;
    private final ReadableByteChannel channel;
    private final ByteBuffer buffer;
    private final byte[] fpRow;

    public HorizontalDeDifferencingFloatingPointStream(InputStream inputStream, int n, int n2, int n3, ByteOrder byteOrder) {
        this.columns = (Integer)Validate.isTrue((n > 0 ? 1 : 0) != 0, (Object)n, (String)"width must be greater than 0");
        this.samplesPerPixel = n2;
        Validate.isTrue((boolean)HorizontalDeDifferencingFloatingPointStream.isValidBPS(n3), (Object)n3, (String)"Unsupported bits per sample value: %s");
        this.bytesPerSample = (n2 * n3 + 7) / 8;
        this.channel = Channels.newChannel((InputStream)Validate.notNull((Object)inputStream, (String)"stream"));
        this.buffer = ByteBuffer.allocate(n * this.bytesPerSample).order(byteOrder);
        this.fpRow = (byte[])this.buffer.array().clone();
        this.buffer.flip();
    }

    private static boolean isValidBPS(int n) {
        switch (n) {
            case 16: 
            case 24: 
            case 32: 
            case 64: {
                return true;
            }
        }
        return false;
    }

    private boolean fetch() throws IOException {
        this.buffer.clear();
        while (this.channel.read(this.buffer) > 0) {
        }
        if (this.buffer.position() > 0) {
            if (this.buffer.hasRemaining()) {
                throw new EOFException("Unexpected end of stream");
            }
            this.decodeRow();
            this.buffer.flip();
            return true;
        }
        this.buffer.position(this.buffer.capacity());
        return false;
    }

    private void decodeDeltaBytes(byte[] byArray, int n, int n2) {
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                byArray[i * n2 + j] = (byte)(byArray[i * n2 + j] + byArray[(i - 1) * n2 + j]);
            }
        }
    }

    private void decodeFloatingPointDelta(byte[] byArray, byte[] byArray2, int n, int n2, int n3, ByteOrder byteOrder) {
        this.decodeDeltaBytes(byArray, n * n3, n2);
        int n4 = n * n2;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                byArray2[n3 * i + j] = byteOrder == ByteOrder.BIG_ENDIAN ? byArray[j * n4 + i] : byArray[(n3 - j - 1) * n4 + i];
            }
        }
    }

    private void decodeRow() {
        this.decodeFloatingPointDelta(this.buffer.array(), this.fpRow, this.columns, this.samplesPerPixel, this.bytesPerSample, this.buffer.order());
        System.arraycopy(this.fpRow, 0, this.buffer.array(), 0, this.fpRow.length);
    }

    @Override
    public int read() throws IOException {
        if (!this.buffer.hasRemaining() && !this.fetch()) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.buffer.hasRemaining() && !this.fetch()) {
            return -1;
        }
        int n3 = Math.min(this.buffer.remaining(), n2);
        this.buffer.get(byArray, n, n3);
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        if (l < 0L) {
            return 0L;
        }
        if (!this.buffer.hasRemaining() && !this.fetch()) {
            return 0L;
        }
        int n = (int)Math.min((long)this.buffer.remaining(), l);
        this.buffer.position(this.buffer.position() + n);
        return n;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.channel.isOpen()) {
                this.channel.close();
            }
        }
    }
}

