/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.TruffleAccessor;
import com.oracle.truffle.api.TruffleRuntime;
import com.oracle.truffle.api.TruffleRuntimeAccess;
import com.oracle.truffle.api.impl.DefaultTruffleRuntime;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;

public final class Truffle {
    private static final TruffleRuntime RUNTIME = Truffle.initRuntime();

    private Truffle() {
    }

    public static TruffleRuntime getRuntime() {
        return RUNTIME;
    }

    private static TruffleRuntimeAccess selectTruffleRuntimeAccess(List<Iterable<TruffleRuntimeAccess>> lookups) {
        TruffleRuntimeAccess selectedAccess = null;
        for (Iterable<TruffleRuntimeAccess> lookup : lookups) {
            if (lookup == null) continue;
            Iterator<TruffleRuntimeAccess> it = lookup.iterator();
            while (it.hasNext()) {
                TruffleRuntimeAccess access;
                try {
                    access = it.next();
                }
                catch (ServiceConfigurationError err) {
                    continue;
                }
                if (selectedAccess == null) {
                    selectedAccess = access;
                    continue;
                }
                if (selectedAccess == access || selectedAccess.getClass() == access.getClass()) continue;
                if (selectedAccess.getPriority() == access.getPriority()) {
                    throw new InternalError(String.format("Providers for %s with same priority %d: %s (loader: %s) vs. %s (loader: %s)", TruffleRuntimeAccess.class.getName(), access.getPriority(), selectedAccess, selectedAccess.getClass().getClassLoader(), access, access.getClass().getClassLoader()));
                }
                if (selectedAccess.getPriority() >= access.getPriority()) continue;
                selectedAccess = access;
            }
        }
        return selectedAccess;
    }

    private static TruffleRuntime initRuntime() {
        return AccessController.doPrivileged(new PrivilegedAction<TruffleRuntime>(){

            @Override
            public TruffleRuntime run() {
                String runtimeClassName = System.getProperty("truffle.TruffleRuntime");
                if (runtimeClassName != null && runtimeClassName.length() > 0) {
                    try {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        Class<?> runtimeClass = Class.forName(runtimeClassName, false, cl);
                        return (TruffleRuntime)runtimeClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Throwable e) {
                        throw new InternalError(e);
                    }
                }
                List<Iterable<TruffleRuntimeAccess>> loaders = TruffleAccessor.jdkServicesAccessor().getTruffleRuntimeLoaders(TruffleRuntimeAccess.class);
                TruffleRuntimeAccess access = Truffle.selectTruffleRuntimeAccess(loaders);
                if (access != null) {
                    TruffleAccessor.jdkServicesAccessor().exportTo(access.getClass());
                    return access.getRuntime();
                }
                return new DefaultTruffleRuntime();
            }
        });
    }
}

