/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui.binding;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.util.ui.table.EditableTableDecorator;
import com.paterva.maltego.util.ui.table.ImageTableCellRenderer;
import com.paterva.maltego.util.ui.table.PaddedTableCellRenderer;
import com.paterva.maltego.util.ui.table.TableButtonEvent;
import com.paterva.maltego.util.ui.table.TableButtonListener;
import com.paterva.maltego.util.ui.table.TableModelDecorator;
import com.paterva.maltego.view.customization.api.Binding;
import com.paterva.maltego.view.customization.api.BindingScript;
import com.paterva.maltego.view.customization.ui.binding.StringPanel;
import com.paterva.maltego.view.customization.ui.binding.TestResult;
import com.paterva.maltego.view.customization.ui.binding.TestResultsTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.swing.etable.ETable;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import yguard.A.A.D;
import yguard.A.A.E;
import yguard.A.A.Y;
import yguard.A.J.SA;
import yguard.A.J.U;

public class TestPanel
extends JPanel {
    private final TestResultsTableModel _tableModel;
    private JLabel _statusLabel;
    private ETable _table;
    private JPanel jPanel1;
    private JScrollPane jScrollPane4;

    TestPanel(U view, Binding binding) {
        this.initComponents();
        long time = System.currentTimeMillis();
        List<TestResult> results = this.calculateResults(view, binding);
        time = System.currentTimeMillis() - time;
        StringBuilder sb = new StringBuilder();
        sb.append(results.size());
        sb.append(" Entities (");
        sb.append(new DecimalFormat("0.###").format((double)time / 1000.0));
        sb.append(" seconds)");
        this._statusLabel.setText(sb.toString());
        this._tableModel = new TestResultsTableModel();
        this._tableModel.setRows(results);
        this._table.setModel((TableModel)((Object)this._tableModel));
        this._table.setDefaultRenderer(String.class, (TableCellRenderer)new PaddedTableCellRenderer());
        this._table.setDefaultRenderer(Image.class, (TableCellRenderer)new ImageTableCellRenderer());
        EditableTableDecorator decorator = new EditableTableDecorator();
        decorator.addEdit((JTable)this._table, (TableButtonListener)new TableEditListener());
        this._table.getColumnModel().getColumn(3).setCellRenderer((TableCellRenderer)((Object)new ResultRenderer()));
        TableColumnModel columns = this._table.getColumnModel();
        columns.getColumn(0).setPreferredWidth(20);
        columns.getColumn(0).setMaxWidth(20);
        columns.getColumn(1).setPreferredWidth(200);
        columns.getColumn(2).setPreferredWidth(100);
        columns.getColumn(3).setPreferredWidth(300);
    }

    private List<TestResult> calculateResults(U view, Binding binding) {
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        GraphID graphID = GraphIDProvider.forGraph((SA)view.getGraph2D());
        int limit = 1000;
        E nodes = view.getGraph2D().\u00a4();
        while (nodes.ok()) {
            Object result;
            Y node = nodes.B();
            D graph = node.H();
            GraphWrapper wrapper = MaltegoGraphManager.getWrapper((D)graph);
            BindingScript script = binding.getScript();
            try {
                result = script.evaluate((Object)node);
            }
            catch (Exception ex) {
                result = ex;
            }
            EntityID entityID = wrapper.entityID(node);
            TestResult testResult = new TestResult(graphID, entityID, result);
            results.add(testResult);
            if (results.size() > 1000) break;
            nodes.next();
        }
        return results;
    }

    private void initComponents() {
        this.jScrollPane4 = new JScrollPane();
        this._table = new ETable();
        this.jPanel1 = new JPanel();
        this._statusLabel = new JLabel();
        this.setPreferredSize(new Dimension(600, 300));
        this.setLayout(new BorderLayout());
        this._table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this._table.setFillsViewportHeight(true);
        this._table.setPreferredScrollableViewportSize(new Dimension(250, 300));
        this._table.setRowHeight(20);
        this.jScrollPane4.setViewportView((Component)this._table);
        this.add((Component)this.jScrollPane4, "Center");
        this.jPanel1.setLayout(new FlowLayout(0));
        this._statusLabel.setText(NbBundle.getMessage(TestPanel.class, (String)"TestPanel._statusLabel.text"));
        this.jPanel1.add(this._statusLabel);
        this.add((Component)this.jPanel1, "South");
    }

    private class TableEditListener
    implements TableButtonListener {
        public void actionPerformed(TableButtonEvent evt) {
            int index = TestPanel.this._table.convertRowIndexToModel(evt.getSelectedRows()[0]);
            TestResult testResult = (TestResult)TestPanel.this._tableModel.getRow(index);
            StringPanel panel = new StringPanel(testResult.getResultText());
            DialogDescriptor dd = new DialogDescriptor((Object)panel, "Result");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        }
    }

    private static class ResultRenderer
    extends PaddedTableCellRenderer {
        private ResultRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            TableModelDecorator decoratorModel = (TableModelDecorator)table.getModel();
            TestResultsTableModel model = (TestResultsTableModel)((Object)decoratorModel.getDelegate());
            TestResult testResult = (TestResult)model.getRow(table.convertRowIndexToModel(row));
            if (testResult.getResult() instanceof Exception) {
                label.setForeground(Color.RED);
            } else {
                label.setForeground(Color.BLACK);
            }
            return label;
        }
    }
}

