/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltinsFactory;
import com.oracle.truffle.js.builtins.ObjectPrototypeBuiltins;
import com.oracle.truffle.js.builtins.helper.ListGetNode;
import com.oracle.truffle.js.builtins.helper.ListSizeNode;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNode;
import com.oracle.truffle.js.nodes.access.EnumerableOwnPropertyNamesNode;
import com.oracle.truffle.js.nodes.access.FromPropertyDescriptorNode;
import com.oracle.truffle.js.nodes.access.GetIteratorNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.access.IsExtensibleNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.IteratorCloseNode;
import com.oracle.truffle.js.nodes.access.IteratorStepNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.access.JSGetOwnPropertyNode;
import com.oracle.truffle.js.nodes.access.JSHasPropertyNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.RequireObjectCoercibleNode;
import com.oracle.truffle.js.nodes.access.ToPropertyDescriptorNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.binary.JSIdenticalNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToPropertyKeyNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import com.oracle.truffle.js.runtime.util.Pair;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;
import com.oracle.truffle.js.runtime.util.UnmodifiableArrayList;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public final class ObjectFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<ObjectFunction> {
    public static final JSBuiltinsContainer BUILTINS = new ObjectFunctionBuiltins();
    public static final JSBuiltinsContainer BUILTINS_NASHORN_COMPAT = new ObjectFunctionNashornCompatBuiltins();

    protected ObjectFunctionBuiltins() {
        super("Object", ObjectFunction.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, ObjectFunction builtinEnum) {
        switch (builtinEnum) {
            case create: {
                return ObjectFunctionBuiltinsFactory.ObjectCreateNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case defineProperties: {
                return ObjectFunctionBuiltinsFactory.ObjectDefinePropertiesNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case defineProperty: {
                return ObjectFunctionBuiltinsFactory.ObjectDefinePropertyNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case freeze: {
                return ObjectFunctionBuiltinsFactory.ObjectSetIntegrityLevelNodeGen.create(context, builtin, true, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case getOwnPropertyDescriptor: {
                return ObjectFunctionBuiltinsFactory.ObjectGetOwnPropertyDescriptorNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case getOwnPropertyDescriptors: {
                return ObjectFunctionBuiltinsFactory.ObjectGetOwnPropertyDescriptorsNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case getOwnPropertyNames: {
                return ObjectFunctionBuiltinsFactory.ObjectGetOwnPropertyNamesOrSymbolsNodeGen.create(context, builtin, false, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case getPrototypeOf: {
                return ObjectFunctionBuiltinsFactory.ObjectGetPrototypeOfNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case isExtensible: {
                return ObjectFunctionBuiltinsFactory.ObjectIsExtensibleNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case isFrozen: {
                return ObjectFunctionBuiltinsFactory.ObjectTestIntegrityLevelNodeGen.create(context, builtin, true, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case isSealed: {
                return ObjectFunctionBuiltinsFactory.ObjectTestIntegrityLevelNodeGen.create(context, builtin, false, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case keys: {
                return ObjectFunctionBuiltinsFactory.ObjectKeysNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case preventExtensions: {
                return ObjectFunctionBuiltinsFactory.ObjectPreventExtensionsNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case seal: {
                return ObjectFunctionBuiltinsFactory.ObjectSetIntegrityLevelNodeGen.create(context, builtin, false, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case setPrototypeOf: {
                return ObjectFunctionBuiltinsFactory.ObjectSetPrototypeOfNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case is: {
                return ObjectFunctionBuiltinsFactory.ObjectIsNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case getOwnPropertySymbols: {
                return ObjectFunctionBuiltinsFactory.ObjectGetOwnPropertyNamesOrSymbolsNodeGen.create(context, builtin, true, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case assign: {
                return ObjectFunctionBuiltinsFactory.ObjectAssignNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
            case values: {
                return ObjectFunctionBuiltinsFactory.ObjectValuesOrEntriesNodeGen.create(context, builtin, false, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case entries: {
                return ObjectFunctionBuiltinsFactory.ObjectValuesOrEntriesNodeGen.create(context, builtin, true, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case fromEntries: {
                return ObjectFunctionBuiltinsFactory.ObjectFromEntriesNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case hasOwn: {
                return ObjectFunctionBuiltinsFactory.ObjectHasOwnNodeGen.create(context, builtin, ObjectFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class ObjectHasOwnNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        @Node.Child
        JSToPropertyKeyNode toPropertyKeyNode = JSToPropertyKeyNode.create();
        @Node.Child
        JSHasPropertyNode hasOwnPropertyNode = JSHasPropertyNode.create(true);

        public ObjectHasOwnNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean hasOwn(Object o, Object p) {
            Object obj = this.toObject(o);
            Object key = this.toPropertyKeyNode.execute(p);
            return this.hasOwnPropertyNode.executeBoolean(obj, key);
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class ObjectBindPropertiesNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        @Node.Child
        private EnumerableOwnPropertyNamesNode enumerableOwnPropertyNamesNode;
        private final JSClassProfile sourceProfile = JSClassProfile.create();
        private final JSClassProfile targetProfile = JSClassProfile.create();

        public ObjectBindPropertiesNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"!isJSObject(target)"})
        protected DynamicObject bindPropertiesInvalidTarget(Object target, Object source) {
            throw Errors.createTypeErrorNotAnObject(target, this);
        }

        @Specialization(guards={"isJSObject(target)", "isJSDynamicObject(source)"})
        protected DynamicObject bindPropertiesDynamicObject(DynamicObject target, DynamicObject source) {
            DynamicObject sourceObject = this.toJSObject(source);
            boolean extensible = JSObject.isExtensible(target, this.targetProfile);
            JSClass sourceClass = this.sourceProfile.getJSClass(sourceObject);
            UnmodifiableArrayList<? extends Object> keys = this.enumerableOwnPropertyNames(sourceObject);
            int length = keys.size();
            for (int i = 0; i < length; ++i) {
                Object key = keys.get(i);
                if (JSObject.hasOwnProperty(target, key, this.targetProfile)) continue;
                if (!extensible) {
                    throw Errors.createTypeErrorNotExtensible(target, key);
                }
                PropertyDescriptor desc = JSObject.getOwnProperty(sourceObject, key, this.sourceProfile);
                if (desc.isAccessorDescriptor()) {
                    JSObject.defineOwnProperty(target, key, desc);
                    continue;
                }
                JSObjectUtil.defineProxyProperty(target, key, new BoundProperty(source, key, sourceClass), desc.getFlags());
            }
            return target;
        }

        @Specialization(guards={"isJSObject(target)"})
        protected DynamicObject bindProperties(DynamicObject target, Symbol source) {
            return this.bindPropertiesDynamicObject(target, this.toJSObject(source));
        }

        @Specialization(guards={"isJSObject(target)"})
        protected DynamicObject bindProperties(DynamicObject target, JSLazyString source) {
            return this.bindPropertiesDynamicObject(target, this.toJSObject(source));
        }

        @Specialization(guards={"isJSObject(target)"})
        protected DynamicObject bindProperties(DynamicObject target, SafeInteger source) {
            return this.bindPropertiesDynamicObject(target, this.toJSObject(source));
        }

        @Specialization(guards={"isJSObject(target)"})
        protected DynamicObject bindProperties(DynamicObject target, BigInt source) {
            return this.bindPropertiesDynamicObject(target, this.toJSObject(source));
        }

        @Specialization(guards={"isJSObject(target)", "!isTruffleObject(source)"})
        protected DynamicObject bindProperties(DynamicObject target, Object source) {
            return this.bindPropertiesDynamicObject(target, this.toJSObject(source));
        }

        @Specialization(guards={"isJSObject(target)", "isForeignObject(source)"}, limit="InteropLibraryLimit")
        protected DynamicObject bindProperties(DynamicObject target, Object source, @CachedLibrary(value="source") InteropLibrary interop, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary members) {
            block13: {
                block9: {
                    if (!interop.hasMembers(source)) break block9;
                    try {
                        boolean extensible = JSObject.isExtensible(target, this.targetProfile);
                        boolean hostObject = this.getRealm().getEnv().isHostObject(source);
                        Object keysObj = interop.getMembers(source);
                        long size = members.getArraySize(keysObj);
                        int i = 0;
                        while ((long)i < size) {
                            block10: {
                                String beanProperty;
                                block12: {
                                    String stringKey;
                                    block11: {
                                        Object key = members.readArrayElement(keysObj, (long)i);
                                        stringKey = key instanceof String ? (String)key : ((InteropLibrary)InteropLibrary.getFactory().getUncached()).asString(key);
                                        if (!JSObject.hasOwnProperty(target, key, this.targetProfile)) {
                                            if (!extensible) {
                                                throw Errors.createTypeErrorNotExtensible(target, key);
                                            }
                                            JSObjectUtil.defineProxyProperty(target, key, new ForeignBoundProperty(source, stringKey), JSAttributes.getDefault());
                                        }
                                        if (!hostObject) break block10;
                                        if (stringKey.length() <= 3 || stringKey.charAt(0) != 's' && stringKey.charAt(0) != 'g' || stringKey.charAt(1) != 'e' || stringKey.charAt(2) != 't' || !Boundaries.characterIsUpperCase(stringKey.charAt(3))) break block11;
                                        beanProperty = ObjectBindPropertiesNode.beanProperty(stringKey, 3);
                                        break block12;
                                    }
                                    if (stringKey.length() <= 2 || stringKey.charAt(0) != 'i' || stringKey.charAt(1) != 's' || !Boundaries.characterIsUpperCase(stringKey.charAt(2))) break block10;
                                    beanProperty = ObjectBindPropertiesNode.beanProperty(stringKey, 2);
                                }
                                if (!JSObject.hasOwnProperty(target, beanProperty, this.targetProfile) && !interop.isMemberExisting(source, beanProperty)) {
                                    String isKey;
                                    String getKey = ObjectBindPropertiesNode.beanAccessor("get", beanProperty);
                                    String getter = interop.isMemberExisting(source, getKey) ? getKey : (interop.isMemberExisting(source, isKey = ObjectBindPropertiesNode.beanAccessor("is", beanProperty)) ? isKey : null);
                                    String setKey = ObjectBindPropertiesNode.beanAccessor("set", beanProperty);
                                    String setter = interop.isMemberExisting(source, setKey) ? setKey : null;
                                    JSObjectUtil.defineProxyProperty(target, beanProperty, new ForeignBoundBeanProperty(source, getter, setter), JSAttributes.getDefault());
                                }
                            }
                            ++i;
                        }
                    }
                    catch (InvalidArrayIndexException | UnsupportedMessageException throwable) {}
                    break block13;
                }
                throw Errors.createTypeErrorNotAnObject(target, this);
            }
            return target;
        }

        private UnmodifiableArrayList<? extends Object> enumerableOwnPropertyNames(DynamicObject obj) {
            if (this.enumerableOwnPropertyNamesNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.enumerableOwnPropertyNamesNode = (EnumerableOwnPropertyNamesNode)this.insert(EnumerableOwnPropertyNamesNode.createKeys(this.getContext()));
            }
            return this.enumerableOwnPropertyNamesNode.execute(obj);
        }

        @CompilerDirectives.TruffleBoundary
        private static String beanProperty(String accessor, int prefixLength) {
            char c = accessor.charAt(prefixLength);
            return Character.toLowerCase(c) + accessor.substring(prefixLength + 1);
        }

        @CompilerDirectives.TruffleBoundary
        private static String beanAccessor(String prefix, String beanProperty) {
            return prefix + Character.toUpperCase(beanProperty.charAt(0)) + beanProperty.substring(1);
        }

        static class ForeignBoundBeanProperty
        implements PropertyProxy {
            private final Object source;
            private final String getKey;
            private final String setKey;

            ForeignBoundBeanProperty(Object source, String getKey, String setKey) {
                assert (getKey != null || setKey != null);
                this.source = source;
                this.getKey = getKey;
                this.setKey = setKey;
            }

            @Override
            public Object get(DynamicObject store) {
                InteropLibrary library;
                if (this.getKey != null && (library = (InteropLibrary)InteropLibrary.getFactory().getUncached(this.source)).isMemberInvocable(this.source, this.getKey)) {
                    try {
                        return JSRuntime.importValue(library.invokeMember(this.source, this.getKey, new Object[0]));
                    }
                    catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException throwable) {
                        // empty catch block
                    }
                }
                return Undefined.instance;
            }

            @Override
            public boolean set(DynamicObject store, Object value) {
                InteropLibrary library;
                if (this.setKey != null && (library = (InteropLibrary)InteropLibrary.getFactory().getUncached(this.source)).isMemberInvocable(this.source, this.setKey)) {
                    try {
                        library.invokeMember(this.source, this.setKey, new Object[]{JSRuntime.exportValue(value)});
                        return true;
                    }
                    catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException throwable) {
                        // empty catch block
                    }
                }
                return false;
            }
        }

        static class ForeignBoundProperty
        implements PropertyProxy {
            private final Object source;
            private final String key;

            ForeignBoundProperty(Object source, String key) {
                this.source = source;
                this.key = key;
            }

            @Override
            public Object get(DynamicObject store) {
                InteropLibrary library = (InteropLibrary)InteropLibrary.getFactory().getUncached(this.source);
                if (library.isMemberReadable(this.source, this.key)) {
                    try {
                        return JSRuntime.importValue(library.readMember(this.source, this.key));
                    }
                    catch (UnknownIdentifierException | UnsupportedMessageException throwable) {
                        // empty catch block
                    }
                }
                return Undefined.instance;
            }

            @Override
            public boolean set(DynamicObject store, Object value) {
                InteropLibrary library = (InteropLibrary)InteropLibrary.getFactory().getUncached(this.source);
                if (library.isMemberWritable(this.source, this.key)) {
                    try {
                        library.writeMember(this.source, this.key, JSRuntime.exportValue(value));
                        return true;
                    }
                    catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException throwable) {
                        // empty catch block
                    }
                }
                return false;
            }
        }

        static class BoundProperty
        implements PropertyProxy {
            private final DynamicObject source;
            private final Object key;
            private final JSClass sourceClass;

            BoundProperty(DynamicObject source, Object key, JSClass sourceClass) {
                this.source = source;
                this.key = key;
                this.sourceClass = sourceClass;
            }

            @Override
            public Object get(DynamicObject store) {
                return this.sourceClass.get(this.source, this.key);
            }

            @Override
            public boolean set(DynamicObject store, Object value) {
                return this.sourceClass.set(this.source, this.key, value, (Object)this.source, false, null);
            }
        }
    }

    public static abstract class ObjectFromEntriesNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        @Node.Child
        private RequireObjectCoercibleNode requireObjectCoercibleNode = RequireObjectCoercibleNode.create();
        @Node.Child
        private GetIteratorNode getIteratorNode;
        @Node.Child
        private IteratorStepNode iteratorStepNode;
        @Node.Child
        private IteratorValueNode iteratorValueNode;
        @Node.Child
        private IsObjectNode isObjectNode = IsObjectNode.create();
        @Node.Child
        private IteratorCloseNode iteratorCloseNode;
        @Node.Child
        private JSToPropertyKeyNode toPropertyKeyNode = JSToPropertyKeyNode.create();
        @Node.Child
        private ReadElementNode readElementNode;
        private final BranchProfile errorBranch = BranchProfile.create();

        public ObjectFromEntriesNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getIteratorNode = GetIteratorNode.create(context);
            this.iteratorStepNode = IteratorStepNode.create(context);
            this.iteratorValueNode = IteratorValueNode.create(context);
            this.readElementNode = ReadElementNode.create(context);
        }

        @Specialization
        protected DynamicObject entries(Object iterable) {
            this.requireObjectCoercibleNode.executeVoid(iterable);
            DynamicObject obj = JSOrdinary.create(this.getContext(), this.getRealm());
            return this.addEntriesFromIterable(obj, iterable);
        }

        private DynamicObject addEntriesFromIterable(DynamicObject target, Object iterable) {
            assert (!JSRuntime.isNullOrUndefined(target));
            IteratorRecord iteratorRecord = this.getIteratorNode.execute(iterable);
            try {
                while (true) {
                    Object next;
                    if ((next = this.iteratorStepNode.execute(iteratorRecord)) == Boolean.FALSE) {
                        return target;
                    }
                    Object nextItem = this.iteratorValueNode.execute(next);
                    if (!this.isObjectNode.executeBoolean(nextItem)) {
                        this.errorBranch.enter();
                        throw Errors.createTypeErrorIteratorResultNotObject(nextItem, this);
                    }
                    Object k = this.readElementNode.executeWithTargetAndIndex(nextItem, 0);
                    Object v = this.readElementNode.executeWithTargetAndIndex(nextItem, 1);
                    this.createDataPropertyOnObject(target, k, v);
                }
            }
            catch (Exception ex) {
                this.errorBranch.enter();
                this.iteratorCloseAbrupt(iteratorRecord.getIterator());
                throw ex;
            }
        }

        private void createDataPropertyOnObject(DynamicObject thisObject, Object key, Object value) {
            assert (JSRuntime.isObject(thisObject));
            Object propertyKey = this.toPropertyKeyNode.execute(key);
            JSRuntime.createDataPropertyOrThrow(thisObject, propertyKey, value);
        }

        private void iteratorCloseAbrupt(DynamicObject iterator) {
            if (this.iteratorCloseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.iteratorCloseNode = (IteratorCloseNode)this.insert(IteratorCloseNode.create(this.getContext()));
            }
            this.iteratorCloseNode.executeAbrupt(iterator);
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class ObjectValuesOrEntriesNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        protected final boolean entries;
        @Node.Child
        private EnumerableOwnPropertyNamesNode enumerableOwnPropertyNamesNode;
        @Node.Child
        private InteropLibrary asString;

        public ObjectValuesOrEntriesNode(JSContext context, JSBuiltin builtin, boolean entries) {
            super(context, builtin);
            this.entries = entries;
        }

        protected abstract DynamicObject executeEvaluated(Object var1);

        @Specialization(guards={"isJSObject(obj)"})
        protected DynamicObject valuesOrEntriesJSObject(DynamicObject obj, @Cached(value="createBinaryProfile()") ConditionProfile lengthZero) {
            UnmodifiableArrayList<? extends Object> list = this.enumerableOwnPropertyNames(obj);
            int len = list.size();
            JSRealm realm = this.getRealm();
            if (lengthZero.profile(len == 0)) {
                return JSArray.createEmptyChecked(this.getContext(), realm, 0L);
            }
            return JSArray.createConstant(this.getContext(), realm, list.toArray());
        }

        protected UnmodifiableArrayList<? extends Object> enumerableOwnPropertyNames(DynamicObject obj) {
            if (this.enumerableOwnPropertyNamesNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.enumerableOwnPropertyNamesNode = (EnumerableOwnPropertyNamesNode)this.insert(this.entries ? EnumerableOwnPropertyNamesNode.createKeysValues(this.getContext()) : EnumerableOwnPropertyNamesNode.createValues(this.getContext()));
            }
            return this.enumerableOwnPropertyNamesNode.execute(obj);
        }

        @Specialization(guards={"isForeignObject(thisObj)"}, limit="InteropLibraryLimit")
        protected DynamicObject enumerableOwnPropertyNamesForeign(Object thisObj, @CachedLibrary(value="thisObj") InteropLibrary interop, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary members, @Cached ImportValueNode importValue, @Cached BranchProfile growProfile, @Cached BranchProfile errorBranch) {
            JSRealm realm = this.getRealm();
            try {
                Object keysObj = interop.getMembers(thisObj);
                long size = members.getArraySize(keysObj);
                if (size < 0L || size >= Integer.MAX_VALUE) {
                    errorBranch.enter();
                    throw Errors.createRangeErrorInvalidArrayLength();
                }
                SimpleArrayList<Object> values = SimpleArrayList.create(size);
                int i = 0;
                while ((long)i < size) {
                    Object key = members.readArrayElement(keysObj, (long)i);
                    String stringKey = this.asStringKey(key);
                    Object value = importValue.executeWithTarget(interop.readMember(thisObj, stringKey));
                    if (this.entries) {
                        value = JSArray.createConstant(this.getContext(), realm, new Object[]{key, value});
                    }
                    values.add(value, growProfile);
                    ++i;
                }
                return JSArray.createConstant(this.getContext(), realm, values.toArray());
            }
            catch (InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException e) {
                return JSArray.createEmptyZeroLength(this.getContext(), realm);
            }
        }

        @Specialization(guards={"!isJSObject(obj)", "!isForeignObject(obj)"})
        protected DynamicObject valuesOrEntriesGeneric(Object obj, @Cached(value="createRecursive()") ObjectValuesOrEntriesNode recursive) {
            Object thisObj = this.toObject(obj);
            return recursive.executeEvaluated(thisObj);
        }

        private String asStringKey(Object key) throws UnsupportedMessageException {
            assert (((InteropLibrary)InteropLibrary.getFactory().getUncached()).isString(key));
            if (key instanceof String) {
                return (String)key;
            }
            if (this.asString == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.asString = (InteropLibrary)this.insert((Node)InteropLibrary.getFactory().createDispatched(5));
            }
            return this.asString.asString(key);
        }

        ObjectValuesOrEntriesNode createRecursive() {
            return ObjectFunctionBuiltinsFactory.ObjectValuesOrEntriesNodeGen.create(this.getContext(), this.getBuiltin(), this.entries, new JavaScriptNode[0]);
        }
    }

    @ImportStatic(value={JSConfig.class})
    static abstract class AssignPropertiesNode
    extends JavaScriptBaseNode {
        protected final JSContext context;

        protected AssignPropertiesNode(JSContext context) {
            this.context = context;
        }

        abstract void executeVoid(Object var1, Object var2, WriteElementNode var3);

        @Specialization(guards={"isJSObject(from)"})
        protected static void copyPropertiesFromJSObject(Object to, DynamicObject from, WriteElementNode write, @Cached(value="create(context)") ReadElementNode read, @Cached(value="create(false)") JSGetOwnPropertyNode getOwnProperty, @Cached ListSizeNode listSize, @Cached ListGetNode listGet, @Cached JSClassProfile classProfile) {
            List<Object> ownPropertyKeys = JSObject.ownPropertyKeys(from, classProfile);
            int size = listSize.execute(ownPropertyKeys);
            for (int i = 0; i < size; ++i) {
                Object nextKey = listGet.execute(ownPropertyKeys, i);
                assert (JSRuntime.isPropertyKey(nextKey));
                PropertyDescriptor desc = getOwnProperty.execute(from, nextKey);
                if (desc == null || !desc.getEnumerable()) continue;
                Object propValue = read.executeWithTargetAndIndex((Object)from, nextKey);
                write.executeWithTargetAndIndexAndValue(to, nextKey, propValue);
            }
        }

        @Specialization(guards={"!isJSObject(from)"}, limit="InteropLibraryLimit")
        protected final void doObject(Object to, Object from, WriteElementNode write, @CachedLibrary(value="from") InteropLibrary fromInterop, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary keysInterop, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary stringInterop) {
            if (fromInterop.isNull(from)) {
                return;
            }
            try {
                Object members = fromInterop.getMembers(from);
                long length = JSInteropUtil.getArraySize(members, keysInterop, this);
                for (long i = 0L; i < length; ++i) {
                    Object key = keysInterop.readArrayElement(members, i);
                    String stringKey = key instanceof String ? (String)key : stringInterop.asString(key);
                    Object value = fromInterop.readMember(from, stringKey);
                    write.executeWithTargetAndIndexAndValue(to, stringKey, value);
                }
            }
            catch (InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(from, (InteropException)e, "CopyDataProperties", this);
            }
        }
    }

    public static abstract class ObjectAssignNode
    extends JSBuiltinNode {
        protected static final boolean STRICT = true;

        public ObjectAssignNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object assign(Object target, Object[] sources, @Cached(value="createToObject(getContext())") JSToObjectNode toObjectNode, @Cached(value="create(getContext(), STRICT)") WriteElementNode write, @Cached(value="create(getContext())") AssignPropertiesNode assignProperties) {
            Object to = toObjectNode.execute(target);
            if (sources.length == 0) {
                return to;
            }
            for (Object o : sources) {
                if (JSRuntime.isNullOrUndefined(o)) continue;
                Object from = toObjectNode.execute(o);
                assignProperties.executeVoid(to, from, write);
            }
            return to;
        }
    }

    public static abstract class ObjectIsNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        public ObjectIsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean isInt(int a, int b) {
            return a == b;
        }

        @Specialization
        protected boolean isDouble(double a, double b) {
            if (a == 0.0 && b == 0.0) {
                return JSRuntime.isNegativeZero(a) == JSRuntime.isNegativeZero(b);
            }
            if (Double.isNaN(a)) {
                return Double.isNaN(b);
            }
            return a == b;
        }

        @Specialization(guards={"isNumberNumber(a,b)"})
        protected boolean isNumberNumber(Number a, Number b, @Cached(value="createSameValue()") JSIdenticalNode doIdenticalNode) {
            return doIdenticalNode.executeBoolean(JSRuntime.doubleValue(a), JSRuntime.doubleValue(b));
        }

        @Specialization(guards={"!isNumberNumber(a, b)"})
        protected boolean isObject(Object a, Object b, @Cached(value="createSameValue()") JSIdenticalNode doIdenticalNode) {
            return doIdenticalNode.executeBoolean(a, b);
        }

        protected boolean isNumberNumber(Object a, Object b) {
            return a instanceof Number && b instanceof Number;
        }
    }

    public static abstract class ObjectSetPrototypeOfNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        private final BranchProfile errorBranch = BranchProfile.create();
        private final JSClassProfile classProfile = JSClassProfile.create();

        public ObjectSetPrototypeOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isValidPrototype(newProto)"})
        final Object setPrototypeOfJSObject(JSObject object, JSDynamicObject newProto) {
            if (!JSObject.setPrototype(object, newProto, this.classProfile)) {
                this.errorBranch.enter();
                throw Errors.createTypeError("setPrototype failed");
            }
            return object;
        }

        @Specialization(guards={"!isValidPrototype(newProto)"})
        static Object setPrototypeOfJSObjectToInvalidNewProto(JSObject object, Object newProto) {
            throw Errors.createTypeErrorInvalidPrototype(newProto);
        }

        @Specialization(guards={"isNullOrUndefined(object)"})
        final Object setPrototypeOfNonObjectCoercible(Object object, Object newProto) {
            throw this.createTypeErrorCalledOnNonObject(object);
        }

        @Specialization(guards={"!isJSObject(object)", "!isNullOrUndefined(object)", "!isForeignObject(object)"})
        static Object setPrototypeOfValue(Object object, Object newProto) {
            return object;
        }

        @Specialization(guards={"isForeignObject(object)"})
        final Object setPrototypeOfForeignObject(Object object, Object newProto) {
            throw this.createTypeErrorCalledOnNonObject(object);
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class ObjectKeysNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        @Node.Child
        private EnumerableOwnPropertyNamesNode enumerableOwnPropertyNamesNode;
        @Node.Child
        private InteropLibrary asString;
        private final ConditionProfile hasElements = ConditionProfile.createBinaryProfile();

        public ObjectKeysNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSDynamicObject(thisObj)"})
        protected DynamicObject keysDynamicObject(DynamicObject thisObj) {
            UnmodifiableArrayList<? extends Object> keyList = this.enumerableOwnPropertyNames(this.toOrAsJSObject(thisObj));
            int len = keyList.size();
            JSRealm realm = this.getRealm();
            if (this.hasElements.profile(len > 0)) {
                assert (keyList.stream().allMatch(String.class::isInstance));
                return JSArray.createConstant(this.getContext(), realm, keyList.toArray());
            }
            return JSArray.createEmptyChecked(this.getContext(), realm, 0L);
        }

        @Specialization
        protected DynamicObject keysSymbol(Symbol symbol) {
            return this.keysDynamicObject(this.toOrAsJSObject(symbol));
        }

        @Specialization
        protected DynamicObject keysString(JSLazyString string) {
            return this.keysDynamicObject(this.toOrAsJSObject(string));
        }

        @Specialization
        protected DynamicObject keysSafeInt(SafeInteger largeInteger) {
            return this.keysDynamicObject(this.toOrAsJSObject(largeInteger));
        }

        @Specialization
        protected DynamicObject keysBigInt(BigInt bigInt) {
            return this.keysDynamicObject(this.toOrAsJSObject(bigInt));
        }

        @Specialization(guards={"!isTruffleObject(thisObj)"})
        protected DynamicObject keysOther(Object thisObj) {
            return this.keysDynamicObject(this.toOrAsJSObject(thisObj));
        }

        @Specialization(guards={"isForeignObject(obj)"}, limit="InteropLibraryLimit")
        protected DynamicObject keysForeign(Object obj, @CachedLibrary(value="obj") InteropLibrary interop, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary members, @Cached BranchProfile growProfile, @Cached BranchProfile errorBranch) {
            if (interop.hasMembers(obj)) {
                try {
                    Object keysObj = interop.getMembers(obj);
                    long size = members.getArraySize(keysObj);
                    if (size < 0L || size >= Integer.MAX_VALUE) {
                        errorBranch.enter();
                        throw Errors.createRangeErrorInvalidArrayLength();
                    }
                    if (size > 0L) {
                        SimpleArrayList<String> keys = SimpleArrayList.create(size);
                        int i = 0;
                        while ((long)i < size) {
                            Object key = members.readArrayElement(keysObj, (long)i);
                            assert (((InteropLibrary)InteropLibrary.getFactory().getUncached()).isString(key));
                            keys.add(this.asStringKey(key), growProfile);
                            ++i;
                        }
                        return JSArray.createConstant(this.getContext(), this.getRealm(), keys.toArray());
                    }
                }
                catch (InvalidArrayIndexException | UnsupportedMessageException throwable) {
                    // empty catch block
                }
            }
            return JSArray.createEmptyZeroLength(this.getContext(), this.getRealm());
        }

        private UnmodifiableArrayList<? extends Object> enumerableOwnPropertyNames(DynamicObject obj) {
            if (this.enumerableOwnPropertyNamesNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.enumerableOwnPropertyNamesNode = (EnumerableOwnPropertyNamesNode)this.insert(EnumerableOwnPropertyNamesNode.createKeys(this.getContext()));
            }
            return this.enumerableOwnPropertyNamesNode.execute(obj);
        }

        private String asStringKey(Object key) throws UnsupportedMessageException {
            assert (((InteropLibrary)InteropLibrary.getFactory().getUncached()).isString(key));
            if (key instanceof String) {
                return (String)key;
            }
            if (this.asString == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.asString = (InteropLibrary)this.insert((Node)InteropLibrary.getFactory().createDispatched(5));
            }
            return this.asString.asString(key);
        }
    }

    public static abstract class ObjectSetIntegrityLevelNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        private final boolean freeze;
        private final ConditionProfile isObject = ConditionProfile.createBinaryProfile();

        public ObjectSetIntegrityLevelNode(JSContext context, JSBuiltin builtin, boolean freeze) {
            super(context, builtin);
            this.freeze = freeze;
        }

        @Specialization
        protected Object setIntegrityLevel(Object thisObj) {
            if (this.isObject.profile(JSRuntime.isObject(thisObj))) {
                JSObject.setIntegrityLevel((DynamicObject)thisObj, this.freeze, true);
            } else if (this.getContext().getEcmaScriptVersion() < 6) {
                throw this.createTypeErrorCalledOnNonObject(thisObj);
            }
            return thisObj;
        }
    }

    public static abstract class ObjectTestIntegrityLevelNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        private final boolean frozen;
        private final ConditionProfile isObject = ConditionProfile.createBinaryProfile();

        public ObjectTestIntegrityLevelNode(JSContext context, JSBuiltin builtin, boolean frozen) {
            super(context, builtin);
            this.frozen = frozen;
        }

        @Specialization
        protected boolean testIntegrityLevel(Object thisObj) {
            if (this.isObject.profile(JSRuntime.isObject(thisObj))) {
                return JSObject.testIntegrityLevel((DynamicObject)thisObj, this.frozen);
            }
            if (this.getContext().getEcmaScriptVersion() < 6) {
                throw this.createTypeErrorCalledOnNonObject(thisObj);
            }
            return true;
        }
    }

    public static abstract class ObjectPreventExtensionsNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        public ObjectPreventExtensionsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSObject(thisObj)"})
        protected DynamicObject preventExtensionsObject(DynamicObject thisObj) {
            JSObject.preventExtensions(thisObj, true);
            return thisObj;
        }

        @Specialization(guards={"!isJSObject(thisObj)"})
        protected Object preventExtensionsNonObject(Object thisObj) {
            if (this.getContext().getEcmaScriptVersion() < 6) {
                throw this.createTypeErrorCalledOnNonObject(thisObj);
            }
            return thisObj;
        }
    }

    public static abstract class ObjectIsExtensibleNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        public ObjectIsExtensibleNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSObject(thisObj)"})
        protected boolean isExtensibleObject(DynamicObject thisObj, @Cached IsExtensibleNode isExtensibleNode) {
            return isExtensibleNode.executeBoolean(thisObj);
        }

        @Specialization(guards={"!isJSObject(thisObj)"})
        protected boolean isExtensibleNonObject(Object thisObj) {
            if (this.getContext().getEcmaScriptVersion() < 6) {
                throw this.createTypeErrorCalledOnNonObject(thisObj);
            }
            return false;
        }
    }

    public static abstract class ObjectDefinePropertiesNode
    extends ObjectDefineOperation {
        public ObjectDefinePropertiesNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSObject(thisObj)", "isJSObject(properties)"})
        protected DynamicObject definePropertiesObjectObject(DynamicObject thisObj, DynamicObject properties) {
            return this.intlDefineProperties(thisObj, properties);
        }

        @Specialization(replaces={"definePropertiesObjectObject"})
        protected DynamicObject definePropertiesGeneric(Object thisObj, Object properties) {
            DynamicObject object = this.asJSObject(thisObj);
            return this.intlDefineProperties(object, this.toJSObject(properties));
        }
    }

    public static abstract class ObjectDefinePropertyNode
    extends ObjectDefineOperation {
        @Node.Child
        private JSToPropertyKeyNode toPropertyKeyNode = JSToPropertyKeyNode.create();

        public ObjectDefinePropertyNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSObject(thisObj)"})
        protected DynamicObject definePropertyJSObjectString(DynamicObject thisObj, String property, Object attributes) {
            PropertyDescriptor desc = this.toPropertyDescriptor(attributes);
            JSRuntime.definePropertyOrThrow(thisObj, property, desc);
            return thisObj;
        }

        @Specialization(replaces={"definePropertyJSObjectString"})
        protected DynamicObject definePropertyGeneric(Object thisObj, Object property, Object attributes) {
            DynamicObject object = this.asJSObject(thisObj);
            PropertyDescriptor desc = this.toPropertyDescriptor(attributes);
            Object propertyKey = this.toPropertyKeyNode.execute(property);
            JSRuntime.definePropertyOrThrow(object, propertyKey, desc);
            return object;
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return ObjectFunctionBuiltinsFactory.ObjectDefinePropertyNodeGen.create(this.getContext(), this.getBuiltin(), ObjectDefinePropertyNode.cloneUninitialized(this.getArguments(), materializedTags));
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class ObjectCreateNode
    extends ObjectDefineOperation {
        @Node.Child
        private CreateObjectNode.CreateObjectWithPrototypeNode objectCreateNode;
        private final BranchProfile needDefineProperties = BranchProfile.create();

        public ObjectCreateNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSNull(prototype)"})
        protected DynamicObject createPrototypeNull(Object prototype, Object properties) {
            DynamicObject ret = JSOrdinary.createWithNullPrototype(this.getContext());
            return this.objectDefineProperties(ret, properties);
        }

        @Specialization(guards={"!isJSNull(prototype)", "!isJSObject(prototype)"}, limit="InteropLibraryLimit")
        protected DynamicObject createForeignNullOrInvalidPrototype(Object prototype, Object properties, @CachedLibrary(value="prototype") InteropLibrary interop, @Cached(value="createBinaryProfile()") ConditionProfile isNull) {
            assert (prototype != null);
            if (isNull.profile(prototype != Undefined.instance && interop.isNull(prototype))) {
                return this.createPrototypeNull((Object)Null.instance, properties);
            }
            throw Errors.createTypeErrorInvalidPrototype(prototype);
        }

        @Specialization(guards={"isJSObject(prototype)", "isJSObject(properties)"})
        protected DynamicObject createObjectObject(DynamicObject prototype, DynamicObject properties) {
            DynamicObject ret = this.createObjectWithPrototype(prototype);
            this.intlDefineProperties(ret, properties);
            return ret;
        }

        @Specialization(guards={"isJSObject(prototype)", "!isJSNull(properties)"})
        protected DynamicObject createObjectNotNull(DynamicObject prototype, Object properties) {
            DynamicObject ret = this.createObjectWithPrototype(prototype);
            return this.objectDefineProperties(ret, properties);
        }

        @Specialization(guards={"isJSObject(prototype)", "isJSNull(properties)"})
        protected DynamicObject createObjectNull(DynamicObject prototype, Object properties) {
            throw Errors.createTypeErrorNotObjectCoercible(properties, null, this.getContext());
        }

        private DynamicObject objectDefineProperties(DynamicObject ret, Object properties) {
            if (properties != Undefined.instance) {
                this.needDefineProperties.enter();
                this.intlDefineProperties(ret, this.toJSObject(properties));
            }
            return ret;
        }

        private DynamicObject createObjectWithPrototype(DynamicObject prototype) {
            if (this.objectCreateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.objectCreateNode = (CreateObjectNode.CreateObjectWithPrototypeNode)this.insert(CreateObjectNode.createOrdinaryWithPrototype(this.getContext()));
            }
            return this.objectCreateNode.execute(prototype);
        }
    }

    protected static abstract class ObjectDefineOperation
    extends ObjectPrototypeBuiltins.ObjectOperation {
        @Node.Child
        private ToPropertyDescriptorNode toPropertyDescriptorNode;

        public ObjectDefineOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected PropertyDescriptor toPropertyDescriptor(Object target) {
            if (this.toPropertyDescriptorNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toPropertyDescriptorNode = (ToPropertyDescriptorNode)this.insert(ToPropertyDescriptorNode.create(this.getContext()));
            }
            return (PropertyDescriptor)this.toPropertyDescriptorNode.execute(target);
        }

        @CompilerDirectives.TruffleBoundary
        protected DynamicObject intlDefineProperties(DynamicObject obj, DynamicObject descs) {
            ArrayList descriptors = new ArrayList();
            JSClass descsClass = JSObject.getJSClass(descs);
            for (Object key : descsClass.ownPropertyKeys(descs)) {
                PropertyDescriptor keyDesc = descsClass.getOwnProperty(descs, key);
                if (keyDesc == null || !keyDesc.getEnumerable()) continue;
                PropertyDescriptor desc = this.toPropertyDescriptor(descsClass.get(descs, key));
                Boundaries.listAdd(descriptors, new Pair<Object, PropertyDescriptor>(key, desc));
            }
            for (Pair descPair : descriptors) {
                JSRuntime.definePropertyOrThrow(obj, descPair.getFirst(), (PropertyDescriptor)descPair.getSecond());
            }
            return obj;
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class ObjectGetOwnPropertyNamesOrSymbolsNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        protected final boolean symbols;

        public ObjectGetOwnPropertyNamesOrSymbolsNode(JSContext context, JSBuiltin builtin, boolean symbols) {
            super(context, builtin);
            this.symbols = symbols;
        }

        @Specialization(guards={"isJSObject(thisObj)"})
        protected DynamicObject getJSObject(DynamicObject thisObj, @Cached @Cached.Shared(value="jsclassProfile") JSClassProfile jsclassProfile, @Cached @Cached.Shared(value="listSize") ListSizeNode listSize) {
            List<Object> ownPropertyKeys = jsclassProfile.getJSClass(thisObj).getOwnPropertyKeys(thisObj, !this.symbols, this.symbols);
            return JSArray.createLazyArray(this.getContext(), this.getRealm(), ownPropertyKeys, listSize.execute(ownPropertyKeys));
        }

        @Specialization(guards={"!isJSObject(thisObj)", "!isForeignObject(thisObj)"})
        protected DynamicObject getDefault(Object thisObj, @Cached @Cached.Shared(value="jsclassProfile") JSClassProfile jsclassProfile, @Cached @Cached.Shared(value="listSize") ListSizeNode listSize) {
            DynamicObject object = this.toOrAsJSObject(thisObj);
            return this.getJSObject(object, jsclassProfile, listSize);
        }

        @Specialization(guards={"isForeignObject(thisObj)", "symbols"})
        protected DynamicObject getForeignObjectSymbols(Object thisObj) {
            return JSArray.createConstantEmptyArray(this.getContext(), this.getRealm());
        }

        @Specialization(guards={"isForeignObject(thisObj)", "!symbols"}, limit="InteropLibraryLimit")
        protected DynamicObject getForeignObjectNames(Object thisObj, @CachedLibrary(value="thisObj") InteropLibrary interop, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary members, @Cached BranchProfile errorBranch) {
            Object[] array;
            if (interop.hasMembers(thisObj)) {
                try {
                    Object keysObj = interop.getMembers(thisObj);
                    long size = members.getArraySize(keysObj);
                    if (size < 0L || size >= Integer.MAX_VALUE) {
                        errorBranch.enter();
                        throw Errors.createRangeErrorInvalidArrayLength();
                    }
                    array = new Object[(int)size];
                    int i = 0;
                    while ((long)i < size) {
                        Object key = members.readArrayElement(keysObj, (long)i);
                        assert (((InteropLibrary)InteropLibrary.getFactory().getUncached()).isString(key));
                        array[i] = key;
                        ++i;
                    }
                }
                catch (InvalidArrayIndexException | UnsupportedMessageException e) {
                    array = ScriptArray.EMPTY_OBJECT_ARRAY;
                }
            } else {
                array = ScriptArray.EMPTY_OBJECT_ARRAY;
            }
            return JSArray.createConstant(this.getContext(), this.getRealm(), array);
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class ObjectGetOwnPropertyDescriptorsNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        @Node.Child
        private FromPropertyDescriptorNode fromPropertyDescriptorNode = FromPropertyDescriptorNode.create();
        @Node.Child
        private DynamicObjectLibrary putPropDescNode = (DynamicObjectLibrary)DynamicObjectLibrary.getFactory().createDispatched(5);

        public ObjectGetOwnPropertyDescriptorsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected abstract DynamicObject executeEvaluated(Object var1);

        @Specialization(guards={"isJSObject(thisObj)"})
        protected DynamicObject getJSObject(DynamicObject thisObj, @Cached JSGetOwnPropertyNode getOwnPropertyNode, @Cached ListSizeNode listSize, @Cached ListGetNode listGet, @Cached JSClassProfile classProfile) {
            DynamicObject retObj = JSOrdinary.create(this.getContext(), this.getRealm());
            List<Object> ownPropertyKeys = JSObject.ownPropertyKeys(thisObj, classProfile);
            int size = listSize.execute(ownPropertyKeys);
            for (int i = 0; i < size; ++i) {
                Object key = listGet.execute(ownPropertyKeys, i);
                assert (JSRuntime.isPropertyKey(key));
                PropertyDescriptor desc = getOwnPropertyNode.execute(thisObj, key);
                if (desc == null) continue;
                DynamicObject propDesc = this.fromPropertyDescriptorNode.execute(desc, this.getContext());
                this.putPropDescNode.putWithFlags(retObj, key, (Object)propDesc, JSAttributes.configurableEnumerableWritable());
            }
            return retObj;
        }

        @Specialization(guards={"isForeignObject(thisObj)"}, limit="InteropLibraryLimit")
        protected DynamicObject getForeignObject(Object thisObj, @CachedLibrary(value="thisObj") InteropLibrary interop, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary members, @Cached(value="create()") ImportValueNode toJSType, @Cached BranchProfile errorBranch) {
            DynamicObject result = JSOrdinary.create(this.getContext(), this.getRealm());
            try {
                if (interop.hasMembers(thisObj)) {
                    Object keysObj = interop.getMembers(thisObj);
                    long size = members.getArraySize(keysObj);
                    if (size < 0L || size >= Integer.MAX_VALUE) {
                        errorBranch.enter();
                        throw Errors.createRangeErrorInvalidArrayLength();
                    }
                    int i = 0;
                    while ((long)i < size) {
                        String member = (String)members.readArrayElement(keysObj, (long)i);
                        if (interop.isMemberReadable(thisObj, member)) {
                            PropertyDescriptor desc = PropertyDescriptor.createData(toJSType.executeWithTarget(interop.readMember(thisObj, member)), !interop.isMemberInternal(thisObj, member), interop.isMemberWritable(thisObj, member), interop.isMemberRemovable(thisObj, member));
                            DynamicObject propDesc = this.fromPropertyDescriptorNode.execute(desc, this.getContext());
                            this.putPropDescNode.putWithFlags(result, (Object)member, (Object)propDesc, JSAttributes.configurableEnumerableWritable());
                        }
                        ++i;
                    }
                }
                if (interop.hasArrayElements(thisObj)) {
                    long size = interop.getArraySize(thisObj);
                    if (size < 0L || size >= Integer.MAX_VALUE) {
                        errorBranch.enter();
                        throw Errors.createRangeErrorInvalidArrayLength();
                    }
                    for (long i = 0L; i < size; ++i) {
                        if (!interop.isArrayElementExisting(thisObj, i) || !interop.isArrayElementReadable(thisObj, i)) continue;
                        PropertyDescriptor desc = PropertyDescriptor.createData(toJSType.executeWithTarget(interop.readArrayElement(thisObj, i)), true, interop.isArrayElementWritable(thisObj, i), interop.isArrayElementRemovable(thisObj, i));
                        DynamicObject propDesc = this.fromPropertyDescriptorNode.execute(desc, this.getContext());
                        this.putPropDescNode.putWithFlags(result, (Object)Boundaries.stringValueOf(i), (Object)propDesc, JSAttributes.configurableEnumerableWritable());
                    }
                }
            }
            catch (InteropException interopException) {
                // empty catch block
            }
            return result;
        }

        @Specialization(guards={"!isJSObject(thisObj)", "!isForeignObject(thisObj)"})
        protected DynamicObject getDefault(Object thisObj, @Cached(value="createRecursive()") ObjectGetOwnPropertyDescriptorsNode recursive) {
            Object object = this.toObject(thisObj);
            return recursive.executeEvaluated(object);
        }

        ObjectGetOwnPropertyDescriptorsNode createRecursive() {
            return ObjectFunctionBuiltinsFactory.ObjectGetOwnPropertyDescriptorsNodeGen.create(this.getContext(), this.getBuiltin(), new JavaScriptNode[0]);
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class ObjectGetOwnPropertyDescriptorNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        @Node.Child
        private JSToPropertyKeyNode toPropertyKeyNode = JSToPropertyKeyNode.create();
        @Node.Child
        private JSGetOwnPropertyNode getOwnPropertyNode = JSGetOwnPropertyNode.create();
        @Node.Child
        private FromPropertyDescriptorNode fromPropertyDescriptorNode = FromPropertyDescriptorNode.create();

        public ObjectGetOwnPropertyDescriptorNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSObject(thisObj)"})
        protected DynamicObject getJSObject(DynamicObject thisObj, Object property) {
            Object propertyKey = this.toPropertyKeyNode.execute(property);
            PropertyDescriptor desc = this.getOwnPropertyNode.execute(thisObj, propertyKey);
            return this.fromPropertyDescriptorNode.execute(desc, this.getContext());
        }

        @Specialization(guards={"isForeignObject(thisObj)"}, limit="InteropLibraryLimit")
        protected DynamicObject getForeignObject(Object thisObj, Object property, @CachedLibrary(value="thisObj") InteropLibrary interop, @Cached(value="create()") ImportValueNode toJSType) {
            Object propertyKey = this.toPropertyKeyNode.execute(property);
            if (propertyKey instanceof String) {
                try {
                    String member = (String)propertyKey;
                    if (interop.hasMembers(thisObj) && interop.isMemberExisting(thisObj, member) && interop.isMemberReadable(thisObj, member)) {
                        PropertyDescriptor desc = PropertyDescriptor.createData(toJSType.executeWithTarget(interop.readMember(thisObj, member)), !interop.isMemberInternal(thisObj, member), interop.isMemberWritable(thisObj, member), interop.isMemberRemovable(thisObj, member));
                        return this.fromPropertyDescriptorNode.execute(desc, this.getContext());
                    }
                    long index = JSRuntime.propertyNameToArrayIndex(member);
                    if (JSRuntime.isArrayIndex(index) && interop.hasArrayElements(thisObj) && interop.isArrayElementExisting(thisObj, index) && interop.isArrayElementReadable(thisObj, index)) {
                        PropertyDescriptor desc = PropertyDescriptor.createData(toJSType.executeWithTarget(interop.readArrayElement(thisObj, index)), true, interop.isArrayElementWritable(thisObj, index), interop.isArrayElementRemovable(thisObj, index));
                        return this.fromPropertyDescriptorNode.execute(desc, this.getContext());
                    }
                }
                catch (InteropException interopException) {
                    // empty catch block
                }
            }
            return Undefined.instance;
        }

        @Specialization(guards={"!isJSObject(thisObj)", "!isForeignObject(thisObj)"})
        protected DynamicObject getDefault(Object thisObj, Object property) {
            Object object = this.toObject(thisObj);
            assert (JSDynamicObject.isJSDynamicObject(object));
            return this.getJSObject((DynamicObject)object, property);
        }
    }

    public static abstract class ObjectGetPrototypeOfNode
    extends ObjectPrototypeBuiltins.ObjectOperation {
        @Node.Child
        private ForeignObjectPrototypeNode foreignObjectPrototypeNode;

        public ObjectGetPrototypeOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"!isJSObject(object)"})
        protected DynamicObject getPrototypeOfNonObject(Object object) {
            if (this.getContext().getEcmaScriptVersion() < 6) {
                if (JSRuntime.isJSPrimitive(object)) {
                    throw Errors.createTypeErrorNotAnObject(object);
                }
                return Null.instance;
            }
            Object tobject = this.toObject(object);
            if (JSDynamicObject.isJSDynamicObject(tobject)) {
                return JSObject.getPrototype((DynamicObject)tobject);
            }
            if (this.getContext().getContextOptions().hasForeignObjectPrototype()) {
                return this.getForeignObjectPrototype(tobject);
            }
            return Null.instance;
        }

        private DynamicObject getForeignObjectPrototype(Object truffleObject) {
            assert (JSRuntime.isForeignObject(truffleObject));
            if (this.foreignObjectPrototypeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.foreignObjectPrototypeNode = (ForeignObjectPrototypeNode)this.insert(ForeignObjectPrototypeNode.create());
            }
            return this.foreignObjectPrototypeNode.executeDynamicObject(truffleObject);
        }

        @Specialization(guards={"isJSObject(object)"})
        protected DynamicObject getPrototypeOfJSObject(DynamicObject object, @Cached(value="create()") GetPrototypeNode getPrototypeNode) {
            return getPrototypeNode.executeJSObject(object);
        }
    }

    public static final class ObjectFunctionNashornCompatBuiltins
    extends JSBuiltinsContainer.SwitchEnum<ObjectNashornCompat> {
        protected ObjectFunctionNashornCompatBuiltins() {
            super(ObjectNashornCompat.class);
        }

        @Override
        protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, ObjectNashornCompat builtinEnum) {
            switch (builtinEnum) {
                case bindProperties: {
                    return ObjectFunctionBuiltinsFactory.ObjectBindPropertiesNodeGen.create(context, builtin, ObjectFunctionNashornCompatBuiltins.args().fixedArgs(2).createArgumentNodes(context));
                }
            }
            return null;
        }

        public static enum ObjectNashornCompat implements BuiltinEnum<ObjectNashornCompat>
        {
            bindProperties(2);

            private final int length;

            private ObjectNashornCompat(int length) {
                this.length = length;
            }

            @Override
            public int getLength() {
                return this.length;
            }
        }
    }

    public static enum ObjectFunction implements BuiltinEnum<ObjectFunction>
    {
        create(2),
        defineProperties(2),
        defineProperty(3),
        freeze(1),
        getOwnPropertyDescriptor(2),
        getOwnPropertyNames(1),
        getPrototypeOf(1),
        isExtensible(1),
        isFrozen(1),
        isSealed(1),
        keys(1),
        preventExtensions(1),
        seal(1),
        setPrototypeOf(2),
        is(2),
        getOwnPropertySymbols(1),
        assign(2),
        getOwnPropertyDescriptors(1),
        values(1),
        entries(1),
        fromEntries(1),
        hasOwn(2);

        private final int length;

        private ObjectFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getECMAScriptVersion() {
            if (EnumSet.of(is, getOwnPropertySymbols, assign).contains(this)) {
                return 6;
            }
            if (EnumSet.of(getOwnPropertyDescriptors, values, entries).contains(this)) {
                return 8;
            }
            if (this == fromEntries) {
                return 10;
            }
            if (this == hasOwn) {
                return 13;
            }
            return BuiltinEnum.super.getECMAScriptVersion();
        }
    }
}

