/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.find.files.actions;

import com.paterva.maltego.find.files.FindInFilesResult;
import com.paterva.maltego.util.ui.WindowUtil;
import java.io.File;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class OpenGraphAction
extends NodeAction {
    public String getName() {
        return "Open Graph";
    }

    protected boolean enable(Node[] nodes) {
        for (Node node : nodes) {
            if (node.getLookup().lookup(FindInFilesResult.class) == null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Node[] nodes) {
        for (Node node : nodes) {
            FindInFilesResult result = (FindInFilesResult)node.getLookup().lookup(FindInFilesResult.class);
            if (result == null) continue;
            try {
                WindowUtil.showWaitCursor();
                File file = new File(result.getFolderPath(), result.getGraphName());
                FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                if (fo == null) {
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)("The file was not found:\n" + file.getAbsolutePath()), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                    continue;
                }
                DataObject dao = DataObject.find((FileObject)fo);
                if (dao == null) continue;
                OpenCookie open = (OpenCookie)dao.getLookup().lookup(OpenCookie.class);
                open.open();
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                WindowUtil.hideWaitCursor();
            }
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

