/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.thirdparty.jline;

import com.oracle.svm.core.jdk.Resources;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.graalvm.nativeimage.hosted.Feature;

public final class JLine3Feature
implements Feature {
    private static final List<String> RESOURCES = Arrays.asList("capabilities.txt", "colors.txt", "ansi.caps", "dumb.caps", "dumb-color.caps", "screen.caps", "screen-256color.caps", "windows.caps", "windows-256color.caps", "windows-conemu.caps", "windows-vtp.caps", "xterm.caps", "xterm-256color.caps");
    private static final String RESOURCE_PATH = "org/graalvm/shadowed/org/jline/utils/";
    private static final String JNA_SUPPORT_IMPL = "org.graalvm.shadowed.org.jline.terminal.impl.jna.JnaSupportImpl";

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return access.findClassByName(JNA_SUPPORT_IMPL) != null;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        for (String resource : RESOURCES) {
            String resourcePath = RESOURCE_PATH + resource;
            InputStream resourceAsStream = ClassLoader.getSystemResourceAsStream(resourcePath);
            Resources.registerResource((String)resourcePath, (InputStream)resourceAsStream);
        }
    }
}

