/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.controls;

import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.ChangeEventPropagator;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class AttachPanel
extends JPanel {
    private final ChangeEventPropagator _changeSupport = new ChangeEventPropagator((Object)this);
    public static final String PREF_PREV_DIR = "attachPrevDir";
    public static final int SOURCE_FILE = 0;
    public static final int SOURCE_URL = 1;
    private JButton _browseButton;
    private JRadioButton _fileRadioButton;
    private JTextField _fileTextField;
    private JRadioButton _urlRadioButton;
    private JTextField _urlTextField;

    public AttachPanel() {
        this.initComponents();
        ActionListener radioListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttachPanel.this.onSourceChanged();
                AttachPanel.this._changeSupport.stateChanged(null);
            }
        };
        this._fileRadioButton.addActionListener(radioListener);
        this._urlRadioButton.addActionListener(radioListener);
        this._fileTextField.getDocument().addDocumentListener((DocumentListener)this._changeSupport);
        this._urlTextField.getDocument().addDocumentListener((DocumentListener)this._changeSupport);
    }

    public void setFiles(List<File> files) {
        this._fileTextField.setText(AttachPanel.toStringFiles(files));
    }

    public List<File> getFiles() {
        return AttachPanel.parseFiles(this._fileTextField.getText());
    }

    public void setURLs(List<FastURL> urls) {
        this._urlTextField.setText(AttachPanel.toStringURLs(urls));
    }

    public List<FastURL> getURLs() {
        return AttachPanel.parseURLs(this._urlTextField.getText());
    }

    public void setSource(int option) {
        if (option == 0) {
            this._fileRadioButton.setSelected(true);
        } else {
            this._urlRadioButton.setSelected(true);
        }
        this.onSourceChanged();
    }

    public int getSource() {
        return this._fileRadioButton.isSelected() ? 0 : 1;
    }

    protected void onSourceChanged() {
        boolean isFileSource = this._fileRadioButton.isSelected();
        this._fileTextField.setEnabled(isFileSource);
        this._browseButton.setEnabled(isFileSource);
        this._urlTextField.setEnabled(!isFileSource);
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeSupport.removeChangeListener(listener);
    }

    private static List<String> tokenize(String text) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (text != null) {
            text = text.replaceAll("\" \"", "\";\"");
            text = text.trim();
        }
        if (!StringUtilities.isNullOrEmpty((String)text)) {
            for (String token : text.split(";")) {
                token = token.replaceAll("\"", "");
                if ((token = token.trim()).isEmpty()) continue;
                tokens.add(token);
            }
        }
        return tokens;
    }

    public static List<File> parseFiles(String text) {
        ArrayList<File> files = new ArrayList<File>();
        for (String filePath : AttachPanel.tokenize(text)) {
            files.add(new File(filePath));
        }
        return files;
    }

    public static String toStringFiles(List<File> files) {
        if (files == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (File file : files) {
            if (!first) {
                sb.append(";");
            } else {
                first = false;
            }
            sb.append(file.getAbsolutePath());
        }
        return sb.toString();
    }

    public static List<FastURL> parseURLs(String text) {
        ArrayList<FastURL> urls = new ArrayList<FastURL>();
        for (String url : AttachPanel.tokenize(text)) {
            urls.add(new FastURL(url));
        }
        return urls;
    }

    public static String toStringURLs(List<FastURL> urls) {
        if (urls == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (FastURL url : urls) {
            if (!first) {
                sb.append(";");
            } else {
                first = false;
            }
            sb.append(url.toString());
        }
        return sb.toString();
    }

    private void initComponents() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this._fileRadioButton = new JRadioButton();
        this._urlRadioButton = new JRadioButton();
        this._fileTextField = new JTextField();
        this._urlTextField = new JTextField();
        this._browseButton = new JButton();
        buttonGroup.add(this._fileRadioButton);
        this._fileRadioButton.setText(NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel._fileRadioButton.text"));
        buttonGroup.add(this._urlRadioButton);
        this._urlRadioButton.setText(NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel._urlRadioButton.text"));
        this._fileTextField.setText(NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel._fileTextField.text"));
        this._fileTextField.setToolTipText(NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel._fileTextField.toolTipText"));
        this._urlTextField.setText(NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel._urlTextField.text"));
        this._urlTextField.setToolTipText(NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel._urlTextField.toolTipText"));
        this._browseButton.setText(NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel._browseButton.text"));
        this._browseButton.setPreferredSize(new Dimension(30, 23));
        this._browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttachPanel.this._browseButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._fileRadioButton).addComponent(this._urlRadioButton)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._urlTextField, -1, 349, Short.MAX_VALUE).addComponent(this._fileTextField, -1, 349, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._browseButton, -2, -1, -2).addGap(41, 41, 41)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._fileRadioButton).addComponent(this._fileTextField, -2, -1, -2).addComponent(this._browseButton, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._urlRadioButton).addComponent(this._urlTextField, -2, -1, -2)).addContainerGap(12, Short.MAX_VALUE)));
    }

    private void _browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser(this.getPrevDir());
        fc.setDialogTitle("Attach file(s)");
        fc.setApproveButtonText("Attach");
        fc.setMultiSelectionEnabled(true);
        if (0 == fc.showOpenDialog(this)) {
            File[] selectedFiles = fc.getSelectedFiles();
            if (selectedFiles.length > 0) {
                this.setPrevDir(selectedFiles[0].getParent());
            }
            this.setFiles(Arrays.asList(selectedFiles));
        }
    }

    private String getPrevDir() {
        return NbPreferences.forModule(AttachPanel.class).get(PREF_PREV_DIR, "");
    }

    private void setPrevDir(String dir) {
        NbPreferences.forModule(AttachPanel.class).put(PREF_PREV_DIR, dir);
    }
}

