/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.propertygrid.editors;

import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.editing.UnsupportedEditorException;
import com.paterva.maltego.typing.editing.controls.ArrayEditorPanel;
import com.paterva.maltego.typing.editing.form.adapters.DefaultAdapterFactory;
import com.paterva.maltego.typing.editing.propertygrid.editors.TypePropertyEditor;
import com.paterva.maltego.util.ArrayUtilities;
import java.awt.Component;
import java.text.Format;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.Exceptions;

class ArrayPropertyEditor
extends TypePropertyEditor {
    private ArrayEditorPanel _editor;

    public ArrayPropertyEditor(Class type, Format format) {
        super(type, format);
        if (!type.isArray()) {
            throw new IllegalArgumentException("The array editor can only used with array types");
        }
    }

    @Override
    public Component getCustomEditor() {
        if (this._editor == null) {
            try {
                this._editor = new ArrayEditorPanel(DefaultAdapterFactory.instance().create(this.getType().getComponentType(), this.getFormat()), this.getFormat());
            }
            catch (UnsupportedEditorException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
            this.updateEditor();
            this._editor.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ArrayPropertyEditor.this.updateValues();
                }
            });
        }
        return this._editor;
    }

    private void updateEditor() {
        if (this._editor != null) {
            this._editor.setValue((Object[])Converter.changeArrayType((Object)this.getValue(), (Class)Converter.getReferenceType(this.getType().getComponentType())));
        }
    }

    private void updateValues() {
        Class<?> componentType = this.getType().getComponentType();
        Object[] value = this._editor.getValue();
        Class referenceType = Converter.getReferenceType(componentType);
        Object[] array = (Object[])Converter.changeArrayType((Object)value, (Class)referenceType);
        if (!componentType.isPrimitive()) {
            this.setValue(array);
        } else {
            Class<?> componentObjectType = array.getClass().getComponentType();
            if (Boolean.class.equals(componentObjectType)) {
                this.setValue(ArrayUtilities.toPrimitiveArray((Boolean[])((Boolean[])array)));
            } else if (Character.class.equals(componentObjectType)) {
                this.setValue(ArrayUtilities.toPrimitiveArray((Character[])((Character[])array)));
            } else if (Integer.class.equals(componentObjectType)) {
                this.setValue(ArrayUtilities.toPrimitiveArray((Integer[])((Integer[])array)));
            } else if (Byte.class.equals(componentObjectType)) {
                this.setValue(ArrayUtilities.toPrimitiveArray((Byte[])((Byte[])array)));
            } else if (Short.class.equals(componentObjectType)) {
                this.setValue(ArrayUtilities.toPrimitiveArray((Short[])((Short[])array)));
            } else if (Long.class.equals(componentObjectType)) {
                this.setValue(ArrayUtilities.toPrimitiveArray((Long[])((Long[])array)));
            } else if (Float.class.equals(componentObjectType)) {
                this.setValue(ArrayUtilities.toPrimitiveArray((Float[])((Float[])array)));
            } else if (Double.class.equals(componentObjectType)) {
                this.setValue(ArrayUtilities.toPrimitiveArray((Double[])((Double[])array)));
            }
        }
    }

    @Override
    public void setAsText(String s) {
        super.setAsText(s);
        this.updateEditor();
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }
}

