/*BEGIN_LEGAL 
Intel Open Source License 

Copyright (c) 2002-2017 Intel Corporation. All rights reserved.
 
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.  Redistributions
in binary form must reproduce the above copyright notice, this list of
conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.  Neither the name of
the Intel Corporation nor the names of its contributors may be used to
endorse or promote products derived from this software without
specific prior written permission.
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE INTEL OR
ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
END_LEGAL */
// <COMPONENT>: debugger-protocol
// <FILE-TYPE>: component public header

#ifndef DEBUGGER_PROTOCOL_REGS_GDB_LINUX_AVX512_64_HPP
#define DEBUGGER_PROTOCOL_REGS_GDB_LINUX_AVX512_64_HPP

#include "debugger-protocol.hpp"


namespace DEBUGGER_PROTOCOL {

#if defined(DEBUGGER_PROTOCOL_BUILD)    // Library clients should NOT define this.

/*!
 * This is the register set used by GDB for 64-bit AVX512 on Linux.
 */
DEBUGGER_PROTOCOL_API REG_DESCRIPTION RegsGdbLinuxAvx512_64[] =
{
    {64, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_RAX
    {64, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_RBX
    {64, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_RCX
    {64, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_RDX
    {64, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_RSI
    {64, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_RDI
    {64, REG_INVALID, true},    // REG_GDB_LINUX_AVX512_64_RBP
    {64, REG_INVALID, true},    // REG_GDB_LINUX_AVX512_64_RSP
    {64, REG_INVALID, false},    // REG_GDB_LINUX_AVX512_64_R8
    {64, REG_INVALID, false},    // REG_GDB_LINUX_AVX512_64_R9
    {64, REG_INVALID, false},    // REG_GDB_LINUX_AVX512_64_R10
    {64, REG_INVALID, false},    // REG_GDB_LINUX_AVX512_64_R11
    {64, REG_INVALID, false},    // REG_GDB_LINUX_AVX512_64_R12
    {64, REG_INVALID, false},    // REG_GDB_LINUX_AVX512_64_R13
    {64, REG_INVALID, false},    // REG_GDB_LINUX_AVX512_64_R14
    {64, REG_INVALID, false},    // REG_GDB_LINUX_AVX512_64_R15
    {64, REG_PC, true},         // REG_GDB_LINUX_AVX512_64_PC
    {32, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_EFLAGS
    {32, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_CS
    {32, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_SS
    {32, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_DS
    {32, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_ES
    {32, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_FS
    {32, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_GS
    {80, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_ST0
    {80, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_ST1
    {80, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_ST2
    {80, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_ST3
    {80, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_ST4
    {80, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_ST5
    {80, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_ST6
    {80, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_ST7
    {32, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_FCTRL
    {32, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_FSTAT
    {32, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_FTAG_FULL
    {32, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_FISEG
    {32, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_FIOFF
    {32, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_FOSEG
    {32, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_FOOFF
    {32, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_FOP
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM0
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM1
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM2
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM3
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM4
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM5
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM6
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM7
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM8
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM9
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM10
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM11
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM12
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM13
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM14
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM15
    {32, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_MXCSR
    {64, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_ORIG_RAX
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM0H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM1H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM2H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM3H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM4H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM5H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM6H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM7H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM8H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM9H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM10H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM11H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM12H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM13H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM14H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM15H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM16
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM17
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM18
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM19
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM20
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM21
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM22
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM23
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM24
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM25
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM26
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM27
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM28
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM29
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM30
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_XMM31
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM16H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM17H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM18H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM19H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM20H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM21H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM22H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM23H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM24H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM25H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM26H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM27H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM28H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM29H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM30H
    {128, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_YMM31H
    {64, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_K0
    {64, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_K1
    {64, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_K2
    {64, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_K3
    {64, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_K4
    {64, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_K5
    {64, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_K6
    {64, REG_INVALID, false},   // REG_GDB_LINUX_AVX512_64_K7
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM0H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM1H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM2H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM3H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM4H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM5H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM6H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM7H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM8H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM9H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM10H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM11H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM12H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM13H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM14H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM15H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM16H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM17H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM18H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM19H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM20H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM21H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM22H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM23H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM24H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM25H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM26H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM27H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM28H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM29H
    {256, REG_INVALID, false},  // REG_GDB_LINUX_AVX512_64_ZMM30H
    {256, REG_INVALID, false}   // REG_GDB_LINUX_AVX512_64_ZMM31H
};

/*!
 * Number of entries in RegsGdbLinuxAvx512_64.
 */
DEBUGGER_PROTOCOL_API unsigned RegsGdbLinuxAvx512_64Count = sizeof(RegsGdbLinuxAvx512_64) / sizeof(RegsGdbLinuxAvx512_64[0]);

#else

DEBUGGER_PROTOCOL_API extern REG_DESCRIPTION RegsGdbLinuxAvx512_64[];     ///< GDB's 64-bit AVX512 register set on Linux.
DEBUGGER_PROTOCOL_API extern unsigned RegsGdbLinuxAvx512_64Count;         ///< Number of entries in RegsGdbLinuxAvx512_64.

#endif /*DEBUGGER_PROTOCOL_BUILD*/


/*!
 * Convenient identifiers for the registers in this set.
 */
enum REG_GDB_LINUX_AVX512_64
{
    REG_GDB_LINUX_AVX512_64_FIRST = REG_END,
    REG_GDB_LINUX_AVX512_64_RAX = REG_GDB_LINUX_AVX512_64_FIRST,
    REG_GDB_LINUX_AVX512_64_RBX,
    REG_GDB_LINUX_AVX512_64_RCX,
    REG_GDB_LINUX_AVX512_64_RDX,
    REG_GDB_LINUX_AVX512_64_RSI,
    REG_GDB_LINUX_AVX512_64_RDI,
    REG_GDB_LINUX_AVX512_64_RBP,
    REG_GDB_LINUX_AVX512_64_RSP,
    REG_GDB_LINUX_AVX512_64_R8,
    REG_GDB_LINUX_AVX512_64_R9,
    REG_GDB_LINUX_AVX512_64_R10,
    REG_GDB_LINUX_AVX512_64_R11,
    REG_GDB_LINUX_AVX512_64_R12,
    REG_GDB_LINUX_AVX512_64_R13,
    REG_GDB_LINUX_AVX512_64_R14,
    REG_GDB_LINUX_AVX512_64_R15,
    REG_GDB_LINUX_AVX512_64_PC,
    REG_GDB_LINUX_AVX512_64_EFLAGS,
    REG_GDB_LINUX_AVX512_64_CS,
    REG_GDB_LINUX_AVX512_64_SS,
    REG_GDB_LINUX_AVX512_64_DS,
    REG_GDB_LINUX_AVX512_64_ES,
    REG_GDB_LINUX_AVX512_64_FS,
    REG_GDB_LINUX_AVX512_64_GS,
    REG_GDB_LINUX_AVX512_64_ST0,
    REG_GDB_LINUX_AVX512_64_ST1,
    REG_GDB_LINUX_AVX512_64_ST2,
    REG_GDB_LINUX_AVX512_64_ST3,
    REG_GDB_LINUX_AVX512_64_ST4,
    REG_GDB_LINUX_AVX512_64_ST5,
    REG_GDB_LINUX_AVX512_64_ST6,
    REG_GDB_LINUX_AVX512_64_ST7,
    REG_GDB_LINUX_AVX512_64_FCTRL,
    REG_GDB_LINUX_AVX512_64_FSTAT,
    REG_GDB_LINUX_AVX512_64_FTAG_FULL,      // 16-bit "full" encoding
    REG_GDB_LINUX_AVX512_64_FISEG,
    REG_GDB_LINUX_AVX512_64_FIOFF,
    REG_GDB_LINUX_AVX512_64_FOSEG,
    REG_GDB_LINUX_AVX512_64_FOOFF,
    REG_GDB_LINUX_AVX512_64_FOP,
    REG_GDB_LINUX_AVX512_64_XMM0,
    REG_GDB_LINUX_AVX512_64_XMM1,
    REG_GDB_LINUX_AVX512_64_XMM2,
    REG_GDB_LINUX_AVX512_64_XMM3,
    REG_GDB_LINUX_AVX512_64_XMM4,
    REG_GDB_LINUX_AVX512_64_XMM5,
    REG_GDB_LINUX_AVX512_64_XMM6,
    REG_GDB_LINUX_AVX512_64_XMM7,
    REG_GDB_LINUX_AVX512_64_XMM8,
    REG_GDB_LINUX_AVX512_64_XMM9,
    REG_GDB_LINUX_AVX512_64_XMM10,
    REG_GDB_LINUX_AVX512_64_XMM11,
    REG_GDB_LINUX_AVX512_64_XMM12,
    REG_GDB_LINUX_AVX512_64_XMM13,
    REG_GDB_LINUX_AVX512_64_XMM14,
    REG_GDB_LINUX_AVX512_64_XMM15,
    REG_GDB_LINUX_AVX512_64_MXCSR,
    REG_GDB_LINUX_AVX512_64_ORIG_RAX,
    REG_GDB_LINUX_AVX512_64_YMM0H,
    REG_GDB_LINUX_AVX512_64_YMM1H,
    REG_GDB_LINUX_AVX512_64_YMM2H,
    REG_GDB_LINUX_AVX512_64_YMM3H,
    REG_GDB_LINUX_AVX512_64_YMM4H,
    REG_GDB_LINUX_AVX512_64_YMM5H,
    REG_GDB_LINUX_AVX512_64_YMM6H,
    REG_GDB_LINUX_AVX512_64_YMM7H,
    REG_GDB_LINUX_AVX512_64_YMM8H,
    REG_GDB_LINUX_AVX512_64_YMM9H,
    REG_GDB_LINUX_AVX512_64_YMM10H,
    REG_GDB_LINUX_AVX512_64_YMM11H,
    REG_GDB_LINUX_AVX512_64_YMM12H,
    REG_GDB_LINUX_AVX512_64_YMM13H,
    REG_GDB_LINUX_AVX512_64_YMM14H,
    REG_GDB_LINUX_AVX512_64_YMM15H,
    REG_GDB_LINUX_AVX512_64_XMM16,
    REG_GDB_LINUX_AVX512_64_XMM17,
    REG_GDB_LINUX_AVX512_64_XMM18,
    REG_GDB_LINUX_AVX512_64_XMM19,
    REG_GDB_LINUX_AVX512_64_XMM20,
    REG_GDB_LINUX_AVX512_64_XMM21,
    REG_GDB_LINUX_AVX512_64_XMM22,
    REG_GDB_LINUX_AVX512_64_XMM23,
    REG_GDB_LINUX_AVX512_64_XMM24,
    REG_GDB_LINUX_AVX512_64_XMM25,
    REG_GDB_LINUX_AVX512_64_XMM26,
    REG_GDB_LINUX_AVX512_64_XMM27,
    REG_GDB_LINUX_AVX512_64_XMM28,
    REG_GDB_LINUX_AVX512_64_XMM29,
    REG_GDB_LINUX_AVX512_64_XMM30,
    REG_GDB_LINUX_AVX512_64_XMM31,
    REG_GDB_LINUX_AVX512_64_YMM16H,
    REG_GDB_LINUX_AVX512_64_YMM17H,
    REG_GDB_LINUX_AVX512_64_YMM18H,
    REG_GDB_LINUX_AVX512_64_YMM19H,
    REG_GDB_LINUX_AVX512_64_YMM20H,
    REG_GDB_LINUX_AVX512_64_YMM21H,
    REG_GDB_LINUX_AVX512_64_YMM22H,
    REG_GDB_LINUX_AVX512_64_YMM23H,
    REG_GDB_LINUX_AVX512_64_YMM24H,
    REG_GDB_LINUX_AVX512_64_YMM25H,
    REG_GDB_LINUX_AVX512_64_YMM26H,
    REG_GDB_LINUX_AVX512_64_YMM27H,
    REG_GDB_LINUX_AVX512_64_YMM28H,
    REG_GDB_LINUX_AVX512_64_YMM29H,
    REG_GDB_LINUX_AVX512_64_YMM30H,
    REG_GDB_LINUX_AVX512_64_YMM31H,
    REG_GDB_LINUX_AVX512_64_K0,
    REG_GDB_LINUX_AVX512_64_K1,
    REG_GDB_LINUX_AVX512_64_K2,
    REG_GDB_LINUX_AVX512_64_K3,
    REG_GDB_LINUX_AVX512_64_K4,
    REG_GDB_LINUX_AVX512_64_K5,
    REG_GDB_LINUX_AVX512_64_K6,
    REG_GDB_LINUX_AVX512_64_K7,
    REG_GDB_LINUX_AVX512_64_ZMM0H,
    REG_GDB_LINUX_AVX512_64_ZMM1H,
    REG_GDB_LINUX_AVX512_64_ZMM2H,
    REG_GDB_LINUX_AVX512_64_ZMM3H,
    REG_GDB_LINUX_AVX512_64_ZMM4H,
    REG_GDB_LINUX_AVX512_64_ZMM5H,
    REG_GDB_LINUX_AVX512_64_ZMM6H,
    REG_GDB_LINUX_AVX512_64_ZMM7H,
    REG_GDB_LINUX_AVX512_64_ZMM8H,
    REG_GDB_LINUX_AVX512_64_ZMM9H,
    REG_GDB_LINUX_AVX512_64_ZMM10H,
    REG_GDB_LINUX_AVX512_64_ZMM11H,
    REG_GDB_LINUX_AVX512_64_ZMM12H,
    REG_GDB_LINUX_AVX512_64_ZMM13H,
    REG_GDB_LINUX_AVX512_64_ZMM14H,
    REG_GDB_LINUX_AVX512_64_ZMM15H,
    REG_GDB_LINUX_AVX512_64_ZMM16H,
    REG_GDB_LINUX_AVX512_64_ZMM17H,
    REG_GDB_LINUX_AVX512_64_ZMM18H,
    REG_GDB_LINUX_AVX512_64_ZMM19H,
    REG_GDB_LINUX_AVX512_64_ZMM20H,
    REG_GDB_LINUX_AVX512_64_ZMM21H,
    REG_GDB_LINUX_AVX512_64_ZMM22H,
    REG_GDB_LINUX_AVX512_64_ZMM23H,
    REG_GDB_LINUX_AVX512_64_ZMM24H,
    REG_GDB_LINUX_AVX512_64_ZMM25H,
    REG_GDB_LINUX_AVX512_64_ZMM26H,
    REG_GDB_LINUX_AVX512_64_ZMM27H,
    REG_GDB_LINUX_AVX512_64_ZMM28H,
    REG_GDB_LINUX_AVX512_64_ZMM29H,
    REG_GDB_LINUX_AVX512_64_ZMM30H,
    REG_GDB_LINUX_AVX512_64_ZMM31H,
    REG_GDB_LINUX_AVX512_64_LAST = REG_GDB_LINUX_AVX512_64_ZMM31H
};

} // namespace
#endif // file guard
