/*
 * Decompiled with CFR 0.152.
 */
package lt.neworld.vd2svg.converter;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import lt.neworld.vd2svg.LoggerKt;
import lt.neworld.vd2svg.converter.Converter;
import lt.neworld.vd2svg.resources.ResourceCollector;
import lt.neworld.vd2svg.xml.NamedNodeMapKt;
import lt.neworld.vd2svg.xml.NodeListIteratorKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 R2\u00020\u0001:\u0001RB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J$\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010#\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010$\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010%\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\"H\u0002J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010)\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\"H\u0002J \u0010+\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020\"H\u0002J\u001a\u0010.\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u0018H\u0002J\u0010\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u00104\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u0001050!2\u0006\u00106\u001a\u00020\"H\u0002J\u001e\u00107\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u0001050!2\u0006\u00108\u001a\u00020\"H\u0002J\u0010\u00109\u001a\u00020\"2\u0006\u0010:\u001a\u00020\"H\u0002J\u0010\u0010;\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J&\u0010<\u001a\u00020\u0014*\u00020\u00182\u0006\u0010=\u001a\u00020\"2\u0006\u0010>\u001a\u00020\"2\b\b\u0002\u0010?\u001a\u00020\"H\u0002J\u001a\u0010@\u001a\u00020\u0014*\u00020\u00182\f\u0010A\u001a\b\u0012\u0004\u0012\u0002020BH\u0002J\f\u0010C\u001a\u00020\u0014*\u00020\u0018H\u0002J\f\u0010D\u001a\u00020\u0014*\u00020\u0018H\u0002J\f\u0010E\u001a\u00020\u0014*\u00020\u0018H\u0002J\f\u0010F\u001a\u00020\u0014*\u00020\u0018H\u0002J\f\u0010G\u001a\u00020\u0014*\u00020\u0018H\u0002J\f\u0010H\u001a\u00020\u0014*\u00020\u0018H\u0002J\f\u0010'\u001a\u00020\"*\u00020\u0018H\u0002J\f\u0010I\u001a\u00020\u0014*\u00020\u0018H\u0002J.\u0010J\u001a\u00020\u0014*\u00020K2\u0006\u0010L\u001a\u00020\"2\u0006\u0010M\u001a\u00020\"2\b\u0010N\u001a\u0004\u0018\u00010\"2\u0006\u0010O\u001a\u00020\"H\u0002J\u001e\u0010J\u001a\u00020\u0014*\u0002022\u0006\u0010O\u001a\u00020\"2\b\u0010P\u001a\u0004\u0018\u00010\"H\u0002J\u0014\u0010Q\u001a\u00020\u0014*\u00020\u00182\u0006\u0010'\u001a\u00020\"H\u0002R#\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR#\u0010\u000e\u001a\n \u0007*\u0004\u0018\u00010\u000f0\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000b\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006S"}, d2={"Llt/neworld/vd2svg/converter/Converter;", "", "colors", "Llt/neworld/vd2svg/resources/ResourceCollector;", "(Llt/neworld/vd2svg/resources/ResourceCollector;)V", "builder", "Ljavax/xml/parsers/DocumentBuilder;", "kotlin.jvm.PlatformType", "getBuilder", "()Ljavax/xml/parsers/DocumentBuilder;", "builder$delegate", "Lkotlin/Lazy;", "getColors", "()Llt/neworld/vd2svg/resources/ResourceCollector;", "transformer", "Ljavax/xml/transform/Transformer;", "getTransformer", "()Ljavax/xml/transform/Transformer;", "transformer$delegate", "addElementToDefSection", "", "doc", "Lorg/w3c/dom/Document;", "element", "Lorg/w3c/dom/Element;", "clipPathCount", "", "convert", "input", "Ljava/io/InputStream;", "outputStream", "Ljava/io/OutputStream;", "convertAaptAttributesElement", "Lkotlin/Pair;", "", "convertClipPathElement", "convertGradientElement", "createClipPath", "androidClipPath", "id", "createDefSection", "createLinearGradient", "gradientElement", "createStopFromColorAndOffset", "colorString", "offsetPercent", "createStopFromGradientItem", "gradientItem", "fixEmptyNamespace", "node", "Lorg/w3c/dom/Node;", "linearGradientCount", "parseColor", "", "color", "parseColorHex", "colorHex", "parseFillRule", "currentRule", "removeBlankNodes", "appendAttribute", "name", "value", "delimiter", "appendChildNodes", "nodes", "", "fix", "fixFill", "fixRotate", "fixScale", "fixStroke", "fixTranslate", "removeAllChildNodes", "rename", "Lorg/w3c/dom/NamedNodeMap;", "nameSpaceUri", "old", "newNameSpaceUri", "new", "namespaceUri", "setId", "Companion", "vd2svg"})
public final class Converter {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy builder$delegate;
    private final Lazy transformer$delegate;
    @NotNull
    private final ResourceCollector colors;
    @NotNull
    public static final String ANDROID_NS = "http://schemas.android.com/apk/res/android";
    @NotNull
    public static final String AAPT_NS = "http://schemas.android.com/aapt";
    @NotNull
    public static final String SVG_NS = "http://www.w3.org/2000/svg";
    @NotNull
    public static final String DEFS_SECTION = "svg-definitions";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(Converter.class), "builder", "getBuilder()Ljavax/xml/parsers/DocumentBuilder;")), Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(Converter.class), "transformer", "getTransformer()Ljavax/xml/transform/Transformer;"))};
        Companion = new Companion(null);
    }

    private final DocumentBuilder getBuilder() {
        Lazy lazy = this.builder$delegate;
        Converter converter = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (DocumentBuilder)lazy.getValue();
    }

    private final Transformer getTransformer() {
        Lazy lazy = this.transformer$delegate;
        Converter converter = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (Transformer)lazy.getValue();
    }

    public final void convert(@NotNull InputStream input2, @NotNull OutputStream outputStream) {
        Document doc2;
        Intrinsics.checkParameterIsNotNull(input2, "input");
        Intrinsics.checkParameterIsNotNull(outputStream, "outputStream");
        Document document = doc2 = this.getBuilder().parse(input2);
        Intrinsics.checkExpressionValueIsNotNull(document, "doc");
        Element element = document.getDocumentElement();
        Intrinsics.checkExpressionValueIsNotNull(element, "doc.documentElement");
        if (Intrinsics.areEqual(element.getNodeName(), "vector") ^ true) {
            return;
        }
        this.convert(doc2);
        DOMSource source = new DOMSource(doc2);
        StreamResult result = new StreamResult(outputStream);
        this.getTransformer().transform(source, result);
    }

    /*
     * WARNING - void declaration
     */
    private final void convert(Document doc2) {
        Object clipPathId;
        Element parent;
        Node $i$f$forEach;
        Object it;
        Element element;
        void it2;
        Collection collection;
        Object object;
        Object item$iv$iv;
        Object $receiver$iv$iv;
        Element element2 = doc2.getDocumentElement();
        Object $receiver = element2;
        $receiver.removeAttributeNS(ANDROID_NS, "width");
        $receiver.removeAttributeNS(ANDROID_NS, "height");
        NamedNodeMap namedNodeMap = $receiver.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull(namedNodeMap, "attributes");
        this.rename(namedNodeMap, ANDROID_NS, "viewportHeight", SVG_NS, "height");
        NamedNodeMap namedNodeMap2 = $receiver.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull(namedNodeMap2, "attributes");
        this.rename(namedNodeMap2, ANDROID_NS, "viewportWidth", SVG_NS, "width");
        this.rename((Node)$receiver, "svg", SVG_NS);
        NodeList nodeList = doc2.getElementsByTagNameNS(null, "group");
        Intrinsics.checkExpressionValueIsNotNull(nodeList, "doc.getElementsByTagNameNS(null, \"group\")");
        Iterable $receiver$iv = NodeListIteratorKt.getIterable(nodeList);
        $receiver = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            object = (Node)item$iv$iv;
            collection = destination$iv$iv;
            void v3 = it2;
            if (v3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
            }
            element = (Element)v3;
            collection.add(element);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            it = (Element)element$iv;
            this.rename((Node)it, "g", null);
            this.fix((Element)it);
        }
        NodeList nodeList2 = doc2.getElementsByTagNameNS(null, "path");
        Intrinsics.checkExpressionValueIsNotNull(nodeList2, "doc.getElementsByTagNameNS(null, \"path\")");
        $receiver$iv = NodeListIteratorKt.getIterable(nodeList2);
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        it = $receiver$iv$iv.iterator();
        while (it.hasNext()) {
            item$iv$iv = it.next();
            $i$f$forEach = (Node)item$iv$iv;
            collection = destination$iv$iv;
            void v5 = it2;
            if (v5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
            }
            element = (Element)v5;
            collection.add(element);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            it = (Element)element$iv;
            NamedNodeMap namedNodeMap3 = it.getAttributes();
            Intrinsics.checkExpressionValueIsNotNull(namedNodeMap3, "it.attributes");
            this.rename(namedNodeMap3, ANDROID_NS, "pathData", SVG_NS, "d");
            NamedNodeMap namedNodeMap4 = it.getAttributes();
            Intrinsics.checkExpressionValueIsNotNull(namedNodeMap4, "it.attributes");
            this.rename(namedNodeMap4, ANDROID_NS, "fillType", SVG_NS, "fill-rule");
            this.fix((Element)it);
        }
        NodeList nodeList3 = doc2.getElementsByTagNameNS(null, "clip-path");
        Intrinsics.checkExpressionValueIsNotNull(nodeList3, "doc.getElementsByTagNameNS(null, \"clip-path\")");
        $receiver$iv = NodeListIteratorKt.getIterable(nodeList3);
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        it = $receiver$iv$iv.iterator();
        while (it.hasNext()) {
            item$iv$iv = it.next();
            $i$f$forEach = (Node)item$iv$iv;
            collection = destination$iv$iv;
            void v9 = it2;
            if (v9 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
            }
            element = (Element)v9;
            collection.add(element);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            it = (Element)element$iv;
            Node node = it.getParentNode();
            if (!(node instanceof Element)) {
                node = null;
            }
            parent = (Element)node;
            clipPathId = this.convertClipPathElement(doc2, (Element)it);
            Element element3 = parent;
            if (element3 != null) {
                element3.setAttribute("clip-path", "url(#" + (String)clipPathId + ')');
            }
            Element element4 = parent;
            if (element4 == null) continue;
            element4.removeChild((Node)it);
        }
        NodeList nodeList4 = doc2.getElementsByTagNameNS(AAPT_NS, "attr");
        Intrinsics.checkExpressionValueIsNotNull(nodeList4, "doc.getElementsByTagNameNS(AAPT_NS, \"attr\")");
        $receiver$iv = NodeListIteratorKt.getIterable(nodeList4);
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        it = $receiver$iv$iv.iterator();
        while (it.hasNext()) {
            item$iv$iv = it.next();
            clipPathId = (Node)item$iv$iv;
            collection = destination$iv$iv;
            void v14 = it2;
            if (v14 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
            }
            element = (Element)v14;
            collection.add(element);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            it = (Element)element$iv;
            Node node = it.getParentNode();
            if (!(node instanceof Element)) {
                node = null;
            }
            parent = (Element)node;
            try {
                object = this.convertAaptAttributesElement(doc2, (Element)it);
                String $i$a$8$map = (String)((Pair)object).component1();
                String defId = (String)((Pair)object).component2();
                Element element5 = parent;
                if (element5 != null) {
                    void attributeName;
                    element5.setAttribute((String)attributeName, "url(#" + defId + ')');
                }
            }
            catch (Exception e) {
                LoggerKt.logWarning("Error while processing aapt:attr element: " + e);
            }
            Element element6 = parent;
            if (element6 == null) continue;
            element6.removeChild((Node)it);
        }
        Element element7 = doc2.getDocumentElement();
        Intrinsics.checkExpressionValueIsNotNull(element7, "doc.documentElement");
        this.fixEmptyNamespace(element7);
        this.removeBlankNodes(doc2);
    }

    private final String convertClipPathElement(Document doc2, Element element) {
        int index = this.clipPathCount(doc2);
        String id = "_clippath_" + index;
        Element cp = this.createClipPath(doc2, element, id);
        this.addElementToDefSection(doc2, cp);
        return id;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<String, String> convertAaptAttributesElement(Document doc2, Element element) {
        void $receiver$iv$iv;
        Iterable<Node> $receiver$iv;
        String svgAttributeName;
        String name = element.getAttribute("name");
        if (Intrinsics.areEqual(name, "android:fillColor")) {
            svgAttributeName = "fill";
        } else if (Intrinsics.areEqual(name, "android:strokeColor")) {
            svgAttributeName = "stroke";
        } else {
            throw (Throwable)new Exception("Unsupported aapt:attr name: " + name);
        }
        NodeList nodeList = element.getChildNodes();
        Intrinsics.checkExpressionValueIsNotNull(nodeList, "element.childNodes");
        Iterable<Node> iterable2 = $receiver$iv = NodeListIteratorKt.getIterable(nodeList);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof Element)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Element firstChildElement = (Element)CollectionsKt.firstOrNull((List)destination$iv$iv);
        if (firstChildElement == null) {
            throw (Throwable)new Exception("Childless aapt:attr");
        }
        if (Intrinsics.areEqual(firstChildElement.getTagName(), "gradient")) {
            Element gradient = this.convertGradientElement(doc2, firstChildElement);
            this.addElementToDefSection(doc2, gradient);
            return new Pair<String, String>(svgAttributeName, this.id(gradient));
        }
        throw (Throwable)new Exception("Unsupported aapt:attr child element tag: " + firstChildElement.getTagName());
    }

    private final Element convertGradientElement(Document doc2, Element element) {
        String type = element.getAttributeNS(ANDROID_NS, "type");
        if (type.isEmpty()) {
            type = "linear";
        }
        if (Intrinsics.areEqual(type, "linear")) {
            int index = this.linearGradientCount(doc2);
            String id = "_linear_gradient_" + index;
            return this.createLinearGradient(doc2, element, id);
        }
        throw (Throwable)new Exception("Unsupported gradient android:type " + type);
    }

    private final int clipPathCount(Document doc2) {
        NodeList nodeList = doc2.getElementsByTagName("clipPath");
        Intrinsics.checkExpressionValueIsNotNull(nodeList, "doc.getElementsByTagName(\"clipPath\")");
        return nodeList.getLength();
    }

    private final int linearGradientCount(Document doc2) {
        NodeList nodeList = doc2.getElementsByTagName("linearGradient");
        Intrinsics.checkExpressionValueIsNotNull(nodeList, "doc.getElementsByTagName(\"linearGradient\")");
        return nodeList.getLength();
    }

    private final void addElementToDefSection(Document doc2, Element element) {
        Element element2 = doc2.getElementById(DEFS_SECTION);
        if (element2 == null) {
            element2 = this.createDefSection(doc2);
        }
        Element defSection = element2;
        defSection.appendChild(element);
    }

    private final Element createDefSection(Document doc2) {
        Element element;
        Element element2 = element = doc2.createElement("defs");
        Intrinsics.checkExpressionValueIsNotNull(element2, "element");
        this.setId(element2, DEFS_SECTION);
        doc2.getDocumentElement().appendChild(element);
        return element;
    }

    private final Element createClipPath(Document doc2, Element androidClipPath, String id) {
        Element clipPathElement;
        NamedNodeMap namedNodeMap = androidClipPath.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull(namedNodeMap, "androidClipPath.attributes");
        String pathData = NamedNodeMapKt.get(namedNodeMap, ANDROID_NS, "pathData");
        Element pathElement = doc2.createElement("path");
        pathElement.setAttribute("d", pathData);
        Element element = clipPathElement = doc2.createElement("clipPath");
        Intrinsics.checkExpressionValueIsNotNull(element, "clipPathElement");
        this.setId(element, id);
        clipPathElement.appendChild(pathElement);
        return clipPathElement;
    }

    /*
     * Unable to fully structure code
     */
    private final Element createLinearGradient(Document doc, Element gradientElement, String id) {
        block13: {
            v0 = element = doc.createElement("linearGradient");
            Intrinsics.checkExpressionValueIsNotNull(v0, "element");
            this.setId(v0, id);
            element.setAttribute("gradientUnits", "userSpaceOnUse");
            startX = gradientElement.getAttributeNS("http://schemas.android.com/apk/res/android", "startX");
            startY = gradientElement.getAttributeNS("http://schemas.android.com/apk/res/android", "startY");
            endX = gradientElement.getAttributeNS("http://schemas.android.com/apk/res/android", "endX");
            endY = gradientElement.getAttributeNS("http://schemas.android.com/apk/res/android", "endY");
            v1 = startX;
            Intrinsics.checkExpressionValueIsNotNull(v1, "startX");
            var9_9 = v1;
            if (var9_9.length() > 0) {
                v2 = startY;
                Intrinsics.checkExpressionValueIsNotNull(v2, "startY");
                var9_9 = v2;
                if (var9_9.length() > 0) {
                    element.setAttribute("x1", startX);
                    element.setAttribute("y1", startY);
                }
            }
            v3 = endX;
            Intrinsics.checkExpressionValueIsNotNull(v3, "endX");
            var9_9 = v3;
            if (var9_9.length() > 0) {
                v4 = endY;
                Intrinsics.checkExpressionValueIsNotNull(v4, "endY");
                var9_9 = v4;
                if (var9_9.length() > 0) {
                    element.setAttribute("x2", endX);
                    element.setAttribute("y2", endY);
                }
            }
            v5 = gradientElement.getAttributeNS("http://schemas.android.com/apk/res/android", "tileMode");
            Intrinsics.checkExpressionValueIsNotNull(v5, "gradientElement.getAttri\u2026S(ANDROID_NS, \"tileMode\")");
            v6 = var10_10 = v5;
            if (v6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            v7 = v6.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull(v7, "(this as java.lang.String).toLowerCase()");
            var10_10 = tileMode = v7;
            switch (var10_10.hashCode()) {
                case -1073910849: {
                    if (!var10_10.equals("mirror")) ** break;
                    break;
                }
                case -934531685: {
                    if (!var10_10.equals("repeat")) ** break;
                    break block13;
                }
                case 94742715: {
                    if (!var10_10.equals("clamp")) ** break;
                    element.setAttribute("spreadMethod", "pad");
                    ** break;
                }
            }
            element.setAttribute("spreadMethod", "reflect");
            ** break;
        }
        element.setAttribute("spreadMethod", "repeat");
lbl52:
        // 7 sources

        startColor = gradientElement.getAttributeNS("http://schemas.android.com/apk/res/android", "startColor");
        endColor = gradientElement.getAttributeNS("http://schemas.android.com/apk/res/android", "endColor");
        centerColor = gradientElement.getAttributeNS("http://schemas.android.com/apk/res/android", "centerColor");
        v8 = startColor;
        Intrinsics.checkExpressionValueIsNotNull(v8, "startColor");
        var14_13 = v8;
        if (!(var14_13.length() > 0)) ** GOTO lbl-1000
        v9 = endColor;
        Intrinsics.checkExpressionValueIsNotNull(v9, "endColor");
        var14_13 = v9;
        if (var14_13.length() > 0) {
            v10 = centerColor;
            Intrinsics.checkExpressionValueIsNotNull(v10, "centerColor");
            var14_13 = v10;
            stops = var14_13.length() > 0 ? CollectionsKt.listOf(new Element[]{this.createStopFromColorAndOffset(doc, startColor, "0%"), this.createStopFromColorAndOffset(doc, centerColor, "50%"), this.createStopFromColorAndOffset(doc, endColor, "100%")}) : CollectionsKt.listOf(new Element[]{this.createStopFromColorAndOffset(doc, startColor, "0%"), this.createStopFromColorAndOffset(doc, endColor, "100%")});
        } else lbl-1000:
        // 2 sources

        {
            v11 = gradientElement.getChildNodes();
            Intrinsics.checkExpressionValueIsNotNull(v11, "gradientElement.childNodes");
            var15_15 = $receiver$iv = NodeListIteratorKt.getIterable(v11);
            destination$iv$iv = new ArrayList<E>();
            $receiver$iv$iv$iv = $receiver$iv$iv;
            for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                element$iv$iv = element$iv$iv$iv;
                it = (Node)element$iv$iv;
                v12 = it instanceof Element != false ? this.createStopFromGradientItem(doc, (Element)it) : null;
                if (v12 == null) continue;
                it$iv$iv = var23_22 = v12;
                destination$iv$iv.add(it$iv$iv);
            }
            stops = (List<Element>)destination$iv$iv;
        }
        this.removeAllChildNodes(element);
        this.appendChildNodes(element, (List<? extends Node>)stops);
        return element;
    }

    /*
     * WARNING - void declaration
     */
    private final Element createStopFromColorAndOffset(Document doc2, String colorString, String offsetPercent) {
        void color;
        Pair<String, Float> pair = this.parseColor(colorString);
        String string = pair.component1();
        Float opacity = pair.component2();
        Element stopElement = doc2.createElement("stop");
        stopElement.setAttribute("offset", offsetPercent);
        stopElement.setAttribute("stop-color", (String)color);
        if (opacity != null) {
            stopElement.setAttribute("stop-opacity", String.valueOf(opacity.floatValue()));
        }
        Element element = stopElement;
        Intrinsics.checkExpressionValueIsNotNull(element, "stopElement");
        return element;
    }

    /*
     * WARNING - void declaration
     */
    private final Element createStopFromGradientItem(Document doc2, Element gradientItem) {
        void color;
        if (Intrinsics.areEqual(gradientItem.getTagName(), "item") ^ true) {
            return null;
        }
        String string = gradientItem.getAttributeNS(ANDROID_NS, "color");
        if (string == null) {
            return null;
        }
        String colorStr = string;
        String string2 = gradientItem.getAttributeNS(ANDROID_NS, "offset");
        if (string2 == null) {
            return null;
        }
        String offset = string2;
        Pair<String, Float> pair = this.parseColor(colorStr);
        String string3 = pair.component1();
        Float opacity = pair.component2();
        Element stopElement = doc2.createElement("stop");
        stopElement.setAttribute("offset", offset);
        stopElement.setAttribute("stop-color", (String)color);
        if (opacity != null) {
            stopElement.setAttribute("stop-opacity", String.valueOf(opacity.floatValue()));
        }
        return stopElement;
    }

    private final Pair<String, Float> parseColor(String color) {
        String colorHex = color;
        if (StringsKt.startsWith$default(color, "@", false, 2, null)) {
            String name = (String)CollectionsKt.last(StringsKt.split$default((CharSequence)color, new String[]{"/"}, false, 0, 6, null));
            String resourceHex = this.colors.getValue(name);
            if (resourceHex == null) {
                throw (Throwable)new IllegalArgumentException("Color " + name + " does not exists");
            }
            colorHex = resourceHex;
        }
        return this.parseColorHex(colorHex);
    }

    private final String parseFillRule(String currentRule) {
        String string;
        switch (currentRule) {
            case "evenOdd": {
                string = "evenodd";
                break;
            }
            case "nonZero": {
                string = "nonzero";
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unknown fill rule " + currentRule);
            }
        }
        return string;
    }

    private final Pair<String, Float> parseColorHex(String colorHex) {
        String color = colorHex.length() < 6 ? StringsKt.takeLast(colorHex, 3) : StringsKt.takeLast(colorHex, 6);
        Float opacity = null;
        if (colorHex.length() == 9) {
            String string = StringsKt.take(StringsKt.drop(colorHex, 1), 2);
            int n = 16;
            opacity = Float.valueOf((float)Integer.parseInt(string, CharsKt.checkRadix(n)) / 255.0f);
        }
        return new Pair<String, Float>('#' + color, opacity);
    }

    private final void removeBlankNodes(Document doc2) {
        doc2.getDocumentElement().normalize();
        XPathExpression xPathExpression = XPathFactory.newInstance().newXPath().compile("//text()[normalize-space(.) = '']");
        Intrinsics.checkExpressionValueIsNotNull(xPathExpression, "XPathFactory.newInstance\u2026ormalize-space(.) = '']\")");
        XPathExpression xpath = xPathExpression;
        Object object = xpath.evaluate(doc2, XPathConstants.NODESET);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.NodeList");
        }
        NodeList blankTextNodes = (NodeList)object;
        Iterable<Node> $receiver$iv = NodeListIteratorKt.getIterable(blankTextNodes);
        Iterator<Node> iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Node element$iv;
            Node it = element$iv = iterator2.next();
            it.getParentNode().removeChild(it);
        }
    }

    private final void fixEmptyNamespace(Node node) {
        NodeList nodeList = node.getChildNodes();
        Intrinsics.checkExpressionValueIsNotNull(nodeList, "node.childNodes");
        Iterable<Node> $receiver$iv = NodeListIteratorKt.getIterable(nodeList);
        for (Node element$iv : $receiver$iv) {
            Node it = element$iv;
            if (!(it instanceof Element)) continue;
            String string = ((Element)it).getTagName();
            Intrinsics.checkExpressionValueIsNotNull(string, "it.tagName");
            this.rename(it, string, SVG_NS);
            this.fixEmptyNamespace(it);
        }
    }

    private final void fix(@NotNull Element $receiver) {
        this.fixTranslate($receiver);
        this.fixFill($receiver);
        this.fixRotate($receiver);
        this.fixScale($receiver);
        this.fixStroke($receiver);
    }

    private final void fixStroke(@NotNull Element $receiver) {
        NamedNodeMap namedNodeMap = $receiver.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull(namedNodeMap, "attributes");
        String strokeColor = NamedNodeMapKt.get(namedNodeMap, ANDROID_NS, "strokeColor");
        NamedNodeMap namedNodeMap2 = $receiver.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull(namedNodeMap2, "attributes");
        String strokeWidth = NamedNodeMapKt.get(namedNodeMap2, ANDROID_NS, "strokeWidth");
        NamedNodeMap namedNodeMap3 = $receiver.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull(namedNodeMap3, "attributes");
        String strokeOpacity = NamedNodeMapKt.get(namedNodeMap3, ANDROID_NS, "strokeAlpha");
        NamedNodeMap namedNodeMap4 = $receiver.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull(namedNodeMap4, "attributes");
        String strokeLineCap = NamedNodeMapKt.get(namedNodeMap4, ANDROID_NS, "strokeLineCap");
        NamedNodeMap namedNodeMap5 = $receiver.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull(namedNodeMap5, "attributes");
        String strokeLineJoin = NamedNodeMapKt.get(namedNodeMap5, ANDROID_NS, "strokeLineJoin");
        if (strokeColor != null) {
            Pair<String, Float> pair = this.parseColor(strokeColor);
            String strokeColorHex = pair.component1();
            $receiver.setAttribute("stroke", strokeColorHex);
        }
        if (strokeWidth != null) {
            $receiver.setAttribute("stroke-width", strokeWidth);
        }
        if (strokeOpacity != null) {
            $receiver.setAttribute("stroke-opacity", strokeOpacity);
        }
        if (strokeLineCap != null) {
            $receiver.setAttribute("stroke-linecap", strokeLineCap);
        }
        if (strokeLineJoin != null) {
            $receiver.setAttribute("stroke-linejoin", strokeLineJoin);
        }
        $receiver.removeAttributeNS(ANDROID_NS, "strokeColor");
        $receiver.removeAttributeNS(ANDROID_NS, "strokeWidth");
        $receiver.removeAttributeNS(ANDROID_NS, "strokeAlpha");
        $receiver.removeAttributeNS(ANDROID_NS, "strokeLineCap");
        $receiver.removeAttributeNS(ANDROID_NS, "strokeLineJoin");
    }

    private final void fixTranslate(@NotNull Element $receiver) {
        block2: {
            String string;
            block4: {
                String translateX;
                block3: {
                    String string2;
                    NamedNodeMap namedNodeMap = $receiver.getAttributes();
                    Intrinsics.checkExpressionValueIsNotNull(namedNodeMap, "attributes");
                    translateX = NamedNodeMapKt.get(namedNodeMap, ANDROID_NS, "translateX");
                    NamedNodeMap namedNodeMap2 = $receiver.getAttributes();
                    Intrinsics.checkExpressionValueIsNotNull(namedNodeMap2, "attributes");
                    String translateY = NamedNodeMapKt.get(namedNodeMap2, ANDROID_NS, "translateY");
                    if (translateX == null) break block2;
                    string = translateY;
                    if (string == null) break block3;
                    String y = string2 = string;
                    string = "translate(" + translateX + ", " + y + ')';
                    if (string != null) break block4;
                }
                string = "translate(" + translateX + ')';
            }
            String translate = string;
            Converter.appendAttribute$default(this, $receiver, "transform", translate, null, 4, null);
        }
        $receiver.removeAttributeNS(ANDROID_NS, "translateX");
        $receiver.removeAttributeNS(ANDROID_NS, "translateY");
    }

    private final void fixScale(@NotNull Element $receiver) {
        NamedNodeMap namedNodeMap = $receiver.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull(namedNodeMap, "attributes");
        String scaleX = NamedNodeMapKt.get(namedNodeMap, ANDROID_NS, "scaleX");
        NamedNodeMap namedNodeMap2 = $receiver.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull(namedNodeMap2, "attributes");
        String scaleY = NamedNodeMapKt.get(namedNodeMap2, ANDROID_NS, "scaleY");
        if (scaleX != null || scaleY != null) {
            String string;
            String scaleX2;
            String string2 = scaleX;
            if (string2 == null) {
                string2 = scaleX2 = "1";
            }
            if ((string = scaleY) == null) {
                string = "1";
            }
            String scaleY2 = string;
            Converter.appendAttribute$default(this, $receiver, "transform", "scale(" + scaleX2 + ", " + scaleY2 + ')', null, 4, null);
        }
        $receiver.removeAttributeNS(ANDROID_NS, "scaleX");
        $receiver.removeAttributeNS(ANDROID_NS, "scaleY");
    }

    /*
     * WARNING - void declaration
     */
    private final void fixFill(@NotNull Element $receiver) {
        float fillAlpha;
        NamedNodeMap namedNodeMap = $receiver.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull(namedNodeMap, "attributes");
        String fillColorName = NamedNodeMapKt.get(namedNodeMap, ANDROID_NS, "fillColor");
        Node fillRuleAttr = $receiver.getAttributes().getNamedItem("fill-rule");
        String fillColorHex = null;
        NamedNodeMap namedNodeMap2 = $receiver.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull(namedNodeMap2, "attributes");
        Object object = NamedNodeMapKt.get(namedNodeMap2, ANDROID_NS, "fillAlpha");
        float f = object != null && (object = StringsKt.toFloatOrNull((String)object)) != null ? ((Float)object).floatValue() : (fillAlpha = 1.0f);
        if (fillColorName != null) {
            void colorHex;
            Pair<String, Float> pair = this.parseColor(fillColorName);
            String string = pair.component1();
            Float androidAlpha = pair.component2();
            if (androidAlpha != null) {
                fillAlpha *= androidAlpha.floatValue();
            }
            fillColorHex = colorHex;
        }
        if (fillRuleAttr != null) {
            String string = fillRuleAttr.getNodeValue();
            Intrinsics.checkExpressionValueIsNotNull(string, "fillRuleAttr.nodeValue");
            $receiver.setAttribute("fill-rule", this.parseFillRule(string));
        }
        if (fillAlpha != 1.0f) {
            $receiver.setAttribute("fill-opacity", String.valueOf(fillAlpha));
        }
        if (fillColorHex != null) {
            $receiver.setAttribute("fill", fillColorHex);
        }
        $receiver.removeAttributeNS(ANDROID_NS, "fillColor");
        $receiver.removeAttributeNS(ANDROID_NS, "fillAlpha");
    }

    private final void fixRotate(@NotNull Element $receiver) {
        NamedNodeMap namedNodeMap = $receiver.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull(namedNodeMap, "attributes");
        String pivotX = NamedNodeMapKt.get(namedNodeMap, ANDROID_NS, "pivotX");
        NamedNodeMap namedNodeMap2 = $receiver.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull(namedNodeMap2, "attributes");
        String pivotY = NamedNodeMapKt.get(namedNodeMap2, ANDROID_NS, "pivotY");
        NamedNodeMap namedNodeMap3 = $receiver.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull(namedNodeMap3, "attributes");
        String rotation = NamedNodeMapKt.get(namedNodeMap3, ANDROID_NS, "rotation");
        if (rotation == null) {
            return;
        }
        if (pivotX != null || pivotY != null) {
            StringBuilder stringBuilder = new StringBuilder().append("rotation(").append(rotation).append(", ");
            String string = pivotX;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            StringBuilder stringBuilder2 = stringBuilder.append(string).append(' ');
            String string2 = pivotY;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            Converter.appendAttribute$default(this, $receiver, "transform", stringBuilder2.append(string2).append(')').toString(), null, 4, null);
        } else {
            Converter.appendAttribute$default(this, $receiver, "transform", "rotation(" + rotation + ')', null, 4, null);
        }
        $receiver.removeAttributeNS(ANDROID_NS, "pivotX");
        $receiver.removeAttributeNS(ANDROID_NS, "pivotY");
        $receiver.removeAttributeNS(ANDROID_NS, "rotation");
    }

    private final void appendAttribute(@NotNull Element $receiver, String name, String value, String delimiter) {
        NamedNodeMap namedNodeMap = $receiver.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull(namedNodeMap, "attributes");
        String current = NamedNodeMapKt.get(namedNodeMap, null, name);
        if (current == null) {
            $receiver.setAttribute(name, value);
        } else {
            $receiver.setAttribute(name, current + delimiter + value);
        }
    }

    static /* bridge */ /* synthetic */ void appendAttribute$default(Converter converter, Element element, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = " ";
        }
        converter.appendAttribute(element, string, string2, string3);
    }

    private final void appendChildNodes(@NotNull Element $receiver, List<? extends Node> nodes) {
        Iterable $receiver$iv = nodes;
        for (Object element$iv : $receiver$iv) {
            Node it = (Node)element$iv;
            $receiver.appendChild(it);
        }
    }

    private final void removeAllChildNodes(@NotNull Element $receiver) {
        NodeList nodeList = $receiver.getChildNodes();
        Intrinsics.checkExpressionValueIsNotNull(nodeList, "childNodes");
        Iterable<Node> $receiver$iv = NodeListIteratorKt.getIterable(nodeList);
        Iterator<Node> iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Node element$iv;
            Node it = element$iv = iterator2.next();
            $receiver.removeChild(it);
        }
    }

    private final String id(@NotNull Element $receiver) {
        String string = $receiver.getAttribute("id");
        Intrinsics.checkExpressionValueIsNotNull(string, "getAttribute(\"id\")");
        return string;
    }

    private final void setId(@NotNull Element $receiver, String id) {
        $receiver.setAttribute("id", id);
        $receiver.setIdAttribute("id", true);
    }

    private final void rename(@NotNull NamedNodeMap $receiver, String nameSpaceUri, String old, String newNameSpaceUri, String string) {
        Element element;
        Attr attr = (Attr)$receiver.getNamedItemNS(nameSpaceUri, old);
        if (attr == null) {
            return;
        }
        Attr node = attr;
        Element $receiver2 = element = node.getOwnerElement();
        $receiver2.removeAttributeNS(nameSpaceUri, old);
        $receiver2.setAttribute(string, node.getValue());
    }

    private final void rename(@NotNull Node $receiver, String string, String namespaceUri) {
        $receiver.getOwnerDocument().renameNode($receiver, namespaceUri, string);
    }

    @NotNull
    public final ResourceCollector getColors() {
        return this.colors;
    }

    public Converter(@NotNull ResourceCollector colors) {
        Intrinsics.checkParameterIsNotNull(colors, "colors");
        this.colors = colors;
        this.builder$delegate = LazyKt.lazy(builder.2.INSTANCE);
        this.transformer$delegate = LazyKt.lazy(transformer.2.INSTANCE);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Llt/neworld/vd2svg/converter/Converter$Companion;", "", "()V", "AAPT_NS", "", "ANDROID_NS", "DEFS_SECTION", "SVG_NS", "vd2svg"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

