/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.io.ApkSerializer;
import com.android.tools.build.bundletool.io.ModuleSplitSerializer;
import com.android.tools.build.bundletool.optimizations.ApkOptimizations;
import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.inject.Qualifier;

@Module
public abstract class ApkSerializerModule {
    @Binds
    abstract ApkSerializer provideApkSerializer(ModuleSplitSerializer var1);

    @Provides
    @NativeLibrariesAlignmentInBytes
    static int provideNativeLibrariesAlignmentInBytes(ApkOptimizations apkOptimizations) {
        switch (apkOptimizations.getPageAlignment()) {
            case PAGE_ALIGNMENT_16K: {
                return 16384;
            }
            case PAGE_ALIGNMENT_64K: {
                return 65536;
            }
            case PAGE_ALIGNMENT_UNSPECIFIED: 
            case PAGE_ALIGNMENT_4K: 
            case UNRECOGNIZED: {
                return 4096;
            }
        }
        throw new IllegalArgumentException("Wrong native libraries alignment.");
    }

    private ApkSerializerModule() {
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface NativeLibrariesAlignmentInBytes {
    }
}

