/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.io.ZipBuilder;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.SdkBundle;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.io.ByteSource;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;

public class SdkBundleSerializer {
    public void writeToDisk(SdkBundle sdkBundle, Path pathOnDisk) throws IOException {
        ZipBuilder zipBuilder = new ZipBuilder();
        for (Map.Entry metadataEntry : sdkBundle.getBundleMetadata().getFileContentMap().entrySet()) {
            zipBuilder.addFile(AppBundle.METADATA_DIRECTORY.resolve((ZipPath)metadataEntry.getKey()), (ByteSource)metadataEntry.getValue(), new ZipBuilder.EntryOption[0]);
        }
        zipBuilder.addFileWithProtoContent(ZipPath.create("SdkBundleConfig.pb"), sdkBundle.getSdkBundleConfig(), new ZipBuilder.EntryOption[0]);
        try (TempDirectory tempDir = new TempDirectory(this.getClass().getSimpleName());){
            Path modulesPath = tempDir.getPath().resolve("extracted-modules.resm");
            this.getModulesBuilder(sdkBundle).writeTo(modulesPath);
            zipBuilder.addFileFromDisk(ZipPath.create("modules.resm"), modulesPath.toFile(), new ZipBuilder.EntryOption[0]);
            zipBuilder.writeTo(pathOnDisk);
        }
    }

    private ZipBuilder getModulesBuilder(SdkBundle sdkBundle) {
        ZipBuilder modulesBuilder = new ZipBuilder();
        modulesBuilder.addFileWithProtoContent(ZipPath.create("SdkModulesConfig.pb"), sdkBundle.getSdkModulesConfig(), new ZipBuilder.EntryOption[0]);
        BundleModule module = sdkBundle.getModule();
        ZipPath moduleDir = ZipPath.create(module.getName().toString());
        for (ModuleEntry entry : module.getEntries()) {
            ZipPath entryPath = moduleDir.resolve(entry.getPath());
            modulesBuilder.addFile(entryPath, entry.getContent(), new ZipBuilder.EntryOption[0]);
        }
        modulesBuilder.addFileWithProtoContent(moduleDir.resolve(BundleModule.SpecialModuleEntry.ANDROID_MANIFEST.getPath()), module.getAndroidManifest().getManifestRoot().getProto(), new ZipBuilder.EntryOption[0]);
        module.getAssetsConfig().ifPresent(assetsConfig -> modulesBuilder.addFileWithProtoContent(moduleDir.resolve(BundleModule.SpecialModuleEntry.ASSETS_TABLE.getPath()), (MessageLite)assetsConfig, new ZipBuilder.EntryOption[0]));
        module.getNativeConfig().ifPresent(nativeConfig -> modulesBuilder.addFileWithProtoContent(moduleDir.resolve(BundleModule.SpecialModuleEntry.NATIVE_LIBS_TABLE.getPath()), (MessageLite)nativeConfig, new ZipBuilder.EntryOption[0]));
        module.getResourceTable().ifPresent(resourceTable -> modulesBuilder.addFileWithProtoContent(moduleDir.resolve(BundleModule.SpecialModuleEntry.RESOURCE_TABLE.getPath()), (MessageLite)resourceTable, new ZipBuilder.EntryOption[0]));
        return modulesBuilder;
    }
}

