/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.ApkDecoder;
import brut.androlib.Config;
import brut.androlib.apk.ApkInfo;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.Framework;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.decoder.ARSCDecoder;
import brut.directory.AbstractDirectory;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.logging.Logger;

public final class ResTable {
    public static final Logger LOGGER = Logger.getLogger(ApkDecoder.class.getName());
    public final Config mConfig;
    public final ApkInfo mApkInfo;
    public final HashMap mPackagesById;
    public final HashMap mPackagesByName;
    public final LinkedHashSet mMainPackages;
    public final LinkedHashSet mFramePackages;
    public String mPackageRenamed;
    public String mPackageOriginal;
    public int mPackageId;
    public boolean mMainPkgLoaded;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final ResPackage[] loadResPackagesFromApk(ExtFile extFile, boolean bl) {
        ResPackage[] resPackageArray;
        BufferedInputStream bufferedInputStream;
        ResTable resTable = abstractDirectory;
        AbstractDirectory abstractDirectory = extFile.getDirectory();
        BufferedInputStream bufferedInputStream2 = bufferedInputStream;
        bufferedInputStream = new BufferedInputStream(abstractDirectory.getFileInput("resources.arsc"));
        try {
            resPackageArray = ARSCDecoder.decode((ResTable)resTable, (InputStream)bufferedInputStream, (boolean)false, (boolean)bl).mPackages;
        }
        catch (Throwable throwable) {
            try {
                bufferedInputStream2.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                void var0_4;
                try {
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new AndrolibException("Could not load resources.arsc from file: " + extFile, (Exception)var0_4);
                }
                catch (DirectoryException directoryException) {
                    throw new AndrolibException("Could not load resources.arsc from file: " + extFile, (Exception)var0_4);
                }
            }
        }
        bufferedInputStream2.close();
        return resPackageArray;
    }

    public final ResResSpec getResSpec(int n) {
        ResID resID;
        ResResSpec resResSpec;
        if (n >> 24 == 0) {
            int n2 = ((ResTable)this).mPackageId;
            if (n2 == 0) {
                n2 = 2;
            }
            n = n2 << 24 & 0xFF000000 | n;
        }
        if ((resResSpec = (ResResSpec)((ResTable)this).getPackage((int)new ResID((int)n).pkgId).mResSpecs.get(this = resID)) != null) {
            return resResSpec;
        }
        throw new UndefinedResObjectException("resource spec: ".concat(((ResID)this).toString()));
    }

    public final ResPackage getPackage(int n) {
        block7: {
            Object object;
            block6: {
                block5: {
                    Framework framework;
                    object = (ResPackage)this.mPackagesById.get(n);
                    if (object != null) {
                        return object;
                    }
                    object = framework;
                    Config config = this.mConfig;
                    object(config);
                    object = framework.getFrameworkApk(n, config.frameworkTag);
                    LOGGER.info("Loading resource table from file: " + object);
                    object = this.loadResPackagesFromApk(new ExtFile((File)object), true);
                    if (((ResPackage[])object).length <= 1) break block5;
                    object = ResTable.selectPkgWithMostResSpecs(object);
                    break block6;
                }
                if (((ResPackage[])object).length == 0) break block7;
                object = object[0];
            }
            if (object.mId == n) {
                this.addPackage((ResPackage)object, false);
                return object;
            }
            throw new AndrolibException("Expected pkg of id: " + n + ", got: " + object.mId);
        }
        throw new AndrolibException("Arsc files with zero or multiple packages");
    }

    public final ResPackage getCurrentResPackage() {
        ResPackage resPackage = (ResPackage)this.mPackagesById.get(this.mPackageId);
        if (resPackage != null) {
            return resPackage;
        }
        if (this.mMainPackages.size() == 1) {
            return (ResPackage)this.mMainPackages.iterator().next();
        }
        int n = 0;
        int n2 = 0;
        for (ResPackage resPackage2 : this.mPackagesById.values()) {
            if (resPackage2.mResSpecs.size() <= n2 || resPackage2.mName.equalsIgnoreCase("android")) continue;
            ResPackage resPackage3 = resPackage2;
            n = resPackage3.mResSpecs.size();
            int n3 = n2 = resPackage3.mId;
            n2 = n;
            n = n3;
        }
        return n == 0 ? this.getPackage(1) : this.getPackage(n);
    }

    public final void addPackage(ResPackage resPackage, boolean bl) {
        Integer n = resPackage.mId;
        if (!this.mPackagesById.containsKey(n)) {
            String string = resPackage.mName;
            if (!this.mPackagesByName.containsKey(string)) {
                ResTable resTable = this;
                resTable.mPackagesById.put(n, resPackage);
                resTable.mPackagesByName.put(string, resPackage);
                if (bl) {
                    this.mMainPackages.add(resPackage);
                } else {
                    this.mFramePackages.add(resPackage);
                }
                return;
            }
            throw new AndrolibException("Multiple packages: name=" + string);
        }
        throw new AndrolibException("Multiple packages: id=" + n);
    }

    public ResTable(Config config, ApkInfo apkInfo) {
        LinkedHashSet linkedHashSet;
        LinkedHashSet linkedHashSet2;
        HashMap hashMap;
        HashMap hashMap2;
        Object object = hashMap2;
        hashMap2 = new HashMap();
        v1.mPackagesById = object;
        object = hashMap;
        hashMap = new HashMap();
        v1.mPackagesByName = object;
        object = linkedHashSet2;
        linkedHashSet2 = new LinkedHashSet();
        v1.mMainPackages = object;
        object = linkedHashSet;
        linkedHashSet = new LinkedHashSet();
        v1.mFramePackages = object;
        v1.mMainPkgLoaded = false;
        v1.mConfig = config;
        v1.mApkInfo = apkInfo;
    }

    public static ResPackage selectPkgWithMostResSpecs(ResPackage[] resPackageArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < resPackageArray.length; ++i) {
            ResPackage resPackage = resPackageArray[i];
            if (resPackage.mResSpecs.size() <= n2 || resPackage.mName.equalsIgnoreCase("android")) continue;
            ResPackage resPackage2 = resPackage;
            n = resPackage2.mResSpecs.size();
            int n4 = n2 = resPackage2.mId;
            n3 = i;
            n2 = n;
            n = n4;
        }
        return n == 0 ? resPackageArray[0] : resPackageArray[n3];
    }
}

