/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.value.ResBoolValue;
import brut.androlib.res.data.value.ResColorValue;
import brut.androlib.res.data.value.ResDimenValue;
import brut.androlib.res.data.value.ResEmptyValue;
import brut.androlib.res.data.value.ResFloatValue;
import brut.androlib.res.data.value.ResFractionValue;
import brut.androlib.res.data.value.ResIntValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.data.value.ResStringValue;

public final class ResValueFactory {
    public final ResPackage mPackage;

    public ResValueFactory(ResPackage resPackage) {
        this.mPackage = resPackage;
    }

    public final ResScalarValue factory(String string, int n, int n2) {
        if (n != 18) {
            switch (n) {
                default: {
                    if (n >= 28 && n <= 31) {
                        return new ResColorValue(n2, string);
                    }
                    if (n >= 16 && n <= 31) {
                        return new ResIntValue(string, n2, n);
                    }
                    throw new AndrolibException("Invalid value type: " + n);
                }
                case 7: {
                    n = 0;
                    return new ResReferenceValue(((ResValueFactory)this).mPackage, n2, string, n != 0);
                }
                case 6: {
                    return new ResFractionValue(n2, string);
                }
                case 5: {
                    return new ResDimenValue(n2, string);
                }
                case 4: {
                    return new ResFloatValue(Float.intBitsToFloat(n2), n2, string);
                }
                case 3: {
                    return new ResStringValue(n2, string);
                }
                case 2: 
                case 8: {
                    n = 1;
                    return new ResReferenceValue(((ResValueFactory)this).mPackage, n2, string, n != 0);
                }
                case 1: {
                    string = null;
                    n = 0;
                    return new ResReferenceValue(((ResValueFactory)this).mPackage, n2, string, n != 0);
                }
                case 0: 
            }
            if (n2 == 1) {
                return new ResEmptyValue(n2, string);
            }
            return new ResReferenceValue(((ResValueFactory)this).mPackage, null);
        }
        n = n2 != 0 ? 1 : 0;
        Object object = this;
        ((ResBoolValue)object)(n2, string, n != 0);
        return object;
    }
}

