/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.builder;

import com.android.tools.smali.dexlib2.builder.BuilderDebugItem;
import com.android.tools.smali.dexlib2.builder.BuilderInstruction;
import com.android.tools.smali.dexlib2.builder.Label;
import com.android.tools.smali.dexlib2.builder.LocatedDebugItems;
import com.android.tools.smali.dexlib2.builder.LocatedItems;
import com.android.tools.smali.dexlib2.builder.LocatedLabels;
import com.android.tools.smali.dexlib2.builder.debug.BuilderEndLocal;
import com.android.tools.smali.dexlib2.builder.debug.BuilderEpilogueBegin;
import com.android.tools.smali.dexlib2.builder.debug.BuilderLineNumber;
import com.android.tools.smali.dexlib2.builder.debug.BuilderPrologueEnd;
import com.android.tools.smali.dexlib2.builder.debug.BuilderRestartLocal;
import com.android.tools.smali.dexlib2.builder.debug.BuilderSetSourceFile;
import com.android.tools.smali.dexlib2.builder.debug.BuilderStartLocal;
import com.android.tools.smali.dexlib2.iface.instruction.Instruction;
import com.android.tools.smali.dexlib2.iface.reference.StringReference;
import com.android.tools.smali.dexlib2.iface.reference.TypeReference;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MethodLocation {
    @Nullable
    BuilderInstruction instruction;
    int codeAddress;
    int index;
    private final LocatedItems<Label> labels;
    private final LocatedItems<BuilderDebugItem> debugItems = new LocatedDebugItems();

    MethodLocation(@Nullable BuilderInstruction instruction, int codeAddress, int index) {
        this.labels = new LocatedLabels();
        this.instruction = instruction;
        this.codeAddress = codeAddress;
        this.index = index;
    }

    @Nullable
    public Instruction getInstruction() {
        return this.instruction;
    }

    public int getCodeAddress() {
        return this.codeAddress;
    }

    public int getIndex() {
        return this.index;
    }

    void mergeInto(@Nonnull MethodLocation nextLocation) {
        this.labels.mergeItemsIntoNext(nextLocation, nextLocation.labels);
        this.debugItems.mergeItemsIntoNext(nextLocation, nextLocation.debugItems);
    }

    @Nonnull
    public Set<Label> getLabels() {
        return this.labels.getModifiableItems(this);
    }

    @Nonnull
    public Label addNewLabel() {
        Label newLabel = new Label();
        this.getLabels().add(newLabel);
        return newLabel;
    }

    @Nonnull
    public Set<BuilderDebugItem> getDebugItems() {
        return this.debugItems.getModifiableItems(this);
    }

    public void addLineNumber(int lineNumber) {
        this.getDebugItems().add(new BuilderLineNumber(lineNumber));
    }

    public void addStartLocal(int registerNumber, @Nullable StringReference name, @Nullable TypeReference type, @Nullable StringReference signature) {
        this.getDebugItems().add(new BuilderStartLocal(registerNumber, name, type, signature));
    }

    public void addEndLocal(int registerNumber) {
        this.getDebugItems().add(new BuilderEndLocal(registerNumber));
    }

    public void addRestartLocal(int registerNumber) {
        this.getDebugItems().add(new BuilderRestartLocal(registerNumber));
    }

    public void addPrologue() {
        this.getDebugItems().add(new BuilderPrologueEnd());
    }

    public void addEpilogue() {
        this.getDebugItems().add(new BuilderEpilogueBegin());
    }

    public void addSetSourceFile(@Nullable StringReference sourceFile) {
        this.getDebugItems().add(new BuilderSetSourceFile(sourceFile));
    }
}

