/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.common.math.ElementTypesAreNonnullByDefault;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigInteger;
import java.math.RoundingMode;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class MathPreconditions {
    @CanIgnoreReturnValue
    static int checkPositive(String role, int x11) {
        if (x11 <= 0) {
            throw new IllegalArgumentException(role + " (" + x11 + ") must be > 0");
        }
        return x11;
    }

    @CanIgnoreReturnValue
    static long checkPositive(String role, long x11) {
        if (x11 <= 0L) {
            throw new IllegalArgumentException(role + " (" + x11 + ") must be > 0");
        }
        return x11;
    }

    @CanIgnoreReturnValue
    static BigInteger checkPositive(String role, BigInteger x11) {
        if (x11.signum() <= 0) {
            throw new IllegalArgumentException(role + " (" + x11 + ") must be > 0");
        }
        return x11;
    }

    @CanIgnoreReturnValue
    static int checkNonNegative(String role, int x11) {
        if (x11 < 0) {
            throw new IllegalArgumentException(role + " (" + x11 + ") must be >= 0");
        }
        return x11;
    }

    @CanIgnoreReturnValue
    static long checkNonNegative(String role, long x11) {
        if (x11 < 0L) {
            throw new IllegalArgumentException(role + " (" + x11 + ") must be >= 0");
        }
        return x11;
    }

    @CanIgnoreReturnValue
    static BigInteger checkNonNegative(String role, BigInteger x11) {
        if (x11.signum() < 0) {
            throw new IllegalArgumentException(role + " (" + x11 + ") must be >= 0");
        }
        return x11;
    }

    @CanIgnoreReturnValue
    static double checkNonNegative(String role, double x11) {
        if (!(x11 >= 0.0)) {
            throw new IllegalArgumentException(role + " (" + x11 + ") must be >= 0");
        }
        return x11;
    }

    static void checkRoundingUnnecessary(boolean condition2) {
        if (!condition2) {
            throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
        }
    }

    static void checkInRangeForRoundingInputs(boolean condition2, double input, RoundingMode mode) {
        if (!condition2) {
            throw new ArithmeticException("rounded value is out of range for input " + input + " and rounding mode " + (Object)((Object)mode));
        }
    }

    static void checkNoOverflow(boolean condition2, String methodName, int a11, int b11) {
        if (!condition2) {
            throw new ArithmeticException("overflow: " + methodName + "(" + a11 + ", " + b11 + ")");
        }
    }

    static void checkNoOverflow(boolean condition2, String methodName, long a11, long b11) {
        if (!condition2) {
            throw new ArithmeticException("overflow: " + methodName + "(" + a11 + ", " + b11 + ")");
        }
    }

    private MathPreconditions() {
    }
}

