/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.apk;

import brut.androlib.ApktoolProperties;
import brut.androlib.apk.PackageInfo;
import brut.androlib.apk.UsesFramework;
import brut.androlib.apk.VersionInfo;
import brut.androlib.apk.YamlLine;
import brut.androlib.apk.YamlReader;
import brut.androlib.apk.YamlSerializable;
import brut.androlib.apk.YamlWriter;
import brut.androlib.exceptions.AndrolibException;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import brut.directory.FileDirectory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public final class ApkInfo
implements YamlSerializable {
    public transient ExtFile mApkFile;
    public String version;
    public String apkFileName;
    public boolean isFrameworkApk;
    public UsesFramework usesFramework;
    public final LinkedHashMap sdkInfo = new LinkedHashMap();
    public PackageInfo packageInfo = new PackageInfo();
    public VersionInfo versionInfo = new VersionInfo();
    public boolean resourcesAreCompressed;
    public boolean sharedLibrary;
    public boolean sparseResources;
    public LinkedHashMap unknownFiles = new LinkedHashMap();
    public ArrayList doNotCompress;

    public ApkInfo(ExtFile extFile) {
        this.version = ApktoolProperties.get("application.version");
        if (extFile != null) {
            this.mApkFile = extFile;
            if (this.apkFileName == null) {
                this.apkFileName = extFile.getName();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApkInfo load(InputStream object) {
        YamlLine yamlLine;
        ApkInfo apkInfo;
        YamlReader yamlReader;
        YamlReader yamlReader2 = yamlReader;
        yamlReader = new YamlReader((InputStream)object);
        object = apkInfo;
        apkInfo = new ApkInfo(null);
        if (yamlReader.isEnd()) return object;
        if (!yamlReader2.isEnd()) {
            YamlReader yamlReader3;
            do {
                yamlLine = (YamlLine)yamlReader2.mLines.get(yamlReader2.mCurrent);
                if (!yamlLine.isEmpty && !yamlLine.isComment) break;
                yamlReader3 = yamlReader2;
                ++yamlReader3.mCurrent;
            } while (!yamlReader3.isEnd());
        }
        while (!yamlReader2.isEnd()) {
            yamlLine = (YamlLine)yamlReader2.mLines.get(yamlReader2.mCurrent);
            if (yamlLine.indent == 0 && yamlLine.hasColon) {
                ((ApkInfo)object).readItem(yamlReader2);
                yamlReader2.nextLine();
                continue;
            }
            yamlReader2.nextLine();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ApkInfo load(File file) {
        ExtFile extFile;
        ApkInfo apkInfo;
        InputStream inputStream = new FileDirectory(file).getFileInput("apktool.yml");
        try {
            apkInfo = ApkInfo.load(inputStream);
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                void var0_4;
                try {
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new AndrolibException((Exception)var0_4);
                }
                catch (DirectoryException directoryException) {
                    throw new AndrolibException((Exception)var0_4);
                }
            }
        }
        ExtFile extFile2 = extFile;
        apkInfo.mApkFile = new ExtFile(file);
        if (apkInfo.apkFileName == null) {
            apkInfo.apkFileName = extFile2.getName();
        }
        if (inputStream == null) return apkInfo;
        inputStream.close();
        return apkInfo;
    }

    public static int mapSdkShorthandToVersion(String string) {
        String string2 = string.toUpperCase();
        string2.getClass();
        int n = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 345728426: {
                if (!string2.equals("VANILLA_ICE_CREAM")) break;
                n = 13;
                break;
            }
            case 28758568: {
                if (!string2.equals("UPSIDE_DOWN_CAKE")) break;
                n = 12;
                break;
            }
            case 82479: {
                if (!string2.equals("SV2")) break;
                n = 11;
                break;
            }
            case 84: {
                if (!string2.equals("T")) break;
                n = 10;
                break;
            }
            case 83: {
                if (!string2.equals("S")) break;
                n = 9;
                break;
            }
            case 82: {
                if (!string2.equals("R")) break;
                n = 8;
                break;
            }
            case 81: {
                if (!string2.equals("Q")) break;
                n = 7;
                break;
            }
            case 80: {
                if (!string2.equals("P")) break;
                n = 6;
                break;
            }
            case 79: {
                if (!string2.equals("O")) break;
                n = 5;
                break;
            }
            case 78: {
                if (!string2.equals("N")) break;
                n = 4;
                break;
            }
            case 77: {
                if (!string2.equals("M")) break;
                n = 3;
                break;
            }
            case -652872116: {
                if (!string2.equals("UPSIDEDOWNCAKE")) break;
                n = 2;
                break;
            }
            case -1154541982: {
                if (!string2.equals("TIRAMISU")) break;
                n = 1;
                break;
            }
            case -1229388494: {
                if (!string2.equals("VANILLAICECREAM")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return Integer.parseInt(string);
            }
            case 11: {
                return 32;
            }
            case 9: {
                return 31;
            }
            case 8: {
                return 30;
            }
            case 7: {
                return 29;
            }
            case 6: {
                return 28;
            }
            case 5: {
                return 26;
            }
            case 4: {
                return 24;
            }
            case 3: {
                return 23;
            }
            case 2: 
            case 12: {
                return 34;
            }
            case 1: 
            case 10: {
                return 33;
            }
            case 0: 
            case 13: 
        }
        return 10000;
    }

    public final boolean hasResources() {
        ExtFile extFile = ((ApkInfo)((Object)extFile)).mApkFile;
        if (extFile == null) {
            return false;
        }
        try {
            return extFile.getDirectory().containsFile("resources.arsc");
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException(directoryException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void save(File file) {
        YamlWriter yamlWriter;
        ApkInfo apkInfo = yamlWriter2;
        YamlWriter yamlWriter2 = yamlWriter;
        yamlWriter = new YamlWriter(new FileOutputStream(file));
        try {
            apkInfo.write(yamlWriter);
        }
        catch (Throwable throwable) {
            try {
                yamlWriter2.mWriter.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                try {
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new AndrolibException(exception);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new AndrolibException("File not found");
                }
            }
        }
        yamlWriter2.mWriter.close();
    }

    @Override
    public final void readItem(YamlReader yamlReader) {
        YamlLine yamlLine = (YamlLine)yamlReader.mLines.get(yamlReader.mCurrent);
        String string = yamlLine.getKey();
        string.getClass();
        int n = -1;
        switch (string.hashCode()) {
            default: {
                break;
            }
            case 1947723784: {
                if (!string.equals("sdkInfo")) break;
                n = 12;
                break;
            }
            case 1078908901: {
                if (!string.equals("sparseResources")) break;
                n = 11;
                break;
            }
            case 955505032: {
                if (!string.equals("isFrameworkApk")) break;
                n = 10;
                break;
            }
            case 908622356: {
                if (!string.equals("packageInfo")) break;
                n = 9;
                break;
            }
            case 688769446: {
                if (!string.equals("versionInfo")) break;
                n = 8;
                break;
            }
            case 500005584: {
                if (!string.equals("resourcesAreCompressed")) break;
                n = 7;
                break;
            }
            case 459524195: {
                if (!string.equals("apkFileName")) break;
                n = 6;
                break;
            }
            case 351608024: {
                if (!string.equals("version")) break;
                n = 5;
                break;
            }
            case 72038848: {
                if (!string.equals("compressionType")) break;
                n = 4;
                break;
            }
            case -126270314: {
                if (!string.equals("sharedLibrary")) break;
                n = 3;
                break;
            }
            case -639607350: {
                if (!string.equals("doNotCompress")) break;
                n = 2;
                break;
            }
            case -1342686131: {
                if (!string.equals("unknownFiles")) break;
                n = 1;
                break;
            }
            case -1981305966: {
                if (!string.equals("usesFramework")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 12: {
                yamlReader.readMap(((ApkInfo)object).sdkInfo);
                break;
            }
            case 11: {
                ((ApkInfo)object).sparseResources = yamlLine.getValueBool();
                break;
            }
            case 10: {
                ((ApkInfo)object).isFrameworkApk = yamlLine.getValueBool();
                break;
            }
            case 9: {
                PackageInfo packageInfo;
                ApkInfo apkInfo = object;
                Object object = packageInfo;
                packageInfo = new PackageInfo();
                apkInfo.packageInfo = object;
                yamlReader.readObject((YamlSerializable)object);
                break;
            }
            case 8: {
                VersionInfo versionInfo;
                ApkInfo apkInfo = object;
                Object object = versionInfo;
                versionInfo = new VersionInfo();
                apkInfo.versionInfo = object;
                yamlReader.readObject((YamlSerializable)object);
                break;
            }
            case 6: {
                ((ApkInfo)object).apkFileName = yamlLine.getValue();
                break;
            }
            case 5: {
                ((ApkInfo)object).version = yamlLine.getValue();
                break;
            }
            case 4: 
            case 7: {
                ((ApkInfo)object).resourcesAreCompressed = yamlLine.getValueBool();
                break;
            }
            case 3: {
                ((ApkInfo)object).sharedLibrary = yamlLine.getValueBool();
                break;
            }
            case 2: {
                ArrayList arrayList;
                ApkInfo apkInfo = object;
                Object object = arrayList;
                arrayList = new ArrayList();
                apkInfo.doNotCompress = object;
                yamlReader.readStringList((ArrayList)object);
                break;
            }
            case 1: {
                LinkedHashMap linkedHashMap;
                ApkInfo apkInfo = object;
                Object object = linkedHashMap;
                linkedHashMap = new LinkedHashMap();
                apkInfo.unknownFiles = object;
                yamlReader.readMap((LinkedHashMap)object);
                break;
            }
            case 0: {
                UsesFramework usesFramework;
                ApkInfo apkInfo = object;
                Object object = usesFramework;
                usesFramework = new UsesFramework();
                apkInfo.usesFramework = object;
                yamlReader.readObject((YamlSerializable)object);
            }
        }
    }

    @Override
    public final void write(YamlWriter yamlWriter) {
        yamlWriter.writeString("version", this.version);
        yamlWriter.writeString("apkFileName", this.apkFileName);
        yamlWriter.writeBool("isFrameworkApk", this.isFrameworkApk);
        yamlWriter.writeObject("usesFramework", this.usesFramework);
        yamlWriter.writeStringMap("sdkInfo", this.sdkInfo);
        yamlWriter.writeObject("packageInfo", this.packageInfo);
        yamlWriter.writeObject("versionInfo", this.versionInfo);
        yamlWriter.writeBool("resourcesAreCompressed", this.resourcesAreCompressed);
        yamlWriter.writeBool("sharedLibrary", this.sharedLibrary);
        yamlWriter.writeBool("sparseResources", this.sparseResources);
        if (this.unknownFiles.size() > 0) {
            yamlWriter.writeStringMap("unknownFiles", this.unknownFiles);
        }
        yamlWriter.writeList("doNotCompress", this.doNotCompress);
    }
}

