/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked;

import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.iface.DexFile;
import com.android.tools.smali.dexlib2.iface.MultiDexContainer;
import com.android.tools.smali.dexlib2.util.DexUtil;
import com.android.tools.smali.util.InputStreamUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ZipDexContainer
implements MultiDexContainer<DexBackedDexFile> {
    private final File zipFilePath;
    @Nullable
    private final Opcodes opcodes;
    private TreeMap<String, DexBackedDexFile> entries;

    public ZipDexContainer(@Nonnull File zipFilePath, @Nullable Opcodes opcodes) {
        this.zipFilePath = zipFilePath;
        this.opcodes = opcodes;
    }

    @Override
    @Nonnull
    public List<String> getDexEntryNames() throws IOException {
        return new ArrayList<String>(this.getEntries().keySet());
    }

    private Map<String, DexBackedDexFile> getEntries() throws IOException {
        if (this.entries != null) {
            return this.entries;
        }
        this.entries = new TreeMap();
        try (ZipFile zipFile = this.getZipFile();){
            Enumeration<? extends ZipEntry> entriesEnumeration = zipFile.entries();
            while (entriesEnumeration.hasMoreElements()) {
                ZipEntry entry = entriesEnumeration.nextElement();
                if (!this.isDex(zipFile, entry)) continue;
                InputStream inputStream = zipFile.getInputStream(entry);
                try {
                    byte[] buf = InputStreamUtil.toByteArray(inputStream);
                    int offset = 0;
                    int i = 1;
                    while (offset < buf.length) {
                        DexBackedDexFile dex = new DexBackedDexFile(this.opcodes, buf, 0, true, offset);
                        this.entries.put(entry.getName() + (i > 1 ? "/" + i : ""), dex);
                        offset += dex.getFileSize();
                        ++i;
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            TreeMap<String, DexBackedDexFile> treeMap = this.entries;
            return treeMap;
        }
    }

    @Override
    @Nullable
    public MultiDexContainer.DexEntry<DexBackedDexFile> getEntry(final @Nonnull String entryName) throws IOException {
        final DexFile dexFile = this.getEntries().get(entryName);
        if (dexFile == null) {
            return null;
        }
        return new MultiDexContainer.DexEntry(){
            final /* synthetic */ ZipDexContainer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            @Nonnull
            public String getEntryName() {
                return entryName;
            }

            @Nonnull
            public DexFile getDexFile() {
                return dexFile;
            }

            @Nonnull
            public MultiDexContainer getContainer() {
                return this.this$0;
            }
        };
    }

    public boolean isZipFile() {
        boolean bl;
        block9: {
            ZipFile zipFile = this.getZipFile();
            try {
                bl = true;
                if (zipFile == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return false;
                }
                catch (NotAZipFileException ex) {
                    return false;
                }
            }
            zipFile.close();
        }
        return bl;
    }

    protected boolean isDex(@Nonnull ZipFile zipFile, @Nonnull ZipEntry zipEntry) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));){
            DexUtil.verifyDexHeader(inputStream);
        }
        catch (DexBackedDexFile.NotADexFile ex) {
            return false;
        }
        catch (DexUtil.InvalidFile ex) {
            return false;
        }
        catch (DexUtil.UnsupportedFile ex) {
            return false;
        }
        return true;
    }

    protected ZipFile getZipFile() throws IOException {
        try {
            return new ZipFile(this.zipFilePath);
        }
        catch (IOException ex) {
            throw new NotAZipFileException();
        }
    }

    public static class NotAZipFileException
    extends RuntimeException {
    }
}

