/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.dnd;

import com.sun.jna.platform.WindowUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class GhostedDragImage {
    private static final float DEFAULT_ALPHA = 0.5f;
    private Window dragImage;
    private Point origin;
    private static final int SLIDE_INTERVAL = 33;

    public GhostedDragImage(Component dragSource, final Icon icon, Point initialScreenLoc, final Point cursorOffset) {
        Window parent = dragSource instanceof Window ? (Window)dragSource : SwingUtilities.getWindowAncestor(dragSource);
        GraphicsConfiguration gc2 = parent.getGraphicsConfiguration();
        this.dragImage = new Window(JOptionPane.getRootFrame(), gc2){
            private static final long serialVersionUID = 1L;

            @Override
            public void paint(Graphics g11) {
                icon.paintIcon(this, g11, 0, 0);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(icon.getIconWidth(), icon.getIconHeight());
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.dragImage.setFocusableWindowState(false);
        this.dragImage.setName("###overrideRedirect###");
        Icon dragIcon = new Icon(){

            @Override
            public int getIconHeight() {
                return icon.getIconHeight();
            }

            @Override
            public int getIconWidth() {
                return icon.getIconWidth();
            }

            @Override
            public void paintIcon(Component c11, Graphics g11, int x11, int y11) {
                g11 = g11.create();
                Area area = new Area(new Rectangle(x11, y11, this.getIconWidth(), this.getIconHeight()));
                area.subtract(new Area(new Rectangle(x11 + cursorOffset.x - 1, y11 + cursorOffset.y - 1, 3, 3)));
                g11.setClip(area);
                icon.paintIcon(c11, g11, x11, y11);
                g11.dispose();
            }
        };
        this.dragImage.pack();
        WindowUtils.setWindowMask(this.dragImage, dragIcon);
        WindowUtils.setWindowAlpha(this.dragImage, 0.5f);
        this.move(initialScreenLoc);
        this.dragImage.setVisible(true);
    }

    public void setAlpha(float alpha) {
        WindowUtils.setWindowAlpha(this.dragImage, alpha);
    }

    public void dispose() {
        this.dragImage.dispose();
        this.dragImage = null;
    }

    public void move(Point screenLocation) {
        if (this.origin == null) {
            this.origin = screenLocation;
        }
        this.dragImage.setLocation(screenLocation.x, screenLocation.y);
    }

    public void returnToOrigin() {
        final Timer timer = new Timer(33, null);
        timer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e11) {
                Point location = GhostedDragImage.this.dragImage.getLocationOnScreen();
                Point dst = new Point(GhostedDragImage.this.origin);
                int dx2 = (dst.x - location.x) / 2;
                int dy2 = (dst.y - location.y) / 2;
                if (dx2 != 0 || dy2 != 0) {
                    location.translate(dx2, dy2);
                    GhostedDragImage.this.move(location);
                } else {
                    timer.stop();
                    GhostedDragImage.this.dispose();
                }
            }
        });
        timer.setInitialDelay(0);
        timer.start();
    }
}

