/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.directory.AbstractDirectory;
import brut.directory.DirectoryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public final class FileDirectory
extends AbstractDirectory {
    public final File mDir;

    public FileDirectory(File file) {
        if (file.isDirectory()) {
            this.mDir = file;
            return;
        }
        throw new DirectoryException("file must be a directory: " + file);
    }

    @Override
    public final long getSize(String string) {
        File file;
        File file2 = file;
        if (new File(this.generatePath(string)).isFile()) {
            return file2.length();
        }
        throw new DirectoryException("file must be a file: " + file2);
    }

    @Override
    public final AbstractDirectory createDirLocal(String string) {
        File file;
        File file2 = file;
        new File(this.generatePath(string)).mkdir();
        return new FileDirectory(file2);
    }

    @Override
    public final InputStream getFileInputLocal(String string) {
        try {
            return new FileInputStream(this.generatePath(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DirectoryException(fileNotFoundException);
        }
    }

    @Override
    public final OutputStream getFileOutputLocal(String string) {
        try {
            return new FileOutputStream(this.generatePath(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DirectoryException(fileNotFoundException);
        }
    }

    @Override
    public final void loadDirs() {
        this.loadAll();
    }

    @Override
    public final void loadFiles() {
        this.loadAll();
    }

    @Override
    public final void removeFileLocal(String string) {
        new File(this.generatePath(string)).delete();
    }

    public final String generatePath(String string) {
        return this.mDir.getPath() + '/' + string;
    }

    public final void loadAll() {
        this.mFiles = new LinkedHashSet();
        this.mDirs = new LinkedHashMap();
        File[] fileArray = this.mDir.listFiles();
        Arrays.sort(fileArray, Comparator.comparing(file -> file.getName()));
        for (File file2 : fileArray) {
            if (file2.isFile()) {
                this.mFiles.add(file2.getName());
                continue;
            }
            try {
                this.mDirs.put(file2.getName(), new FileDirectory(file2));
            }
            catch (DirectoryException directoryException) {}
        }
    }
}

