## [v2.0a](https://github.com/owtf/owtf/tree/v2.0a) Tikka Masala
[Full Changelog](https://github.com/owtf/owtf/compare/v1.0.1...HEAD)

**Implemented enhancements:**

- xxx\_testgroups.cfg should be moved to /profiles [\#670](https://github.com/owtf/owtf/issues/670)
- OWTF takes few steps to start [\#638](https://github.com/owtf/owtf/issues/638)
- Session Modal breaks for large session names [\#635](https://github.com/owtf/owtf/issues/635)
- Check for tools before running commands [\#632](https://github.com/owtf/owtf/issues/632)
- Adding Issue and Pull Request templates [\#599](https://github.com/owtf/owtf/issues/599)
- Debian and Samurai install scripts are not executable. [\#573](https://github.com/owtf/owtf/issues/573)
- Increase readability of manual installation output on terminal. [\#564](https://github.com/owtf/owtf/issues/564)
- Installer Issues [\#534](https://github.com/owtf/owtf/issues/534)
- Passive google searches should use @@@domain@@@ instead of @@@host\_path@@@ [\#529](https://github.com/owtf/owtf/issues/529)
- Increase proxy CA security [\#526](https://github.com/owtf/owtf/issues/526)
- Add https://censys.io/ to the passive search [\#523](https://github.com/owtf/owtf/issues/523)
- install/install.py skip sudo password [\#519](https://github.com/owtf/owtf/issues/519)
- Using a remote server [\#510](https://github.com/owtf/owtf/issues/510)
- potential command to add to the install scripts \(develop branch\) [\#473](https://github.com/owtf/owtf/issues/473)
- Timestamps not present in transaction log [\#472](https://github.com/owtf/owtf/issues/472)
- Evaluate the possible implementation of JS templating for all client-side OWTF interactions [\#467](https://github.com/owtf/owtf/issues/467)
- External XSS plugin resource: XSS Payloads [\#466](https://github.com/owtf/owtf/issues/466)
- What is the hurdle in doing passive scan's [\#464](https://github.com/owtf/owtf/issues/464)
- Rank should collapse the plugin, at least in some cases [\#459](https://github.com/owtf/owtf/issues/459)
- Suggested improvements for the transaction log  [\#458](https://github.com/owtf/owtf/issues/458)
- Integration with punk spider for passive tests [\#457](https://github.com/owtf/owtf/issues/457)
- Clean up colours from various tools prior to saving it in a file [\#456](https://github.com/owtf/owtf/issues/456)
- Export targets feature \(UI\) [\#454](https://github.com/owtf/owtf/issues/454)
- Lack of filters on target page \(UI\) [\#453](https://github.com/owtf/owtf/issues/453)
- Improve curl commands [\#446](https://github.com/owtf/owtf/issues/446)
- CPU spikes: Lack of Indexing on OWTF db?  [\#444](https://github.com/owtf/owtf/issues/444)
- Add “Pause All / Resume All” to the worker monitoring [\#440](https://github.com/owtf/owtf/issues/440)
- Review OWTF CPU usage post-DirBuster [\#437](https://github.com/owtf/owtf/issues/437)
- Smarter Runner  [\#430](https://github.com/owtf/owtf/issues/430)
- Unable to “delete all” from worklist on UI [\#427](https://github.com/owtf/owtf/issues/427)
- OWTF should check if postgresql client is installed as well [\#413](https://github.com/owtf/owtf/issues/413)
- External Command Injection plugin link [\#412](https://github.com/owtf/owtf/issues/412)
- Mobile responsive [\#406](https://github.com/owtf/owtf/issues/406)
- \[develop\] OWTF should start NET plugins when target is an IP [\#375](https://github.com/owtf/owtf/issues/375)
- ImportError: No module named backports.ssl\_match\_hostname [\#374](https://github.com/owtf/owtf/issues/374)
- Settings \> HTTP AUTH [\#369](https://github.com/owtf/owtf/issues/369)
- Setup gemnasium [\#358](https://github.com/owtf/owtf/issues/358)
- Worklist search boxes should not be case sensitive [\#355](https://github.com/owtf/owtf/issues/355)
- Automated Bug reporter improvement [\#352](https://github.com/owtf/owtf/issues/352)
- Possible improvement for the UI worker buttons [\#350](https://github.com/owtf/owtf/issues/350)
- Minor intuitiveness improvements [\#349](https://github.com/owtf/owtf/issues/349)
- Arachni changed from --user-agent to --http-user-agent [\#347](https://github.com/owtf/owtf/issues/347)
- Ensure running postgres before running install script [\#337](https://github.com/owtf/owtf/issues/337)
- Issues on Ubuntu [\#334](https://github.com/owtf/owtf/issues/334)
- OWTF should check if postgres is running [\#311](https://github.com/owtf/owtf/issues/311)
- \[zest\] Updating the zest jars [\#293](https://github.com/owtf/owtf/issues/293)
- \[wapiti\] HTML report is not available anymore [\#287](https://github.com/owtf/owtf/issues/287)
- Display logs in the webUI [\#271](https://github.com/owtf/owtf/issues/271)
- Installed Tool Validation Project [\#249](https://github.com/owtf/owtf/issues/249)
- Run plugins pop up window improvement \(UI branch\) [\#243](https://github.com/owtf/owtf/issues/243)
- Generate script for creating CA custom OpenVAS during installation [\#170](https://github.com/owtf/owtf/issues/170)
- Explore CMS-Explorer dictionary alternatives for best results [\#119](https://github.com/owtf/owtf/issues/119)
- Moving external plugin reports away from targets subreports [\#111](https://github.com/owtf/owtf/issues/111)
- Check if the service that is going to be scanned speaks HTTP before launching ANY web test [\#108](https://github.com/owtf/owtf/issues/108)
- Form-based authentication [\#90](https://github.com/owtf/owtf/issues/90)
- owtf  auto-update option [\#31](https://github.com/owtf/owtf/issues/31)
- filter by severity feature added [\#576](https://github.com/owtf/owtf/pull/576) ([saganshul](https://github.com/saganshul))

**Fixed bugs:**

- PostgreSQL Fix in db\_setup.sh should use SHOW config\_file; [\#669](https://github.com/owtf/owtf/issues/669)
- PostgreSQL Fix in db\_setup.sh restarts postgresql daemon in any case [\#668](https://github.com/owtf/owtf/issues/668)
- ConfigDB silently fails when default.cfg not found [\#666](https://github.com/owtf/owtf/issues/666)
- Bash 'which' error in db\_setup.sh script [\#662](https://github.com/owtf/owtf/issues/662)
- Improper Set-Cookie header handling in proxy [\#582](https://github.com/owtf/owtf/issues/582)
- Same rank cannot be given to a plugin twice [\#570](https://github.com/owtf/owtf/issues/570)
- Listing plugins option \(-l\) not working [\#556](https://github.com/owtf/owtf/issues/556)
- Plugin Filter Display not working properly [\#547](https://github.com/owtf/owtf/issues/547)
- Proxy errors \(silent\) in logs [\#528](https://github.com/owtf/owtf/issues/528)
- Workers do not pick items from worklist [\#527](https://github.com/owtf/owtf/issues/527)
- Unable to open directory from browser [\#525](https://github.com/owtf/owtf/issues/525)
- Error calling make\_dirs when a long URL is passed  [\#521](https://github.com/owtf/owtf/issues/521)
- \[develop\] plugin getting stuck stops the whole scan... [\#515](https://github.com/owtf/owtf/issues/515)
- Getting error while running plugins. Error "Oops! Server replied: Bad Request" [\#481](https://github.com/owtf/owtf/issues/481)
- The grep stats for header matche percent are incorrect [\#470](https://github.com/owtf/owtf/issues/470)
- UI doesn't cope with multiple simultaneous tabs / actions? :P [\#455](https://github.com/owtf/owtf/issues/455)
- CPU spikes: Lack of Indexing on OWTF db?  [\#444](https://github.com/owtf/owtf/issues/444)
- Bug - "Ops unable to add some targets” [\#443](https://github.com/owtf/owtf/issues/443)
- BUG in “Testing For Ssl-Tls” plugin in latest Kali [\#442](https://github.com/owtf/owtf/issues/442)
- Directory Brute-forcing should be towards the end of the scan [\#441](https://github.com/owtf/owtf/issues/441)
- postgres “idle in transaction” processes occasionally spike CPU usage [\#438](https://github.com/owtf/owtf/issues/438)
- Ocassional Crash after running skipfish [\#435](https://github.com/owtf/owtf/issues/435)
- Occassional failure to close children processes [\#434](https://github.com/owtf/owtf/issues/434)
-  Target shuffling [\#433](https://github.com/owtf/owtf/issues/433)
- Bug in MiTM proxy Cookie parser [\#428](https://github.com/owtf/owtf/issues/428)
- Unreasonable use of CPU/memory by postgres / owtf processes [\#426](https://github.com/owtf/owtf/issues/426)
- Nikto plugin not realising when nikto has finished [\#422](https://github.com/owtf/owtf/issues/422)
- bootstrap.sh Fails while Installing in Kali [\#416](https://github.com/owtf/owtf/issues/416)
- ValueError when OWTF is run without postgresql properly configured [\#414](https://github.com/owtf/owtf/issues/414)
- OWTF should check if postgresql client is installed as well [\#413](https://github.com/owtf/owtf/issues/413)
- Add target UI issue [\#405](https://github.com/owtf/owtf/issues/405)
- OWTF-DV-004 semi passive no output [\#404](https://github.com/owtf/owtf/issues/404)
- Transaction Logger Bug [\#403](https://github.com/owtf/owtf/issues/403)
- Adding a Target Issue [\#402](https://github.com/owtf/owtf/issues/402)
- \[develop\] User overriding the 2nd plugin of a test case to Passing won't update the test case [\#400](https://github.com/owtf/owtf/issues/400)
- Create Zest Script Error [\#383](https://github.com/owtf/owtf/issues/383)
- \[develop\] -f does not work [\#379](https://github.com/owtf/owtf/issues/379)
- \[develop\] Can't run OWTF more than once against the same target [\#378](https://github.com/owtf/owtf/issues/378)
- \[develop\] -e does not work when using the CLI  [\#377](https://github.com/owtf/owtf/issues/377)
- \[develop\] -t does not work with -o when using the CLI [\#376](https://github.com/owtf/owtf/issues/376)
- \\[develop\\] OWTF should start NET plugins when target is an IP [\#375](https://github.com/owtf/owtf/issues/375)
- ImportError: No module named backports.ssl\\_match\\_hostname [\#374](https://github.com/owtf/owtf/issues/374)
- \[develop\] CLI listing plugins fails [\#366](https://github.com/owtf/owtf/issues/366)
- \[develop\] Pressing 'n' when some tools were not found does not abort OWTF [\#365](https://github.com/owtf/owtf/issues/365)
- \[develop\] TypeError when assigning a ranking [\#362](https://github.com/owtf/owtf/issues/362)
- wrong permissions on /root/owtf/scripts/db\_run.sh? [\#360](https://github.com/owtf/owtf/issues/360)
- Recommended download method fails if bootstrap.sh exists [\#359](https://github.com/owtf/owtf/issues/359)
- Arachni changed from --user-agent to --http-user-agent [\#347](https://github.com/owtf/owtf/issues/347)
- Ensure running postgres before running install script [\#337](https://github.com/owtf/owtf/issues/337)
- Proxychains command investigation [\#318](https://github.com/owtf/owtf/issues/318)
- Workers can be set to Zero [\#306](https://github.com/owtf/owtf/issues/306)
- The report has messy owtf commands with proxychains config [\#275](https://github.com/owtf/owtf/issues/275)
- Bug in install script [\#259](https://github.com/owtf/owtf/issues/259)
- Bug in bug reporter :P [\#228](https://github.com/owtf/owtf/issues/228)
- multiprocessing deadlock [\#224](https://github.com/owtf/owtf/issues/224)
- \[lions\_2014\] Workers disappear sometimes. [\#223](https://github.com/owtf/owtf/issues/223)
- MiTM proxy bug: Secure Connection Failed [\#222](https://github.com/owtf/owtf/issues/222)
- Issues on execution flow UI: Command zombies and inability to stop individual commands [\#97](https://github.com/owtf/owtf/issues/97)
- multiprocessing deadlock [\#93](https://github.com/owtf/owtf/issues/93)
- Don't run internet resources against intranet sites [\#37](https://github.com/owtf/owtf/issues/37)

**Closed issues:**

- PostgreSQL Fix in db\_setup.sh out-dated? [\#667](https://github.com/owtf/owtf/issues/667)
- list plugin command \(-l\) for auxiliary plugins not working [\#647](https://github.com/owtf/owtf/issues/647)
- Fix run\_tlssled.sh permission [\#645](https://github.com/owtf/owtf/issues/645)
- Bug in progress bar [\#644](https://github.com/owtf/owtf/issues/644)
- Dirbuster Plugin not working [\#642](https://github.com/owtf/owtf/issues/642)
- Re-running plugin from GUI not working properly [\#639](https://github.com/owtf/owtf/issues/639)
- keyboard Interrupt Exception Handling [\#637](https://github.com/owtf/owtf/issues/637)
- Reflected XSS Vulnerability [\#613](https://github.com/owtf/owtf/issues/613)
- File Redundancy [\#609](https://github.com/owtf/owtf/issues/609)
- Verify distribution during installation [\#607](https://github.com/owtf/owtf/issues/607)
- UI Add Targets button bug [\#605](https://github.com/owtf/owtf/issues/605)
- Dependency checks , libraries Should be Installed Automatically. [\#604](https://github.com/owtf/owtf/issues/604)
- Error 301 on fetching updates [\#603](https://github.com/owtf/owtf/issues/603)
- Connection reset by peer - wget [\#592](https://github.com/owtf/owtf/issues/592)
- Suppress apt-get confirmations [\#585](https://github.com/owtf/owtf/issues/585)
- Initial Update [\#584](https://github.com/owtf/owtf/issues/584)
- Db query filter should be updated according to current database [\#579](https://github.com/owtf/owtf/issues/579)
- Installation problem on ubuntu [\#566](https://github.com/owtf/owtf/issues/566)
- IDE specific auto-generated files need to be in gitignore. [\#562](https://github.com/owtf/owtf/issues/562)
- README - GSoC 2016 wiki link broken [\#561](https://github.com/owtf/owtf/issues/561)
- Added SVN-Extractor \(issue \#485\) [\#550](https://github.com/owtf/owtf/issues/550)
- Installation in Kali is not working correctly [\#544](https://github.com/owtf/owtf/issues/544)
- Metagoofil missing in Kali 2.x [\#542](https://github.com/owtf/owtf/issues/542)
- Should run aptitude update before trying to install any packages [\#540](https://github.com/owtf/owtf/issues/540)
- Missing libraries [\#531](https://github.com/owtf/owtf/issues/531)
- Pip Import Error Kali Install [\#520](https://github.com/owtf/owtf/issues/520)
- OWTF develop branch install error in Kali Linux 2.0 [\#516](https://github.com/owtf/owtf/issues/516)
- \[develop\] broken cookie parser [\#514](https://github.com/owtf/owtf/issues/514)
- \[develop\] cannot launch any web plugins... [\#513](https://github.com/owtf/owtf/issues/513)
- \[develop\] crash after install on latest kali: column test\_groups.priority does not exist [\#512](https://github.com/owtf/owtf/issues/512)
- owtf install on Kali2 fails - cryptography [\#509](https://github.com/owtf/owtf/issues/509)
- Not giving alternative ips [\#506](https://github.com/owtf/owtf/issues/506)
- Command Execution possible using '&' character in argument [\#503](https://github.com/owtf/owtf/issues/503)
- url encoding not working on command line interface [\#499](https://github.com/owtf/owtf/issues/499)
- Error in handling special characters in url [\#496](https://github.com/owtf/owtf/issues/496)
- url check not working properly [\#494](https://github.com/owtf/owtf/issues/494)
- "msfcli" no longer in metasploit [\#491](https://github.com/owtf/owtf/issues/491)
- Installer fails on latest Kali \(develop branch\) [\#474](https://github.com/owtf/owtf/issues/474)
- DNSpider will not download [\#471](https://github.com/owtf/owtf/issues/471)
- Metasploit msfcli is deprecated. OWTF plugins should be updated. [\#469](https://github.com/owtf/owtf/issues/469)
- Evaluate the use of extracting URIs from different file inputs [\#468](https://github.com/owtf/owtf/issues/468)
- XSS reports on http://xssposed.org/ [\#465](https://github.com/owtf/owtf/issues/465)
- multiple responsive web ui issues [\#463](https://github.com/owtf/owtf/issues/463)
- Can you guys add feature to scan I2P sites? Eepsites. [\#461](https://github.com/owtf/owtf/issues/461)
- Add Flashbang to OWTF [\#445](https://github.com/owtf/owtf/issues/445)
- Modify run\_w3af.sh so that buffer overflow tests are DISABLED [\#436](https://github.com/owtf/owtf/issues/436)
- Clean-up the merged dictionary \(duplicate entries\) [\#432](https://github.com/owtf/owtf/issues/432)
- Selected pagination setting is not remembered on home page [\#431](https://github.com/owtf/owtf/issues/431)
- Remove websecurify [\#420](https://github.com/owtf/owtf/issues/420)
- Display start time on the worker summary screen [\#419](https://github.com/owtf/owtf/issues/419)
- Installation Issue [\#409](https://github.com/owtf/owtf/issues/409)
- Add Targets more responsive [\#407](https://github.com/owtf/owtf/issues/407)
- SSL Labs Upgrade with new API access [\#401](https://github.com/owtf/owtf/issues/401)
- replace msfcli with msfconsole -x or -r [\#399](https://github.com/owtf/owtf/issues/399)
- Lionhearted won't launch after install on Kali 1.09 [\#398](https://github.com/owtf/owtf/issues/398)
- error on bootstrap [\#397](https://github.com/owtf/owtf/issues/397)
- redisgned homepage  [\#396](https://github.com/owtf/owtf/issues/396)
- option -t not working on develop [\#390](https://github.com/owtf/owtf/issues/390)
- Owtf not starting [\#385](https://github.com/owtf/owtf/issues/385)
- Create docker container for OWTF [\#382](https://github.com/owtf/owtf/issues/382)
- Owtf not working properly with latest version of pip [\#380](https://github.com/owtf/owtf/issues/380)
- Show progress of scan [\#373](https://github.com/owtf/owtf/issues/373)
- Selecting plugs-ins [\#372](https://github.com/owtf/owtf/issues/372)
- Open links in a new tab [\#371](https://github.com/owtf/owtf/issues/371)
- Settings \>  TOOLS [\#370](https://github.com/owtf/owtf/issues/370)
- Fix permissions [\#368](https://github.com/owtf/owtf/issues/368)
- DNSpider is called with arguments that include the URL scheme [\#364](https://github.com/owtf/owtf/issues/364)
- bootstrap.sh checksum doesn't match download page [\#363](https://github.com/owtf/owtf/issues/363)
- Web UI icons text pop-up \(hovering over explanation\) [\#361](https://github.com/owtf/owtf/issues/361)
- "ImportError: No module named adapters" during install [\#357](https://github.com/owtf/owtf/issues/357)
- \[Auto-Generated\]  Minor issue: /bin/sh: 1: /home/valentino/frame/owtf/scripts/extract\_urls.sh: Permission denied is not a valid URL and has been ignored, processing continues [\#353](https://github.com/owtf/owtf/issues/353)
- \[Auto-Generated\]  Plugin grep/Application\_Configuration\_Management@OWASP-CM-004.py failed for target http://some.target.com [\#351](https://github.com/owtf/owtf/issues/351)
- python version to use? [\#346](https://github.com/owtf/owtf/issues/346)
- db.cfg path error. [\#345](https://github.com/owtf/owtf/issues/345)
- Installation fails on Kali Linux [\#344](https://github.com/owtf/owtf/issues/344)
- Debug notes in Installation Script [\#340](https://github.com/owtf/owtf/issues/340)
- Installation fails on Samurai WTF [\#339](https://github.com/owtf/owtf/issues/339)
- improved sslscan [\#329](https://github.com/owtf/owtf/issues/329)
- \[Auto-Generated\]  ValueError: invalid literal for int\(\) with base 10: '' [\#320](https://github.com/owtf/owtf/issues/320)
- \[Auto-Generated\]  Plugin active/HTTP\_Methods\_and\_XST@OWASP-CM-008.py failed for target http://some.target.com [\#319](https://github.com/owtf/owtf/issues/319)
- OWASP Top 10 Mapping [\#304](https://github.com/owtf/owtf/issues/304)
- github.io AND interactive report top SCA tools by platform [\#303](https://github.com/owtf/owtf/issues/303)
- Dependencies Update Option [\#300](https://github.com/owtf/owtf/issues/300)
- \[Auto-Generated\]  Plugin grep/Credentials\_transport\_over\_an\_encrypted\_channel@OWASP-AT-001.py failed for target http://some.target.com [\#272](https://github.com/owtf/owtf/issues/272)
- \[Auto-Generated\]  Plugin active/Testing\_for\_SSL-TLS@OWASP-CM-001.py failed for target http://some.target.com [\#270](https://github.com/owtf/owtf/issues/270)
- Current OWTF's cookies manager is broken [\#256](https://github.com/owtf/owtf/issues/256)
- \[Auto-Generated\]  Unknown owtf error [\#248](https://github.com/owtf/owtf/issues/248)
- CWE compatibility [\#217](https://github.com/owtf/owtf/issues/217)
- OWTF Demos redirects to 404 page. [\#206](https://github.com/owtf/owtf/issues/206)
- OWTF Installation Improvement [\#192](https://github.com/owtf/owtf/issues/192)
- PEP8 Pre-Commit Hook [\#191](https://github.com/owtf/owtf/issues/191)
- Checking for Internal IP Disclosure vunerabilities [\#165](https://github.com/owtf/owtf/issues/165)
- Evaluate the value of OWASP O-shaft and decide if is worth adding to OWTF or not [\#120](https://github.com/owtf/owtf/issues/120)
- Investigate integration with Vivek's search engine [\#116](https://github.com/owtf/owtf/issues/116)
- Mitigation boiler plate DB [\#91](https://github.com/owtf/owtf/issues/91)
- Travis CI is still broken.. [\#82](https://github.com/owtf/owtf/issues/82)
- Zest integration [\#49](https://github.com/owtf/owtf/issues/49)
- Malego-like transforms for OWTF [\#35](https://github.com/owtf/owtf/issues/35)
- would be nice some listings... [\#3](https://github.com/owtf/owtf/issues/3)

**Merged pull requests:**

- Added file check before reading config files, Fixes \#666 [\#673](https://github.com/owtf/owtf/pull/673) ([DarKnight--](https://github.com/DarKnight--))
- Moved test\_group files to profile folder, fixes \#670 [\#671](https://github.com/owtf/owtf/pull/671) ([DarKnight--](https://github.com/DarKnight--))
- Revert "set plugin group to web if not specified, fixes \#390" [\#664](https://github.com/owtf/owtf/pull/664) ([DarKnight--](https://github.com/DarKnight--))
- Better handling of service controllers [\#663](https://github.com/owtf/owtf/pull/663) ([sachinkamath](https://github.com/sachinkamath))
- set plugin group to web if not specified, fixes \#390 [\#659](https://github.com/owtf/owtf/pull/659) ([DarKnight--](https://github.com/DarKnight--))
- Scripts permissions [\#657](https://github.com/owtf/owtf/pull/657) ([pauTE](https://github.com/pauTE))
- Fixes syntax error in UpdateTarget function of target\_manager.py [\#656](https://github.com/owtf/owtf/pull/656) ([DarKnight--](https://github.com/DarKnight--))
- Progress Bar Bug Fixed. Fixes \#644 [\#653](https://github.com/owtf/owtf/pull/653) ([saganshul](https://github.com/saganshul))
- Added bulk target operations: remove/delete [\#652](https://github.com/owtf/owtf/pull/652) ([mikefitz888](https://github.com/mikefitz888))
- Dirbuster plugin working fixes \#642 [\#649](https://github.com/owtf/owtf/pull/649) ([DoomTaper](https://github.com/DoomTaper))
- added auxiliary plugin test group, this makes -l command functional [\#648](https://github.com/owtf/owtf/pull/648) ([DarKnight--](https://github.com/DarKnight--))
- Show less functionality added to optimize the click flow [\#643](https://github.com/owtf/owtf/pull/643) ([saganshul](https://github.com/saganshul))
- Fixes \#639 and properly fixes \#379 [\#640](https://github.com/owtf/owtf/pull/640) ([DoomTaper](https://github.com/DoomTaper))
- Truncated long session names [\#636](https://github.com/owtf/owtf/pull/636) ([sachinkamath](https://github.com/sachinkamath))
- Removed unnecessary click [\#633](https://github.com/owtf/owtf/pull/633) ([mikefitz888](https://github.com/mikefitz888))
- Corrected arachni command to display [\#630](https://github.com/owtf/owtf/pull/630) ([DoomTaper](https://github.com/DoomTaper))
- Added installation scripts [\#629](https://github.com/owtf/owtf/pull/629) ([sachinkamath](https://github.com/sachinkamath))
- Removed redundant HTTP-Traceroute.py with traceroute dir [\#628](https://github.com/owtf/owtf/pull/628) ([RahulPratapSingh](https://github.com/RahulPratapSingh))
- Fix \#401 SSL Labs upgrade [\#624](https://github.com/owtf/owtf/pull/624) ([pauTE](https://github.com/pauTE))
- fixed mistake in doc of skipfish plugin [\#620](https://github.com/owtf/owtf/pull/620) ([DoomTaper](https://github.com/DoomTaper))
- Fixed mavitunasecurity.com redirection [\#619](https://github.com/owtf/owtf/pull/619) ([RahulPratapSingh](https://github.com/RahulPratapSingh))
- Corrected Typo Errors [\#617](https://github.com/owtf/owtf/pull/617) ([RahulPratapSingh](https://github.com/RahulPratapSingh))
- Added 3 Httprint Signatures [\#616](https://github.com/owtf/owtf/pull/616) ([RahulPratapSingh](https://github.com/RahulPratapSingh))
- Removed redundant username and password from dictionary [\#615](https://github.com/owtf/owtf/pull/615) ([RahulPratapSingh](https://github.com/RahulPratapSingh))
- Fixed Reflected XSS vulnerability [\#614](https://github.com/owtf/owtf/pull/614) ([RahulPratapSingh](https://github.com/RahulPratapSingh))
- Progress Bar for Scan created on worker page. Fixes \#373 [\#612](https://github.com/owtf/owtf/pull/612) ([saganshul](https://github.com/saganshul))
- Fix \#446 improve curl commands [\#600](https://github.com/owtf/owtf/pull/600) ([pauTE](https://github.com/pauTE))
- Fix for 'illegal number' problem of aptitude wrapper.sh [\#596](https://github.com/owtf/owtf/pull/596) ([karandesai-96](https://github.com/karandesai-96))
- Display start time on the worker summary screen. Fixes \#419 [\#595](https://github.com/owtf/owtf/pull/595) ([saganshul](https://github.com/saganshul))
- fixed rare wget issue [\#593](https://github.com/owtf/owtf/pull/593) ([sachinkamath](https://github.com/sachinkamath))
- Fixed return value of get\_config\_value\(\) function [\#591](https://github.com/owtf/owtf/pull/591) ([pauTE](https://github.com/pauTE))
- Fix Set-Cookie header handling in proxy. Fixes \#582 [\#590](https://github.com/owtf/owtf/pull/590) ([karandesai-96](https://github.com/karandesai-96))
- Cleanup install script to reduce memory overhead. [\#588](https://github.com/owtf/owtf/pull/588) ([karandesai-96](https://github.com/karandesai-96))
- Fixes \#585 [\#586](https://github.com/owtf/owtf/pull/586) ([sachinkamath](https://github.com/sachinkamath))
- Fix for issue \#579 [\#583](https://github.com/owtf/owtf/pull/583) ([DoomTaper](https://github.com/DoomTaper))
- fixed import errors [\#580](https://github.com/owtf/owtf/pull/580) ([DarKnight--](https://github.com/DarKnight--))
- corrected missing scope of exception [\#578](https://github.com/owtf/owtf/pull/578) ([DarKnight--](https://github.com/DarKnight--))
- Revert "robots.txt spelling mistakes corrected" [\#577](https://github.com/owtf/owtf/pull/577) ([delta24](https://github.com/delta24))
- Ensures execution of Debian and Samurai scripts. Fixes \#573 [\#574](https://github.com/owtf/owtf/pull/574) ([karandesai-96](https://github.com/karandesai-96))
- robots.txt spelling mistakes corrected [\#572](https://github.com/owtf/owtf/pull/572) ([sharad1126](https://github.com/sharad1126))
- Added name attribute to radio button to group them. Fixes issue \#570 [\#571](https://github.com/owtf/owtf/pull/571) ([tpnsharma](https://github.com/tpnsharma))
- cwe mapping for plugins [\#568](https://github.com/owtf/owtf/pull/568) ([DarKnight--](https://github.com/DarKnight--))
- Proper Fixes for issue \#556 [\#567](https://github.com/owtf/owtf/pull/567) ([DoomTaper](https://github.com/DoomTaper))
- Colorize output text of python install script in terminal. Fixes \#564 [\#565](https://github.com/owtf/owtf/pull/565) ([karandesai-96](https://github.com/karandesai-96))
- IDE specific auto-generated files now in .gitignore. Fixes \#562 [\#563](https://github.com/owtf/owtf/pull/563) ([karandesai-96](https://github.com/karandesai-96))
- Fixes msfcli issue [\#559](https://github.com/owtf/owtf/pull/559) ([DarKnight--](https://github.com/DarKnight--))
- FIxes the issue \#547 [\#558](https://github.com/owtf/owtf/pull/558) ([DoomTaper](https://github.com/DoomTaper))
- fixes Listing plugins\(-l\) option issue \#556 [\#557](https://github.com/owtf/owtf/pull/557) ([DoomTaper](https://github.com/DoomTaper))
- fixes -f option [\#555](https://github.com/owtf/owtf/pull/555) ([DoomTaper](https://github.com/DoomTaper))
- Closes issue \#448 regarding owtf cloning in windows [\#554](https://github.com/owtf/owtf/pull/554) ([DarKnight--](https://github.com/DarKnight--))
- Fixes \#304 [\#553](https://github.com/owtf/owtf/pull/553) ([DarKnight--](https://github.com/DarKnight--))
- Adding pref.sh from master to develop branch [\#552](https://github.com/owtf/owtf/pull/552) ([C0smos](https://github.com/C0smos))
- added missing exception [\#549](https://github.com/owtf/owtf/pull/549) ([DarKnight--](https://github.com/DarKnight--))
- Fixes worker and work deadlock. Resolves \#527 [\#548](https://github.com/owtf/owtf/pull/548) ([delta24](https://github.com/delta24))
- Fixed empty folder issue during installation \#544 [\#546](https://github.com/owtf/owtf/pull/546) ([DarKnight--](https://github.com/DarKnight--))
- Added metagoofil in install.sh for Kali [\#543](https://github.com/owtf/owtf/pull/543) ([DarKnight--](https://github.com/DarKnight--))
- Perform "apt-get update" before install packages. Resolves \#540 [\#541](https://github.com/owtf/owtf/pull/541) ([dougmorato](https://github.com/dougmorato))
- Allow the install to proceed is user is root [\#539](https://github.com/owtf/owtf/pull/539) ([dougmorato](https://github.com/dougmorato))
- added check for kali linux block to run only if distro is kali [\#537](https://github.com/owtf/owtf/pull/537) ([anantshri](https://github.com/anantshri))
- moving distro independent stuff above distro specific installs [\#536](https://github.com/owtf/owtf/pull/536) ([anantshri](https://github.com/anantshri))
- wget retires limit [\#535](https://github.com/owtf/owtf/pull/535) ([anantshri](https://github.com/anantshri))
- Fixes the Plugin: Spiders Robots And Crawlers \(issue \#515\) [\#532](https://github.com/owtf/owtf/pull/532) ([DoomTaper](https://github.com/DoomTaper))
- Fix issue \#412 [\#522](https://github.com/owtf/owtf/pull/522) ([arunk-s](https://github.com/arunk-s))
- Fix space checker error when response is not valid [\#518](https://github.com/owtf/owtf/pull/518) ([alexandrasandulescu](https://github.com/alexandrasandulescu))
- Remove license text from sources [\#511](https://github.com/owtf/owtf/pull/511) ([alexandrasandulescu](https://github.com/alexandrasandulescu))
- Add aptitude wrapper support for kali script [\#508](https://github.com/owtf/owtf/pull/508) ([alexandrasandulescu](https://github.com/alexandrasandulescu))
- Download cms explorer sources outside the script [\#507](https://github.com/owtf/owtf/pull/507) ([alexandrasandulescu](https://github.com/alexandrasandulescu))
- Remove zest jars installer script [\#505](https://github.com/owtf/owtf/pull/505) ([alexandrasandulescu](https://github.com/alexandrasandulescu))
- Add available space checking mechanism [\#504](https://github.com/owtf/owtf/pull/504) ([alexandrasandulescu](https://github.com/alexandrasandulescu))
- Replace msfcli with msfconsole [\#502](https://github.com/owtf/owtf/pull/502) ([alexandrasandulescu](https://github.com/alexandrasandulescu))
- Upgrade default python setuptools package to v18.1 [\#501](https://github.com/owtf/owtf/pull/501) ([alexandrasandulescu](https://github.com/alexandrasandulescu))
- Fix string comparison issue in db\_config\_setup.sh [\#500](https://github.com/owtf/owtf/pull/500) ([alexandrasandulescu](https://github.com/alexandrasandulescu))
- edited "unable add" to "unable to add" [\#498](https://github.com/owtf/owtf/pull/498) ([DoomTaper](https://github.com/DoomTaper))
- Add parameter --cfg-only to skip postgres setup [\#495](https://github.com/owtf/owtf/pull/495) ([alexandrasandulescu](https://github.com/alexandrasandulescu))
- Fix binding address for FILE\_SERVER\_PORT [\#493](https://github.com/owtf/owtf/pull/493) ([alexandrasandulescu](https://github.com/alexandrasandulescu))
- Add --no-user-input and --core-only command line arguments to install… [\#492](https://github.com/owtf/owtf/pull/492) ([alexandrasandulescu](https://github.com/alexandrasandulescu))
- OWTF AUR package [\#490](https://github.com/owtf/owtf/pull/490) ([alexandrasandulescu](https://github.com/alexandrasandulescu))
- Extend dependency check for modules installed via package manager [\#489](https://github.com/owtf/owtf/pull/489) ([alexandrasandulescu](https://github.com/alexandrasandulescu))
- Distro independent PostgreSQL daemon start [\#488](https://github.com/owtf/owtf/pull/488) ([alexandrasandulescu](https://github.com/alexandrasandulescu))
- Add db config file path parameter for scripts/db\_run.sh [\#487](https://github.com/owtf/owtf/pull/487) ([alexandrasandulescu](https://github.com/alexandrasandulescu))
- Check access rights for OUTPUT\_PATH [\#486](https://github.com/owtf/owtf/pull/486) ([alexandrasandulescu](https://github.com/alexandrasandulescu))
- Fixed minor typos [\#484](https://github.com/owtf/owtf/pull/484) ([MarkVLK](https://github.com/MarkVLK))
- Remove user input for distro detection [\#480](https://github.com/owtf/owtf/pull/480) ([alexandrasandulescu](https://github.com/alexandrasandulescu))
- New vulnerability search resources [\#460](https://github.com/owtf/owtf/pull/460) ([gameFace22](https://github.com/gameFace22))
-  Added O-saft tool to Testing for ssl-tls plugin in active category [\#411](https://github.com/owtf/owtf/pull/411) ([Ahiknsr](https://github.com/Ahiknsr))
- /ui/targets/ Add Targets area made more responsive and inline. Input are... [\#408](https://github.com/owtf/owtf/pull/408) ([jherrlin](https://github.com/jherrlin))
- fixed \#359 [\#392](https://github.com/owtf/owtf/pull/392) ([Ahiknsr](https://github.com/Ahiknsr))
- New vulnerability search resources [\#356](https://github.com/owtf/owtf/pull/356) ([gameFace22](https://github.com/gameFace22))


## [v1.0.1](https://github.com/owtf/owtf/tree/v1.0.1) (CHANGLOG2.md)
[Full Changelog](https://github.com/owtf/owtf/compare/v1.0...v1.0.1)

**Implemented enhancements:**

- lbd updated in Kali repos [\#342](https://github.com/owtf/owtf/issues/342)

**Fixed bugs:**

- Six=\>1.4.1 on Kali 1.0.9 x86\_64 [\#332](https://github.com/owtf/owtf/issues/332)

**Closed issues:**

- Botnet mode crashing when importing lists with no alive proxies [\#343](https://github.com/owtf/owtf/issues/343)
- Windows 8.1 Git checkout not working [\#341](https://github.com/owtf/owtf/issues/341)
- 404 on /ui/worklist links [\#338](https://github.com/owtf/owtf/issues/338)
- Please don't encourage users to wget and execute arbitrary code [\#333](https://github.com/owtf/owtf/issues/333)

## [v1.0](https://github.com/owtf/owtf/tree/v1.0) (CHANGLOG2.md)
[Full Changelog](https://github.com/owtf/owtf/compare/v0.45.0_Winter_Blizzard...v1.0)

**Implemented enhancements:**

- Make the db configuration simpler [\#326](https://github.com/owtf/owtf/issues/326)
- Adding target error [\#323](https://github.com/owtf/owtf/issues/323)
- kali linux importError no module named tornado.httpserver [\#321](https://github.com/owtf/owtf/issues/321)
- Change all target attributes to lower case [\#314](https://github.com/owtf/owtf/issues/314)
- \[DB\] \(OperationalError\) FATAL:  password authentication failed [\#312](https://github.com/owtf/owtf/issues/312)
- \[db\] Shift to postgres needed [\#297](https://github.com/owtf/owtf/issues/297)
- Display transactions interactively [\#288](https://github.com/owtf/owtf/issues/288)
- Option to select/launch all the plugins at once [\#266](https://github.com/owtf/owtf/issues/266)
- \[lions\_2014\] Skipfish is slow as hell with proxyfication [\#253](https://github.com/owtf/owtf/issues/253)
- Installing issue if python-pip package is not found [\#244](https://github.com/owtf/owtf/issues/244)
- Permission Issue \(UI branch\) [\#242](https://github.com/owtf/owtf/issues/242)
- passive search for defacements [\#212](https://github.com/owtf/owtf/issues/212)
- Improvise grep plugins [\#157](https://github.com/owtf/owtf/issues/157)
- Do not run metagoofil search engine functionality against local RFC1918 IP addresses [\#154](https://github.com/owtf/owtf/issues/154)
- lbd using wrong port to detect load-balancer? [\#150](https://github.com/owtf/owtf/issues/150)
- Grep plugin to search for URLs in transaction db \(response bodies\) [\#140](https://github.com/owtf/owtf/issues/140)
- Increase in output verbosity [\#138](https://github.com/owtf/owtf/issues/138)
- Use of databases in OWTF [\#105](https://github.com/owtf/owtf/issues/105)
- "Adding new URL to potential DB:" is too slow, also vetting the URL later [\#102](https://github.com/owtf/owtf/issues/102)
- different IPs for same hostname [\#87](https://github.com/owtf/owtf/issues/87)
- Click flow improvements [\#80](https://github.com/owtf/owtf/issues/80)
- Poor command line feedback [\#77](https://github.com/owtf/owtf/issues/77)
- New HTTP methods grep plugin and improving CORS plugin [\#67](https://github.com/owtf/owtf/issues/67)
- Improvement to passive plugins [\#63](https://github.com/owtf/owtf/issues/63)
- Grep plugins command limitations [\#12](https://github.com/owtf/owtf/issues/12)
- PHP Source detection approach [\#11](https://github.com/owtf/owtf/issues/11)

**Fixed bugs:**

- HTML Injection [\#325](https://github.com/owtf/owtf/issues/325)
- Workers problem [\#324](https://github.com/owtf/owtf/issues/324)
- OWTFSession manager interface bug [\#313](https://github.com/owtf/owtf/issues/313)
- FileLock Exception when accessing a target report [\#309](https://github.com/owtf/owtf/issues/309)
- Proxychains config textbox should be multiline [\#308](https://github.com/owtf/owtf/issues/308)
- Add Target small UI improvement [\#307](https://github.com/owtf/owtf/issues/307)
- Workers are not sharing the plugin load [\#305](https://github.com/owtf/owtf/issues/305)
- \[lions\_2014\] Plugins' results not shown in the report. [\#294](https://github.com/owtf/owtf/issues/294)
- \[ui\] Plugin launcher bugs [\#289](https://github.com/owtf/owtf/issues/289)
- Bugs with Nikto active plugin [\#277](https://github.com/owtf/owtf/issues/277)
- Error in transaction logger [\#267](https://github.com/owtf/owtf/issues/267)
- The resource type: 'WEBAPPFINGERPRINT' is not defined on '/root/owtf/profiles/resources/default.cfg' [\#261](https://github.com/owtf/owtf/issues/261)
- PTES-008 HTTP\_RPC\_PORT\_NUMBER is missing in default.cfg [\#258](https://github.com/owtf/owtf/issues/258)
- PTES-005 EMC\_PORT\_NUMBER is missing in default.cfg [\#257](https://github.com/owtf/owtf/issues/257)
- \[lions\_2014\] OWTF aborts when a wrong hostname is specified as a target [\#255](https://github.com/owtf/owtf/issues/255)
- \[lions\_2014\] UnicodeDecodeError in `core.outputfunc` [\#252](https://github.com/owtf/owtf/issues/252)
- Bug in DirBuster parser [\#229](https://github.com/owtf/owtf/issues/229)
- \[lions\_2014\] PTES-006 Invalid RPORT [\#227](https://github.com/owtf/owtf/issues/227)
- \[lions\_2014\] W3AF is pending forever if run for the first time [\#225](https://github.com/owtf/owtf/issues/225)
- UI branch bugs [\#221](https://github.com/owtf/owtf/issues/221)
- Outstanding reporting bugs [\#216](https://github.com/owtf/owtf/issues/216)
- \[Auto-Generated\]  Plugin grep/Application\_Configuration\_Management@OWASP-CM-004.py failed for target http://some.target.com [\#178](https://github.com/owtf/owtf/issues/178)
- Do not run metagoofil search engine functionality against local RFC1918 IP addresses [\#154](https://github.com/owtf/owtf/issues/154)
- Plugin active/Testing\_for\_SSL-TLS@OWASP-CM-001.py failed for target https://some.target.com [\#145](https://github.com/owtf/owtf/issues/145)
- CPU spike when opening a 94 url partial report \(just the home page!\) [\#100](https://github.com/owtf/owtf/issues/100)
- Multiprocessing cpu spikes on multi-target scan [\#99](https://github.com/owtf/owtf/issues/99)
- multiprocessing bug with stack trace .. [\#98](https://github.com/owtf/owtf/issues/98)
- different IPs for same hostname [\#87](https://github.com/owtf/owtf/issues/87)
- Poor command line feedback [\#77](https://github.com/owtf/owtf/issues/77)
- SSI grep plugin bug + passive plugin request [\#61](https://github.com/owtf/owtf/issues/61)

**Closed issues:**

- pycurl dependency [\#330](https://github.com/owtf/owtf/issues/330)
- \[Auto-Generated\]  Plugin grep/Application\_Configuration\_Management@OWASP-CM-004.py failed for target http://some.target.com [\#327](https://github.com/owtf/owtf/issues/327)
- Date format fails on target report. [\#315](https://github.com/owtf/owtf/issues/315)
- \[Auto-Generated\]  Plugin grep/Logout\_and\_Browser\_Cache\_Management@OWASP-AT-007.py failed for target http://some.target.com [\#302](https://github.com/owtf/owtf/issues/302)
- \[Auto-Generated\]  Plugin semi\_passive/Search\_engine\_discovery\_reconnaissance@OWASP-IG-002.py failed for target http://some.target.com:81 [\#301](https://github.com/owtf/owtf/issues/301)
- \[Auto-Generated\]  Plugin grep/Application\_Configuration\_Management@OWASP-CM-004.py failed for target http://some.target.com [\#298](https://github.com/owtf/owtf/issues/298)
- Hardcore Multiprocessing Bug [\#296](https://github.com/owtf/owtf/issues/296)
- \[Auto-Generated\]  Plugin semi\_passive/Search\_engine\_discovery\_reconnaissance@OWASP-IG-002.py failed for target http://some.target.com [\#292](https://github.com/owtf/owtf/issues/292)
- \[Auto-Generated\]  Minor issue: File not found: DirBuster is not a valid URL and has been ignored, processing continues [\#291](https://github.com/owtf/owtf/issues/291)
- \[Auto-Generated\]  Plugin active/HTTP\_Methods\_and\_XST@OWASP-CM-008.py failed for target http://some.target.com/xss.php [\#290](https://github.com/owtf/owtf/issues/290)
- \#248 [\#286](https://github.com/owtf/owtf/issues/286)
- \[Auto-Generated\]  Plugin active/HTTP\_Methods\_and\_XST@OWASP-CM-008.py failed for target http://some.target.com [\#285](https://github.com/owtf/owtf/issues/285)
- WARNING!: No Plugin found for: {'Type': 'bruteforce', 'Group': 'net', 'File': 'domain@PTES-011.py'} [\#284](https://github.com/owtf/owtf/issues/284)
- \[Auto-Generated\]  Plugin semi\_passive/Search\_engine\_discovery\_reconnaissance@OWASP-IG-002.py failed for target http://some.target.com [\#283](https://github.com/owtf/owtf/issues/283)
- \[Auto-Generated\]  Plugin grep/Application\_Configuration\_Management@OWASP-CM-004.py failed for target http://some.target.com [\#282](https://github.com/owtf/owtf/issues/282)
- \[Auto-Generated\]  Unknown owtf error [\#281](https://github.com/owtf/owtf/issues/281)
- \[Critical\] Plugin report is not loading ! [\#280](https://github.com/owtf/owtf/issues/280)
- \[Auto-Generated\]  Minor issue: File not found: hoppy.summary is not a valid URL and has been ignored, processing continues [\#279](https://github.com/owtf/owtf/issues/279)
- \[Auto-Generated\]  DB.Search ERROR: The offset 'URL' is undefined! NAME\_TO\_OFFSET={u'Status': 4, u'URL': 6, u'Method': 5, u'TimeHuman': 3, u'Time': 2, u'Scope': 1, u'Data': 7, u'ID': 0}, Record=\['X-CRLF-Safe-b1f1e9c37006298dc344a71fbee5819d64bd29e8250deb1bab69b23f7f44c5b1:+no%00&username=admin'\] [\#278](https://github.com/owtf/owtf/issues/278)
- \[Auto-Generated\]  Plugin semi\_passive/Search\_engine\_discovery\_reconnaissance@OWASP-IG-002.py failed for target http://some.target.com [\#276](https://github.com/owtf/owtf/issues/276)
- \[Auto-Generated\]  Plugin semi\_passive/HTTP\_Methods\_and\_XST@OWASP-CM-008.py failed for target http://some.target.com [\#274](https://github.com/owtf/owtf/issues/274)
- \[Auto-Generated\]  Plugin semi\_passive/Search\_engine\_discovery\_reconnaissance@OWASP-IG-002.py failed for target http://some.target.com [\#273](https://github.com/owtf/owtf/issues/273)
- \[Auto-Generated\]  Plugin semi\_passive/Search\_engine\_discovery\_reconnaissance@OWASP-IG-002.py failed for target http://some.target.com [\#269](https://github.com/owtf/owtf/issues/269)
- \[Auto-Generated\]  Plugin passive/Spiders\_Robots\_and\_Crawlers@OWASP-IG-001.py failed for target http://some.target.com [\#268](https://github.com/owtf/owtf/issues/268)
- \[Auto-Generated\]  Plugin semi\_passive/Spiders\_Robots\_and\_Crawlers@OWASP-IG-001.py failed for target http://some.target.com [\#265](https://github.com/owtf/owtf/issues/265)
- \[Auto-Generated\]  Minor issue: File not found: hoppy.summary is not a valid URL and has been ignored, processing continues [\#263](https://github.com/owtf/owtf/issues/263)
- \[Auto-Generated\]  Plugin grep/Application\_Configuration\_Management@OWASP-CM-004.py failed for target https://some.target.com [\#260](https://github.com/owtf/owtf/issues/260)
- \[Auto-Generated\]  Plugin active/HTTP\_Methods\_and\_XST@OWASP-CM-008.py failed for target https://some.target.com/register/clogin.php?cb=1 [\#254](https://github.com/owtf/owtf/issues/254)
- \[Auto-Generated\]  Unknown owtf error [\#247](https://github.com/owtf/owtf/issues/247)
- \[Auto-Generated\]  Plugin grep/Application\_Configuration\_Management@OWASP-CM-004.py failed for target https://some.target.com [\#246](https://github.com/owtf/owtf/issues/246)
- \[Auto-Generated\]  Plugin grep/Application\_Configuration\_Management@OWASP-CM-004.py failed for target https://some.target.com [\#245](https://github.com/owtf/owtf/issues/245)
- \[Auto-Generated\]  Minor issue: Jun,::PMorg.apache.commons.httpclient.HttpMethodDirectorexecuteWithRetry is not a valid URL and has been ignored, processing continues [\#241](https://github.com/owtf/owtf/issues/241)
- \[Auto-Generated\]  Minor issue: org.apache.commons.httpclient.NoHttpResponseException:Theserversome.target.comfailedtorespond is not a valid URL and has been ignored, processing continues [\#240](https://github.com/owtf/owtf/issues/240)
- BUG:WARNING: Tool path not found for: /root/owtf/tools/restricted/hoppy-1.8.1/hoppy-1.8.1 [\#239](https://github.com/owtf/owtf/issues/239)
- \[Auto-Generated\]  Plugin semi\_passive/HTTP\_Methods\_and\_XST@OWASP-CM-008.py failed for target http://some.target.com [\#238](https://github.com/owtf/owtf/issues/238)
- \[Auto-Generated\]  Minor issue: File not found: hoppy.summary is not a valid URL and has been ignored, processing continues [\#237](https://github.com/owtf/owtf/issues/237)
- \[Auto-Generated\]  Plugin semi\_passive/Web\_Application\_Fingerprint@OWASP-IG-004.py failed for target http://some.target.com [\#236](https://github.com/owtf/owtf/issues/236)
- \[Auto-Generated\]  Plugin semi\_passive/Spiders\_Robots\_and\_Crawlers@OWASP-IG-001.py failed for target http://some.target.com [\#235](https://github.com/owtf/owtf/issues/235)
- \[Auto-Generated\]  Plugin passive/Spiders\_Robots\_and\_Crawlers@OWASP-IG-001.py failed for target http://some.target.com [\#234](https://github.com/owtf/owtf/issues/234)
- \[Auto-Generated\]  Plugin semi\_passive/Spiders\_Robots\_and\_Crawlers@OWASP-IG-001.py failed for target http://some.target.com [\#233](https://github.com/owtf/owtf/issues/233)
- \[Auto-Generated\]  Plugin grep/Application\_Configuration\_Management@OWASP-CM-004.py failed for target http://some.target.com [\#232](https://github.com/owtf/owtf/issues/232)
- \[Auto-Generated\]  Plugin grep/Application\_Configuration\_Management@OWASP-CM-004.py failed for target http://some.target.com [\#231](https://github.com/owtf/owtf/issues/231)
- \[Auto-Generated\]  Plugin grep/Logout\_and\_Browser\_Cache\_Management@OWASP-AT-007.py failed for target http://some.target.com [\#230](https://github.com/owtf/owtf/issues/230)
- \[Auto-Generated\]  Minor issue: File not found: hoppy.summary is not a valid URL and has been ignored, processing continues [\#220](https://github.com/owtf/owtf/issues/220)
- \[Auto-Generated\]  Plugin semi\_passive/Web\_Application\_Fingerprint@OWASP-IG-004.py failed for target http://some.target.com [\#219](https://github.com/owtf/owtf/issues/219)
- Convert \*\*external\*\* plugins to new UI plugin standard [\#218](https://github.com/owtf/owtf/issues/218)
- \[Auto-Generated\]  Plugin grep/Application\_Configuration\_Management@OWASP-CM-004.py failed for target http://some.target.com [\#213](https://github.com/owtf/owtf/issues/213)
- \[Auto-Generated\]  Minor issue: File not found: hoppy.summary is not a valid URL and has been ignored, processing continues [\#205](https://github.com/owtf/owtf/issues/205)
- \[Auto-Generated\]  Plugin semi\_passive/Testing\_for\_Cross\_site\_flashing@OWASP-DV-004.py failed for target http://some.target.com [\#203](https://github.com/owtf/owtf/issues/203)
- \[Auto-Generated\] Bug report from OWTF [\#201](https://github.com/owtf/owtf/issues/201)
- \[Auto-Generated\] Bug report from OWTF [\#200](https://github.com/owtf/owtf/issues/200)
- \[Auto-Generated\]  DB.Search ERROR: The offset 'URL' is undefined! NAME\_TO\_OFFSET={u'Status': 4, u'URL': 6, u'Method': 5, u'TimeHuman': 3, u'Time': 2, u'Scope': 1, u'Data': 7, u'ID': 0}, Record=\['googpub-phish-shavar;a:272920-281375:s:15688-16644:mac'\] [\#199](https://github.com/owtf/owtf/issues/199)
- \[Auto-Generated\]  Minor issue: File not found: hoppy.summary is not a valid URL and has been ignored, processing continues [\#195](https://github.com/owtf/owtf/issues/195)
- Multiple Installation Bugs [\#194](https://github.com/owtf/owtf/issues/194)
- Installation bug "pybloomfiltermmap" [\#193](https://github.com/owtf/owtf/issues/193)
- \[Auto-Generated\]  Plugin grep/Testing\_for\_SQL\_Injection@OWASP-DV-005.py failed for target http://some.target.com [\#189](https://github.com/owtf/owtf/issues/189)
- \[Auto-Generated\]  Minor issue: File not found: hoppy.summary is not a valid URL and has been ignored, processing continues [\#188](https://github.com/owtf/owtf/issues/188)
- \[Auto-Generated\]  Plugin grep/Testing\_for\_SQL\_Error\_Messages@OWASP-DIV-005.py failed for target http://some.target.com [\#187](https://github.com/owtf/owtf/issues/187)
- \[Auto-Generated\]  Plugin grep/Testing\_for\_SQL\_Error\_Messages@OWASP-DIV-005.py failed for target http://some.target.com [\#186](https://github.com/owtf/owtf/issues/186)
- \[Auto-Generated\]  Plugin semi\_passive/Search\_engine\_discovery\_reconnaissance@OWASP-IG-002.py failed for target http://some.target.com [\#185](https://github.com/owtf/owtf/issues/185)
- Plug-n-Hack configuration failed [\#183](https://github.com/owtf/owtf/issues/183)
- Add GitHub username to the auto-generated report [\#180](https://github.com/owtf/owtf/issues/180)
- \[Auto-Generated\]  Minor issue: File not found: hoppy.summary is not a valid URL and has been ignored, processing continues [\#179](https://github.com/owtf/owtf/issues/179)
- \[Auto-Generated\]  Unknown owtf error [\#177](https://github.com/owtf/owtf/issues/177)
- \[Auto-Generated\]  Unknown owtf error [\#176](https://github.com/owtf/owtf/issues/176)
- \[Auto-Generated\]  Unknown owtf error [\#175](https://github.com/owtf/owtf/issues/175)
- \[Auto-Generated\]  Unknown owtf error [\#174](https://github.com/owtf/owtf/issues/174)
- \[Auto-Generated\]  Unknown owtf error [\#173](https://github.com/owtf/owtf/issues/173)
- \[\*\] Aborted by Framework: Files required for SSL MiTM are missing. Please run the install script.  [\#172](https://github.com/owtf/owtf/issues/172)
- OWASP "Dependency Check" Project integration [\#168](https://github.com/owtf/owtf/issues/168)
- w3af run error [\#167](https://github.com/owtf/owtf/issues/167)
- plugin output not found [\#166](https://github.com/owtf/owtf/issues/166)
- \[Auto-Generated\]  Plugin external/Application\_Discovery@OWASP-IG-005.py failed for target http://some.target.com [\#163](https://github.com/owtf/owtf/issues/163)
- Aborted by Framework: Files required for SSL MiTM are missing [\#161](https://github.com/owtf/owtf/issues/161)
- Grep plugin for SQL Error messages [\#156](https://github.com/owtf/owtf/issues/156)
- Exception while running in Eclipse [\#152](https://github.com/owtf/owtf/issues/152)
- MiTM proxy issue [\#147](https://github.com/owtf/owtf/issues/147)
- Error: libcurl link-time ssl backend \(gnutls\) is different from compile-time ssl backend \(none/other\) [\#141](https://github.com/owtf/owtf/issues/141)
- Add Panoptic to the arsenal [\#139](https://github.com/owtf/owtf/issues/139)
- IndexError: list index out of range [\#137](https://github.com/owtf/owtf/issues/137)
- Unknown and DB related errors [\#136](https://github.com/owtf/owtf/issues/136)
- Welcome in OWTF with error [\#135](https://github.com/owtf/owtf/issues/135)
- ImportError causes traceback [\#134](https://github.com/owtf/owtf/issues/134)
- Invalid input on distribution number causes stack trace in installation script [\#133](https://github.com/owtf/owtf/issues/133)
- NIST 800-53 mapping [\#113](https://github.com/owtf/owtf/issues/113)
- Coordinate integration into Samurai WTF [\#92](https://github.com/owtf/owtf/issues/92)
- Potential CLI improvement htop style [\#79](https://github.com/owtf/owtf/issues/79)
- scripts Integration with OpenVAS \(feature\) [\#55](https://github.com/owtf/owtf/issues/55)
- Adding a dnsspider to tools [\#43](https://github.com/owtf/owtf/issues/43)

**Merged pull requests:**

- Permition fix in joining paths [\#251](https://github.com/owtf/owtf/pull/251) ([marioskourtesis](https://github.com/marioskourtesis))
- Permissions Fix. Now OWTF can run as non root user. [\#250](https://github.com/owtf/owtf/pull/250) ([marioskourtesis](https://github.com/marioskourtesis))
- \[pip\] Update the list of dependencies. [\#210](https://github.com/owtf/owtf/pull/210) ([DePierre](https://github.com/DePierre))
- \[plugin\] Use imp module in order to retrieve info [\#209](https://github.com/owtf/owtf/pull/209) ([DePierre](https://github.com/DePierre))
- \[plugin\] Fix typo [\#208](https://github.com/owtf/owtf/pull/208) ([DePierre](https://github.com/DePierre))
- \[core\] Fix internal IPv4 detection \(related to \#37\)  [\#198](https://github.com/owtf/owtf/pull/198) ([DePierre](https://github.com/DePierre))
- Kali Installation bug fixes [\#197](https://github.com/owtf/owtf/pull/197) ([marioskourtesis](https://github.com/marioskourtesis))
- OWASP-DV-005 plugin for SQL Injection [\#196](https://github.com/owtf/owtf/pull/196) ([ner0x652](https://github.com/ner0x652))
- Fix a typo in the README [\#190](https://github.com/owtf/owtf/pull/190) ([DePierre](https://github.com/DePierre))
- Addition of GitHub username to the auto-generated bug report [\#181](https://github.com/owtf/owtf/pull/181) ([delta24](https://github.com/delta24))
- Remove old reference to kali\_install.sh [\#171](https://github.com/owtf/owtf/pull/171) ([DePierre](https://github.com/DePierre))
- OWASP Dependency check has been added as an external plugin. [\#169](https://github.com/owtf/owtf/pull/169) ([a0xnirudh](https://github.com/a0xnirudh))
- Added a new tool Panoptic for testing Local File Inclusion vulnerability scanning [\#162](https://github.com/owtf/owtf/pull/162) ([a0xnirudh](https://github.com/a0xnirudh))
- Change print and except usages for python3 compatibility in owtf.py [\#160](https://github.com/owtf/owtf/pull/160) ([DePierre](https://github.com/DePierre))
- \[config\] Fix pep8 for health\_check [\#158](https://github.com/owtf/owtf/pull/158) ([DePierre](https://github.com/DePierre))
- Integrated  OWTF into Samurai-WTF  [\#155](https://github.com/owtf/owtf/pull/155) ([delta24](https://github.com/delta24))
- Update ProcessManager.py [\#153](https://github.com/owtf/owtf/pull/153) ([dscarson](https://github.com/dscarson))
- Botnet-mode [\#151](https://github.com/owtf/owtf/pull/151) ([marioskourtesis](https://github.com/marioskourtesis))
- default.cfg changed in web\_plugin\_order [\#144](https://github.com/owtf/owtf/pull/144) ([Sentient07](https://github.com/Sentient07))
- Edited Google Search for displaying the websites prone to SSI Injection [\#143](https://github.com/owtf/owtf/pull/143) ([Sentient07](https://github.com/Sentient07))
- OpenVAS web plugin [\#142](https://github.com/owtf/owtf/pull/142) ([dscarson](https://github.com/dscarson))



14/01/2014 - 0.45.0 "Winter Blizzard" alpha release: Dedicated to Alessandro Fanio Gonzalez (@alessandrofg), Ankush Jindal (@ankushjindal278), Assem Chelli (@assem-ch), Bharadwaj Machiraju (@tunnelshade), Marios Kourtesis (@marioskourtesis) & their mentors:  Andrés Morales, Andrés Riancho,  Gareth Heyes,  Krzysztof Kotowicz, and their co-mentors: Abraham Aranguren, Azeddine Islam Mennouchi,  Hani Benhabiles, Javier Marcos de Prado,  Johanna Curiel,  Martin Johns.
+ New Feature: OWTF can now be updated using a command line flag <=> Bharadwaj Machiraju (@tunnelshade)
+ Added and fixed some tests for plugins <=> Alessandro Fanio Gonzalez (@alessandrofg)
+ New Feature: Few tools are proxified through OWTF inbound proxy <=> Bharadwaj Machiraju (@tunnelshade)
+ New Feature: Httprint signatures updated (still updating) <=> Azeddine Islam Mennouchi
+ New Feature: Plug-n-Hack Phase I implemented in OWTF <=> Bharadwaj Machiraju (@tunnelshade)
+ Travis CI service is under usage for tests <=> Alessandro Fanio Gonzalez (@alessandrofg)
+ New Feature: OWTF Inbound proxy is made capable of websocket traffic proxying <=> Bharadwaj Machiraju (@tunnelshade)
+ New Feature: HTTP AUTH support is implemented in OWTF Inbound proxy <=> Bharadwaj Machiraju (@tunnelshade)
+ Enhancement: Spiders, Robots and Crawlers grep plugin added <=> Bharadwaj Machiraju (@tunnelshade)
+ Enhancement: Web Services passive discovery plugin improved <=> Bharadwaj Machiraju (@tunnelshade)
+ New Feature: User can run multiple instances of OWTF <=> Bharadwaj Machiraju (@tunnelshade)
+ New Feature: Outbound socks proxy support implemented <=> Marios Kourtesis (@marioskourtesis)
+ New Tool: Added nmap to WAF checks <=> Abraham Aranguren (@7a_)
+ New Feature: Tor mode added to OWTF <=> Marios Kourtesis (@marioskourtesis)
+ New Feature: New Installation procedure added to OWTF <=> Bharadwaj Machiraju (@tunnelshade)
+ 40+ Bug fixes

09/08/2013 - 0.30 "Summer Storm II" alpha release: Dedicated to  Alessandro Fanio Gonzalez (@alessandrofg), Ankush Jindal (@ankushjindal278), Assem Chelli (@assem-ch), Bharadwaj Machiraju (@tunnelshade), their mentors:  Andrés Morales, Andrés Riancho,  Gareth Heyes,  Krzysztof Kotowicz, and their co-mentors: Abraham Aranguren, Azeddine Islam Mennouchi,  Hani Benhabiles, Javier Marcos de Prado,  Johanna Curiel,  Martin Johns.
+ Extracting the HTML generated by the reporting system from Python modules into independent Jinja2 template files <=> Assem Chelli (@assem-ch)
+ Added some features to the Testing Framework. Added tests that cover approximately the 45% of the code of the OWTF Framework. <=> Alessandro Fanio Gonzalez (@alessandrofg)
+ Added support for test coverage reports and test logs in HTML. <=> Alessandro Fanio Gonzalez (@alessandrofg)
+ Spawing multiple processes on the basis of targets and then handling the input, stopping of the targets <=> Ankush Jindal(@ankushjindal278)
+ Centralised log function <=> Ankush Jindal(@ankushjindal278)
+ Generic messaging system with pull and push facility differently and database handler to use messaging for DB transaction in multiprocessing<=> (@ankushjindal278)
+ Draft inbound proxy is replaced by a new inbound proxy <=> Bharadwaj Machiraju (@tunnelshade)
+ Inbound proxy is capable of caching and saving the transactions <=> Bharadwaj Machiraju (@tunnelshade)
+ Inbound proxy is capable of cookie filters. <=> Bharadwaj Machiraju (@tunnelshade)


28/06/2013 - 0.20 "Summer Storm I" alpha release: Dedicated to Alessandro Fanio Gonzalez (@alessandrofg), Ankush Jindal (@ankushjindal278), Assem Chelli (@assem-ch) and Bharadwaj Machiraju (@tunnelshade)
+ Port of Abraham Aranguren's network security OSCP scripts into OWASP OWTF <=> Ankush Jindal (@ankushjindal278) 
+ Fixed a small bug in the calling of metagoofil, thanks to Adi Mutu (@an_animal) for reporting <=> Bharadwaj Machiraju (@tunnelshade)
+ Added w3af and it's dependencies to install script <=> Bharadwaj Machiraju (@tunnelshade)
+ Fixed scripts/run_arachni.sh to save arachni output files into relevant owtf_review directory - https://github.com/owtf/owtf/issues/41 <=> Abraham Aranguren (@7a_)
+ Fixed release name in framework/config/framework_config.cfg <=> Abraham Aranguren (@7a_)
+ Fixed the installation of phply ( a dependency of w3af ) <=> Bharadwaj Machiraju (@tunnelshade)
+ Fixed most PEP standard warnings on owtf.py <=> Abraham Aranguren (@7a_)
+ Fixed most PEP standard warnings on framework/config/health_check.py <=> Abraham Aranguren (@7a_)
+ Minor README fix replacing references from backtrack to Kali <=> Abraham Aranguren (@7a_)
+ Added arachni to install script along with some minor fixes, thanks to @fataku for reporting <=> Bharadwaj Machiraju (@tunnelshade)
+ Fixed unicode urls for dirbuster combined dictionaries <=> Bharadwaj Machiraju (@tunnelshade)
+ Fixed ssl-cipher-check bug Issue - https://github.com/owtf/owtf/issues/38 <=> Abraham Aranguren (@7a_)

24/05/2013 - 0.16 "shady citizen" alpha release: Dedicated to Michael Kohl (@citizen428) and Bharadwaj Machiraju (@tunnelshade) for contributing to OWTF, thank you!
+ Created an alternative phishing3.2.2_listenerIP SET script directory to use in profiles/general/default.cfg: <=> Abraham Aranguren (@7a_)
  - The point of this is to be able to simply change the PHISHING_SCRIPT_DIR to use when SET adds an additional "ask listener IP" manual step (happens sometimes)
  - If SET stops asking the MSF listener IP then simply change PHISHING_SCRIPT_DIR back to phishing3.2.2 to use the correct scripts
+ Fixed legacy misspelled "phishing" typo bug around a few files <=> Abraham Aranguren (@7a_)
+ Added external links to assist Credential Transport vulnerability exploitation: SSLStrip, Firesheep, CookieCadger <=> Abraham Aranguren (@7a_)
+ Added external link to SpiderLabs' Blogpost: Adding Anti-CRSF support to Burp Intruder <=> Abraham Aranguren (@7a_)
+ Added Skipfish support via a new Skipfish plugin: Skipfish_Unauthenticated <=> Abraham Aranguren (@7a_)
+ Added Arachni v.0.4.1 support <=> Abraham Aranguren (@7a_)
+ Removed demos directory to place demos in a dedicated repository (https://github.com/owtf/owtf_demos) and keep the main owtf repository more lightweight <=> Abraham Aranguren (@7a_)
+ Removed releases directory to place demos in a dedicated repository (https://github.com/owtf/owtf_releases) and keep the main owtf repository more lightweight <=> Abraham Aranguren (@7a_)
+ Substituted getopt with argparse for argument parsing <=> Abraham Aranguren (@7a_)
+ Fixed www.company.com/subdir issue thanks to Adi Mutu (@an_animal) for reporting it and Bharadwaj Machiraju (@tunnelshade) for fixing it! - https://github.com/owtf/owtf/pull/15 <=> Bharadwaj Machiraju (@tunnelshade)
+ Fixed bug on draft Inbound proxy thanks to Bharadwaj Machiraju (@tunnelshade) for finding + fixing it! - https://github.com/owtf/owtf/pull/16 <=> Bharadwaj Machiraju (@tunnelshade)
+ Initial Kali Linux port (some tools still missing, the install script needs more work) thanks to Bharadwaj Machiraju (@tunnelshade) for a lot of help on this! <=> Bharadwaj Machiraju (@tunnelshade)
+ Fixed websecurify path, thanks to Anant Shrivastava (@anantshri) for finding and fixing the problem in a pull request! <=> Anant Shrivastava (@anantshri)
+ Kali Linux fix: Removed setrubyenv.sh from default.cfg resource configuration file due to no longer being necessary and because it was stopping execution of ruby tools <=> Abraham Aranguren (@7a_)
+ Improved exception handling in framework/http/requester.py to avoid crashing OWTF for small library things like 'raise BadStatusLine(line)' <=> Abraham Aranguren (@7a_)
+ Kali Linux fix: Fixed DirBuster path and centralised binary name on profiles/general/default.cfg <=> Abraham Aranguren (@7a_)
+ fixed minor pentesting vs. pen testing typo on owtf.py :) <=> Abraham Aranguren (@7a_)
+ Merged new pull request from Bharadwaj Machiraju (@tunnelshade): OWTF restricted dictionary installation and merging scripts thank you! <=> Bharadwaj Machiraju (@tunnelshade)
+ Minor improvements to pull request above after testing (linking raft files instead of copying again, fixing svndigger_raft_dict_merger.py permissions) <=> Abraham Aranguren (@7a_)
+ Added .project files in order to allow importing of OWTF project into Eclipse, revised readme/CONTRIBUTORS and a bug fix in owtf.py <=> Bharadwaj Machiraju (@tunnelshade)
+ Removing big-size binaries from the git repo and purge thier history in order to have a small repository <=> Assem Chelli (@assem-ch)
+ Fixed the plugin listing option. It is no longer necessary to specify a Target when listing plugins. <=> Alessandro Fanio Gonzalez (@alessandrofg)
+ Commented out TOOL_GOOHOST as it is not being called by OWTF (since there are better tools doing same job) <=> Bharadwaj Machiraju (@tunnelshade)
+ Revhosts is replaced by dnsrecon as revhosts is discontinued in kali linux. <=> Bharadwaj Machiraju (@tunnelshade)
+ httprint is added to install script as the tool is not present in kali by default <=> Bharadwaj Machiraju (@tunnelshade)
+ Added missing gnutls-bin package to Kali Linux script <=> Abraham Aranguren (@7a_)
+ Added wrapper install scripts around other install scripts and fixed cms-explorer installation & path <=> Bharadwaj Machiraju (@tunnelshade)
+ Fixed the dictionary path for skipfish <=> Bharadwaj Machiraju (@tunnelshade)
+ Created the AUTHORS file <=> Assem Chelli (@assem-ch)
+ Added script for patching Tlssled and revised master install script <=> Bharadwaj Machiraju (@tunnelshade)
+ Removed misleading note about argparse since owtf.py now uses this library <=> Abraham Aranguren (@7a_)
+ Added checks before installation of dictionaries and updated date for tlssled patch <=> Bharadwaj Machiraju (@tunnelshade)
+ Revised the extract_urls.sh to use DirBuster.txt instead of generated report and other minor fixes <=> Bharadwaj Machiraju (@tunnelshade)
+ Skipfish is now linked to from the report, this was the final step to solve https://github.com/owtf/owtf/issues/13 <=> Abraham Aranguren (@7a_)
+ Fixed a bug in invoking nikto (scripts/run_nikto.sh) <=> Bharadwaj Machiraju (@tunnelshade)

24/09/2012 - 0.15 "Brucon" pre-alpha release: Dedicated to Brucon (http://brucon.org), its organisers and attendants
+ Changed name to OWASP OWTF since this is an OWASP project now, thank you OWASP! - https://www.owasp.org/index.php/OWASP_OWTF <=> Abraham Aranguren (@7a_)
+ Bug fix: General clean-up of the bt5_install.sh script + OWTF's tool locations for a smoother install experience, thanks to Xavier Mertens (@xme) for reporting!  <=> Abraham Aranguren (@7a_)
+ Bug fix: Removed Slowloris download code from bt5_install.sh script since redistribution was allowed by RSnake and it's packaged with OWASP OWTF <=> Abraham Aranguren (@7a_)
+ Bug fix: Commented out whatweb download from bt5_install.sh since the Backtrack version is now stable, default config also points to Backtrack path now <=> Abraham Aranguren (@7a_)
+ Bug fix: requester.py was referencing "Core.mError" which could sometimes result in the following error: "AttributeError: Core instance has no attribute 'mError'" <=> Abraham Aranguren (@7a_)
+ New feature: Instead of having to use our own nikto binaries, the OWTF's install script will now patch's nikto's poor default user agent (blocked by basic WAF blacklists) <=> Abraham Aranguren (@7a_)
+ Added to Sandro Gauci's Webapp Exploit Payloads to the following external plugins: XSS, CSRF and Cross Site Flashing <=> Abraham Aranguren (@7a_)
+ Added cross-site flashing link to get swfdump from www.swftools.org <=> Abraham Aranguren (@7a_)
+ Added external plugin link to bAdmin project (from whitehat) for default admin interfaces passwords <=> Abraham Aranguren (@7a_)
+ Added xss external plugin link to Gareth's Heyes HackVertor <=> Abraham Aranguren (@7a_)
+ Added xss external plugin link to Mario Heiderich's html5sec.org <=> Abraham Aranguren (@7a_)
+ Changed default UA to a more believable FF15 <=> Abraham Aranguren (@7a_)
+ Added udl filetype to blanket google hacking searches (ica and rdp were already there), thanks to Chema Alonso (@chemaalonso)!  <=> Abraham Aranguren (@7a_)
+ Added external cross-site flashing link to Adobe's SWFInvestigator <=> Abraham Aranguren (@7a_)
+ Added external xss link to Krzysztof Kotowicz's Chrome extension exploitation framework (XSS ChEF) <=> Abraham Aranguren (@7a_)
+ Added external xss link to Michal Zalewski's post-XSS ideas on XSS exploitation <=> Abraham Aranguren (@7a_)
+ Added external session management schema link to .NET VIEWSTATE vulnerabilities blog post <=> Abraham Aranguren (@7a_)
+ Added external SQLi plugin link to InfoSec Institute's SQLi Backdoor creation article <=> Abraham Aranguren (@7a_)
+ Added external file extension handling + SQLi link to contagiodump.blogspot.com's Collection of Web Backdoors & Shells <=> Abraham Aranguren (@7a_)
+ Added external file extension handling + SQLi link to Laudanum's Project for shells and utilities <=> Abraham Aranguren (@7a_)
+ Added external Bypassing Authentication Schema plugin link to OWASP's Password Storage Cheat Sheet <=> Abraham Aranguren (@7a_)
+ Added external Clickjacking plugin link to OWASP's ClickJacking article <=> Abraham Aranguren (@7a_)
+ Added external Bypassing Authorisation Schema link to OWASP's Access Control Cheat Sheet <=> Abraham Aranguren (@7a_)
+ Added external plugin link to bAdmin project (from whitehat) for default or guessable user accounts plugin <=> Abraham Aranguren (@7a_)
+ Added external plugin link to OWASP's XSS Filter Evasion Cheat Sheet <=> Abraham Aranguren (@7a_)
+ Added external plugin link to OWASP's XSS Prevention Cheat Sheet <=> Abraham Aranguren (@7a_)
+ Added external plugin link to OWASP's DOM XSS Prevention Cheat Sheet <=> Abraham Aranguren (@7a_)
+ Added external plugin link to OWASP's Web Service Security Cheat Sheet <=> Abraham Aranguren (@7a_)
+ Added external plugin link to OWASP's Transport Layer Protection Cheat Sheet <=> Abraham Aranguren (@7a_)
+ Added external plugin link to OWASP's SQL Injection Prevention Cheat Sheet <=> Abraham Aranguren (@7a_)
+ Added external plugin link to OWASP's Query Parameterization Cheat Sheet (complements SQLi cheat sheet) <=> Abraham Aranguren (@7a_)
+ Added external plugin link to OWASP's Session Management Cheat Sheet <=> Abraham Aranguren (@7a_)
+ Added external plugin link to OWASP's Logging Cheat Sheet <=> Abraham Aranguren (@7a_)
+ Added external plugin link to OWASP's JAAS Authentication Cheat Sheet <=> Abraham Aranguren (@7a_)
+ Added external plugin link to OWASP's Forgot Password Cheat Sheet <=> Abraham Aranguren (@7a_)
+ Added external plugin link to OWASP's Cryptographic Storage Cheat Sheet <=> Abraham Aranguren (@7a_)
+ Added external plugin link to OWASP's Cross-Site Request Forgery (CSRF) Prevention Cheat Sheet <=> Abraham Aranguren (@7a_)
+ Added external plugin link to OWASP's Choosing and Using Security Questions Cheat Sheet <=> Abraham Aranguren (@7a_)
+ Added external plugin link to OWASP's Authentication Cheat Sheet <=> Abraham Aranguren (@7a_)

23/04/2012 - 0.14 "London" pre-alpha release: Dedicated to BSides London (http://www.securitybsides.org.uk/), its organisers and attendants
 + Fixed URL regexp on the link_clicker.py payload for the OWTF imap client Agent <=> Abraham Aranguren (@7a_)
   It was missing IP-only URLs like: http://192..., regexp changed to: 'http[:0-9a-zA-Z\.\/]+'
 + Upgraded SET spear phishing scripts from SET version 2.5.3 to SET version 3.2.2 <=> Abraham Aranguren (@7a_)
 + Bug fix: Added GetFileAsList and AppendToFile convenience functions (required by some existing code) <=> Abraham Aranguren (@7a_)
 + Added Version information at the bottom of the OWTF banner and arranged some loading messages to suit <=> Abraham Aranguren (@7a_)
 + Added GetCurrentDateTimeAsStr convenience method to the Timer class <=> Abraham Aranguren (@7a_)
 + Added SET script for new payload (19) <=> Abraham Aranguren (@7a_)
 + Replaced /etc/motd by new parameter WORD_TEMPLATE in SET payload script 3, and added parameter to Spear_Phishing plugin <=> Abraham Aranguren (@7a_)
 + Added better error handling to the Spear Phishing handler so that it aborts when a payload script is not found (instead of crashing in SET, after) <=> Abraham Aranguren (@7a_)
 + Fixed SET payload 15 to take advantage of the custom PDF template <=> Abraham Aranguren (@7a_)
 + Added a bit of SET's documentation to the readme directory <=> Abraham Aranguren (@7a_)
 + Commented out the Attachment name modification in the Spear Phishing plugin (sometimes you may want to control this from outside the plugin) <=> Abraham Aranguren (@7a_)
 + Added better exception handling to OWTF's SMTP class so that failure to perform the SMTP Login assumes open relay and moves on (also sent as a patch to SET) <=> Abraham Aranguren (@7a_)
 + Added slightly better message to OWTF's SMTP START TLS exception handling error message <=> Abraham Aranguren (@7a_)
 + Added warning to SET handler when sending blank values <=> Abraham Aranguren (@7a_)
 + Added check to Spear Phishing module to verify the word template exists <=> Abraham Aranguren (@7a_)
 + Improved exception handling on the SMTP class for Targeted Phishing, thanks Sam! <=> Abraham Aranguren (@7a_)

10/04/2012 - 0.13b "HackPra" pre-alpha release: Dedicated to HackPra (http://www.nds.rub.de/teaching/hackpra/), its organisers and attendants
 + Inclusion of slowloris, thanks to RSNake for allowing redistribution! <=> Abraham Aranguren (@7a_)

 + More indentation clean up in various files <=> Abraham Aranguren (@7a_)
 + Fixed bug on DeriveURLSettings: Thanks to Sandro Gauci for reporting!  <=> Abraham Aranguren (@7a_)
   The home-brew parsing was resulting in an error like below with URLs like http://example.com:81 
   "Aborted by Framework: Cannot resolve Hostname: example.com:81"
   URL parsing is now done via the urlparse library
 + Fixed bug introduced above whereby urlparse was returning "None" for the port in the summary report: <=> Abraham Aranguren (@7a_)
   Reintroduced scheme check to handle this case and ensure the port is never blank regardless of URL format
 + Fixed bug similar to the one in DeriveURLSettings on the OWTF Core: <=> Abraham Aranguren (@7a_)
   IsInScopeURL was parsing the hostname from the URL in a home-brew fashion this worked ok most of the time
   but in some cases could lead to bugs, core.py is now using urlparse for parsing the hostname from the URL
 + Added regression test shell scripts to tests directory <=> Abraham Aranguren (@7a_)

25/03/2012 - 0.13 "Trooper" pre-alpha release: Dedicated to Troopers (http://www.troopers.de/), its organisers and attendants
 + Inclusion of fuzzdb -allowed by licence- thanks! <=> Abraham Aranguren (@7a_)
 + Inclusion of HashCollision-DOS-POC by Christian Mehlmauer (@_FireFart_) thanks! <=> Abraham Aranguren (@7a_)
   Location: owtf_dir/tools/dos/web/HashCollision-DOS-POC
   More info: https://github.com/FireFart/HashCollision-DOS-POC
 + Installation script cleanup: tools/bt5_install.sh courtesy of Michael Kohl (@citizen428), thanks! <=> Michael Kohl (@citizen428)
 + Minor fixes to scripts/setrubyenv.sh also courtesy of Michael Kohl @citizen428), thanks! <=> Michael Kohl (@citizen428)
 + "set fuzzFormComboValues all" removed from scripts/run_w3af.sh because it may make w3af scans slow, thanks to Adi Mutu (am06) and Andrés Riancho (@w3af)! <=> Abraham Aranguren (@7a_)
   More info: http://sourceforge.net/mailarchive/forum.php?thread_name=CA%2B1Rt67bN3-2OpB%2B7SOGO7%3D92KWXBMdbaztpa885f%3Du2GzjcFg%40mail.gmail.com&forum_name=w3af-users
 + Created an initial basic targeted phishing plugin to send anything via SMTP: aux/se/Targeted_Phishing@OWTF-ASEP-002.py <=> Abraham Aranguren (@7a_)
 + Created the concept of "OWTF Agents": Small listeners that establish communication channels that allow to perform actions remotely (i.e. in a victim machine) <=> Abraham Aranguren (@7a_)
   - Added sbd-based shared-password OWTF Agent for persistent shell access to other machines to be used during a test (i.e. victim emulation)
   - Added ssh-based trusted-public-key OWTF Agent for an alternative to shared passwords (basic instructions to set this up with ssh)
   - Added initial auxiliary plugins to communicate with OWTF agents:
 	  SBD_CommandChainer is working, the others in rce are WIP (see plugins/aux/rce)
   - Added imapd OWTF agent: This checks email with a predefined account and loads the configured plugin to process the message.
       Example: 
       1) OWTF sends a targeted phishing attack via aux/se/Targeted_Phishing@OWTF-ASEP-002.py
       2) An OWTF imapd Agent processes any new email that arrives and emulates a user click for all links found in the message
 + Added initial SMB handler to the framework and a related plugin: aux/smb/SMB_Handler@OWTF-SMB-001.py <=> Abraham Aranguren (@7a_)
 + Added an Interactive Shell handler useful to interact with remote and local shells run in a subprocess <=> Abraham Aranguren (@7a_)
 + Significant SET integration improvements: new OWTF SET handler + spear_phishing modules and plugin/configurability tweaks  <=> Abraham Aranguren (@7a_)
 + Added hopefully better comments in several places <=> Abraham Aranguren (@7a_)
 + Started to use Eclipse and Fixed indentation on many framework files :P <=> Abraham Aranguren (@7a_)
 + Bug fix: Commented out goohost shell one liners in profiles/general/default.cfg: When goohost is not installed cat hangs (Thanks to Sandro Gauci) <=> Abraham Aranguren (@7a_)
 + Bug fix: Grep plugins were no longer showing links to Text, HTML, etc findings <=> Abraham Aranguren (@7a_)
 + Added CAPTCHA breaker tool links to external plugin to assist manual exploitation: PWNtcha - captcha decoder, Captcha Breaker <=> Abraham Aranguren (@7a_)
 + Added vulnerability search box to the CAPTCHA external plugin <=> Abraham Aranguren (@7a_)
 + Added links to the "Session managament schema" external plugin: Gareth Hayes' HackVertor, Raul Siles' (Taddong) F5 BIG IP Cookie Decoder <=> Abraham Aranguren (@7a_)
 + Added link to the "SSI Injection" external plugin: webappsec.org SSI Injection info <=> Abraham Aranguren (@7a_)
 + Moved HTTP-Traceroute back into rev_proxy to avoid config changes <=> Abraham Aranguren (@7a_)

10/02/2012 - 0.12 "Wicky" pre-alpha release: Dedicated to @marcwickenden for sending the first pull request!
 + Merged pull request with IPv6 support and proper IP validation from @marcwickenden thanks! <=> Marc Wickenden (@marcwickenden)
 + Added graceful framework abort when a hostname cannot be resolved (instead of python trace mess) <=> Abraham Aranguren (@7a_)
 + Added Hurricane Electric passive recon link to discovery plugin (Thanks to Chris John Riley) <=> Abraham Aranguren (@7a_)
 + Bug fix in plugin_handler.py and plugin_register.py to set a Start, RunTime and End date for external plugins that have been already run but require to be registered against a target to report display purposes. Only happened in separate iterations. <=> Abraham Aranguren (@7a_)
 + Added a Sanitiser module to solve the "embedding untrusted HTML" issue, when POST is the only way to query a third party site. The filter is public and you are encouraged to break it :). An improved filter will be published shortly after each new public bypass. <=> Abraham Aranguren (@7a_)
   REMARKS: 
   - Thank you very much to everybody that took the time to try to break the HTML filter!
   - Congratulations + props to the successful breakers before this release: Mario Heiderich, @notracecc, @dreyercito
   - If you did not try to break the filter, what are you waiting for? :)
   - The challenge will run indefinitely and is available here: http://blog.7-a.org/2012/01/embedding-untrusted-html-xss-challenge.html
 + Clean-up of passive robots.txt plugin to sanitise embedded HTML (via module above) + move this to an external file
 + plugin_helper.py clean-up for flexibility, readability and code reuse around transparent filtering and sandboxing of embedded third-party HTML (related to above)
 + When embedding HTML from a third party site OWTF will: <=> Abraham Aranguren (@7a_)  
     1) Filter the HTML using the Sanitiser module above
     2) Save the filtered output to a file
     3) Create a separate file that embeds the filtered output inside a sanboxed iframe (just in case an unpublished bypass whatever ;))
     4) The OWTF report provides a link to the sanboxed file only
     5) Both the sandboxed + non-sandboxed files are saved to another directory = they cannot access HTML 5 localstorage (where your review is), at least in Firefox 8
 + Fixed minor but annoying bug whereby the filter was not showing up when the detailed report was collapsed, so detailed report totals were not being shown <=> Abraham Aranguren (@7a_) 
 + Added a more links to assist manual XSS exploitation: http://www.bindshell.net/tools/beef, http://xss-proxy.sourceforge.net/, http://www.gnucitizen.org/projects/backframe/ <=> Abraham Aranguren (@7a_) 
 + Integration with CKEditor (http://ckeditor.com/): <=> Abraham Aranguren (@7a_) 
   1) Notes now have a full blown WYSIWYG editor -their permissive licensing allows redistribution, thank you!-
   2) Above means you can now take notes with fancy formatting: tables, links, bullet points, font format, size, style, etc (useful for exploit/PoC links, etc)
   3) The OWTF review works as usual but the notes are now saved with their formatting (HTML instead of plain text)
   4) OWTF will show an automated preview on top of the editor, this is always displayed, which makes it more intuitive to see if there are notes present for a plugin
   5) OWTF will also automatically save these formatted notes in the review for resilience: Even if your browser crashes or is closed by mistake you keep what you typed
   6) The OWTF notes preview also modify links so that they are displayed on a new tab (most useful option and consistent with other links in the report)
   7) OWTF will create/destroy CKEditor instances as follows: 1st lightbulb click: create, 2nd click: destroy = report is more lightweight, loads faster, etc
   8) OWTF will destroy all plugin editors when a new one is created: This ensures only resources for a single editor are used at any point in time (report = lightweight)
 + Bug fix: Changing the detailed report iframe size via onload event was messy: Now the iframe is created directly using the initial height defined on: COLLAPSED_REPORT_SIZE <=> Abraham Aranguren (@7a_) 
 + Enhancement: Added new review icons to be able to flag certain special cases. Icons can be removed on: profiles/general/default.cfg <=> Abraham Aranguren (@7a_) 
   1) LadyBug: Flag functional and/or business logic bugs (it's up to you how you interpret this, as usual)
   2) Empty Star: To flag you had a brief look (already saw it) but no real analysis was done
   3) Half Star: To flag you had an initial look but need to investigate more to be able to rate the output
 + Created an initial help file that is linked to from the OWTF report via question mark icons <=> Abraham Aranguren (@7a_) 
 + Some clean-up around review icons code in the report a bit less messy now :P <=> Abraham Aranguren (@7a_) 
 + Plugin Review Icons are now highlighted like filters when the user clicks on them as well as when the report loads: More intuitive <=> Abraham Aranguren (@7a_) 
 + Multiple bug fixes around Import/Export Review from Summary report (Import was not working at all and other similar problems) <=> Abraham Aranguren (@7a_) 
 + Multiple space and colour optimisations in the report <=> Abraham Aranguren (@7a_) 
 + An initial Summary Report filter has been implemented, this triggers the same filter on all children iframes, resizing them, etc <=> Abraham Aranguren (@7a_) 
 + Added unit tests to allow more efficient testing of the Sanitiser module (i.e. test quickly all previous bypasses against new filter) <=> Abraham Aranguren (@7a_) 
 + Made the Sanitiser module a bit smarter so that: <=> Abraham Aranguren (@7a_) 
     1) It can be called from the framework: When this happens no tests are run, but all functionality is callable by the framework
     2) It can be called from the commandline: When this happens the Sanitiser expects HTML on stdin (i.e. cat input.txt | sanitiser.py)
     NOTE: I noticed it was handier to read from stdin (instead of a hard-coded file) so that I can regression test new filters faster
 + Significant report memory usage improvements (single review object shared for all reports, it was num_targets x review + 1 before) <=> Abraham Aranguren (@7a_) 
 + Significant report performance improvements: <=> Abraham Aranguren (@7a_) 
     1) When the report loads for the first time, counters and colours are calculated and stored in localstorage
     2) Counters will only be updated when the user rates plugins from then on
     3) When the report loads again counters are not calculated (as previously= this was slow), instead they are read from localStorage
 + Lots of small report tweaks to improve navigability, general usability and appearance <=> Abraham Aranguren (@7a_) 
 + Added rudimentary reporting functionality via magic bar: Builds a basic report for ease of copy-paste in your reporting <=> Abraham Aranguren (@7a_) 
 + Refactored owtf.js into smaller files: owtf_general.js, owtf_review.js, owtf_filter.js and owtf_reporting.js <=> Abraham Aranguren (@7a_) 
 + Reorganised dictionaries and tools into "restricted" (i.e. licensing) directories so that they are not committed by mistake to github <=> Abraham Aranguren (@7a_) 

19/01/2012 - 0.11 "Vienna" pre-alpha release: Dedicated with special love to BSides Vienna (http://www.bsidesvienna.info/), its organisers and attendants
 + Significant report improvements <=> Abraham Aranguren (@7a_) 
 + OWTF will now only execute external plugins once regardless of the number of targets (it was 1 x num_targets before, way slower) <=> Abraham Aranguren (@7a_) 
 + Host names are now retrieved properly from python via import socket + socket.gethostbyname -> i.e. cannot use dns/host when /etc/hosts is required in a pen test (Bug report credit: Sandro Gauci) <=> Abraham Aranguren (@7a_) 
 + Fixed licence to more accurately match 3-clause-BSD (the intended licence :)) <=> Abraham Aranguren (@7a_) 
 + Created initial FAQ based on actual feedback/questions <=> Abraham Aranguren (@7a_) 
 + Added new grep + external plugins for HTML5 Cross Origin Resource Sharing (CORS) (OWTF-WGP-002) - Thanks to Krzyzstof Kotowicz for answering my questions + great PoCs :) <=> Abraham Aranguren (@7a_) 
 + Added links to interesting resources for manual exploitation, etc on the external CORS plugin (Thanks to Krzysztof Kotowicz) <=> Abraham Aranguren (@7a_) 
 + Added links to interesting resources for manual exploitation, etc on the external Cross Site Flashing plugin (Thanks to Krzysztof Kotowicz, Michele Orru, Mario Heiderich) <=> Abraham Aranguren (@7a_) 
 + Tweaked cross site flashing passive plugin (google hacking searches) to also search for Silverlight's stuff: clientaccesspolicy.xml, .xap and .scr files  <=> Abraham Aranguren (@7a_) 
 + Tweaked cross site flashing semi passive plugin to also try to get the clientaccesspolicy.xml file (Silverlight's equivalent to crossdomain.xml) <=> Abraham Aranguren (@7a_) 
 + Tweaked regexps for Application Configuration Management (OWASP-CM-004) to reduce false positives <=> Abraham Aranguren (@7a_) 
 + Added regexps to Application Configuration Management (OWASP-CM-004) to search for PHP+ASP source code disclosure too <=> Abraham Aranguren (@7a_) 
 + Added resources (Nicolas Gregoire's XLT wiki) to XML Injection external plugin (to assist with manual exploitation) <=> Abraham Aranguren (@7a_) 
 + Added Nicolas Gregoire's HTTP-Traceroute.py reverse proxy check script to tools/discovery/web/rev_proxy (Thanks to Nicolas for allowing direct redistribution with OWTF!) <=> Abraham Aranguren (@7a_) 
   Added a GET and TRACE reverse proxy checks using HTTP-Traceroute.py to: Infrastructure Configuration Management (OWASP-CM-003) - with WAF and Load Balancer checks -
   Link for background: http://www.agarri.fr/kom/archives/2011/11/12/traceroute-like_http_scanner/index.html
 + Bug fix: owtf.py -l net (also owtf.py -g net) would crash because there are no net plugins yet: An error message explaining this is now shown instead (Bug report credit: am06, Michele Orru))  <=> Abraham Aranguren (@7a_) 
 + Bug fix: semi_passive/Testing_for_Cross_site_flashing@OWASP-DV-004.py does no longer show duplicates + minor plugin clean-up <=> Abraham Aranguren (@7a_) 
 + Bug fix: Fixed some issues on Transaction DB comparisons that resulted in the Cache not working right <=> Abraham Aranguren (@7a_) 
 + Modified web/passive/Spiders_Robots_and_Crawlers\@OWASP-IG-001.py to directly submit the form on tool.motoricerca.info (because it does not work via link, uses POST only) <=> Abraham Aranguren (@7a_) 
 + Added Start, End and Runtime fields to Plugin Register + Modified report to display the Start + End Date/Time for each plugin (potentially useful to correlate log events) <=> Abraham Aranguren (@7a_) 
 + Added http://statsie.com passive analysis link (on Passive Search Engine Discovery) <=> Abraham Aranguren (@7a_) 
 + Created a configuration health-check module by massive popular demand :). When OWTF starts it will now warn you when tools are missing and suggest how to fix it. <=> Abraham Aranguren (@7a_) 
 + Created initial rudimentary owtf_dir/tools/bt5_install.sh script (incomplete, but getting there) to download tools missing or unreliable in Backtrack 5 <=> Abraham Aranguren (@7a_) 
 + Updated install script (owtf_dir/install/bt5_install.sh) + /profiles/general/default.cfg to include the latest Arachni version (v0.4.0.2) and verified it works <=> Abraham Aranguren (@7a_) 
 + Experimental: Created a Command Register (owtf_review/db/command_register.txt) where information on all commands run is stored: <=> Abraham Aranguren (@7a_) 
   - Start+End Date/Time, Runtime, Status (Finished/Cancelled), Actual command run, Command without plugin output info (needed internally for the framework)
   - Purpose 1: Avoid running the same command several times, very useful when you have several domain.com targets. A message like "command already run for target X" appears
   - Purpose 2: Simple date and time correlation becomes possible: Useful for debugging and IDS testing (which exploit worked? what command brought the server down?, etc)
   - Purpose 3: It is simply nice to have a log of every command that was run, and questions like "what tools did you run and how?" become easier to answer
 + Added link to Gareth Heyes' awesome http://shazzer.co.uk project to assist with manual XSS exploitation <=> Abraham Aranguren (@7a_) 
 + Added Command execution start date/time information on the screen so that the pen tester can make a better decision (wait/stop it) <=> Abraham Aranguren (@7a_) 
 + Experimental: Created a redirect detection mechanism so that it is more intuitive to realise when all URLs are being redirected (i.e. blanket redirect from port 80 to 443) <=> Abraham Aranguren (@7a_) 
   - Status will be marked as "302 Found": Instead of the previous "200 OK", which did not reflect the redirect (not ideal but better than 200)
   - URL will be set as the redirected URL: This way it is more obvious if the target is http:// but the transaction log is all https://, that there is a blanket redirect
   - Known issue: The scope can be wrong if the redirect is performed to outside of the target URL, need to work more on this

 + Experimental: If the user supplies only domain names, the scope expands to https + http for each domain <=> Abraham Aranguren (@7a_) 
 + Experimental: If a passed URL cannot be reached it is removed from the report (assumed it does not exist) -> useful for huge scopes! <=> Abraham Aranguren (@7a_) 

06/01/2012 - 0.10 "Berlin" pre-alpha release dedicated to BerlinSides (http://berlinsides.org/), its organisers and attendants
 + Thanks to Mario Heiderich for the sample attack vectors and Selenium research for IDS testing (used by the selenium aux plugin) <=> Abraham Aranguren (@7a_) 
 + Passive Plugins will now be run even if the target IP is internal because passive plugins now also make suggestions (i.e. potentially useful commands) <=> Abraham Aranguren (@7a_) 
 + Changed blue navigation arrows to + and - gray icons courtesy of http://www.app-bits.com/free-icons.html. plus/minus suggested as more intuitive (Idea Credit: Sandro Gauci) <=> Abraham Aranguren (@7a_) 
 + Changed text color to be darker for higher contrast and easier reading :) (Idea Credit: Sandro Gauci) <=> Abraham Aranguren (@7a_) 
 + Implemented dynamic counters beside each filter for a quick visual overview and know where data is (with colours too :)) + All icons are now configurable <=> Abraham Aranguren (@7a_) 
 + Bug fix: Comments where not being populated back upon screen reload <=> Abraham Aranguren (@7a_) 
 + Removed matches table (redundant now because of the counters) and added mechanism to highlight enabled filter icon with blue background: More intuitive, I think <=> Abraham Aranguren (@7a_) 
 + Several UI rearrangements to improve navigation and intuitiveness <=> Abraham Aranguren (@7a_) 
 + Implemented new CLI option for algorithm: breadth (default): runs each plugin against all targets first. And depth runs all plugins against each target first <=> Abraham Aranguren (@7a_) 
 + Massive refactoring/rewrite of significant portions of the framework to support: algorithm, multi-host targets, future net plugins, etc <=> Abraham Aranguren (@7a_) 
 + Changed Config to transparently handle multi-target configurations (i.e. self.Core.Config.Get('x') --> 'x' is relevant for the current target) <=> Abraham Aranguren (@7a_) 
 + Changed Config to transparently handle multi-target replacements (i.e. self.Core.Config.get_replacement_dict() --> Returns PLACE_HOLDER => VALUE pairs relevant for target) <=> Abraham Aranguren (@7a_) 
 + Serious refactoring to dynamically load plugins and plugin types from the file system along with a description of what they do <=> Abraham Aranguren (@7a_) 
 + Significant DB refactoring to accomodate to the new multi-host/multi-db problem, created plugin register db and improved DB simulation mode without touching disk <=> Abraham Aranguren (@7a_) 
 + Bug fix: New Plugin highlighting upon screen refresh is now working again <=> Abraham Aranguren (@7a_) 
 + robots.txt analysis: Added resource: http://tool.motoricerca.info/robots-checker.phtml + changed proxy from hexilion to anonymouse.org + passive robots.txt plugin clean-up <=> Abraham Aranguren (@7a_) 
 + Bug fix: Fixed an issue that resulted in many broken report links <=> Abraham Aranguren (@7a_) 
 + Significant reporting improvements, including Summary report counters working, etc <=> Abraham Aranguren (@7a_) 
 + Transaction Log DB handling improvements and clean up <=> Abraham Aranguren (@7a_) 
 + Added "external" plugins so that the pen tester has a way to write down information relevant to external tools and/or manual testing. Will have helpful info in the future. <=> Abraham Aranguren (@7a_) 
 + Added initial SSI grep plugin <=> Abraham Aranguren (@7a_) 
 + Added OWASP Codes to the detailed report <=> Abraham Aranguren (@7a_) 
 + Many more bugs were also fixed .. <=> Abraham Aranguren (@7a_) 

01/12/2011 - 0.07 pre-alpha release
 + Fixed bug in spider plugin: Counter incorrect <=> Abraham Aranguren (@7a_) 
 + Cache Control Meta tags search added to grep plugin: Logout and Browser Cache Management (OWASP-AT-007) <=> Abraham Aranguren (@7a_) 
 + New plugins: autocomplete, cross site flashing <=> Abraham Aranguren (@7a_) 
 + Report navigation improved <=> Abraham Aranguren (@7a_) 
 + Added option to "Mark as Reviewed", "Mark as NOT Reviewed", "Clear Review", "Clear Review Storage" for more efficient review <=> Abraham Aranguren (@7a_) 
 + Reviewed items are stricken-through, so it's easy to see what has not been reviewed yet <=> Abraham Aranguren (@7a_) 
 + New plugin results are highlighted in white blackground, so that it is easy for the tester to identify what's new <=> Abraham Aranguren (@7a_) 
 + Made seed shorter and flipped top table to be horizontal and take a lot less space off the screen <=> Abraham Aranguren (@7a_) 
 + To the right of OWASP Index Item: Removed toggle + moved "show" and "hide" beside plugin tabs, refactor into tabcreator <=> Abraham Aranguren (@7a_) 
 + Added basic CSRF grep plugin that looks for hidden fields (in the hope that token will/will not be found) <=> Abraham Aranguren (@7a_) 
 + Added basic SQLi google-hacking passive plugin <=> Abraham Aranguren (@7a_) 
 + Added DoS grep plugin (show top 10 slowest queries and suggest to view log) <=> Abraham Aranguren (@7a_) 
 + Cleared up the HTTP Transactions table: Removed redundant links + Added link to transaction log <=> Abraham Aranguren (@7a_) 
 + Added new plugin for Credentials_transport_over_an_encrypted_channel <=> Abraham Aranguren (@7a_) 
 + Lots of UI improvements to use screen space better: Now Review, History, Logs, etc have their own tabs <=> Abraham Aranguren (@7a_) 
 + Tried to use cool jquery icons but failed miserably: They are displayed but background sucks need a web designer :) <=> Abraham Aranguren (@7a_) 
 + Had the bright idea of changing the naming convention, which broke everything for 1day+ <=> Abraham Aranguren (@7a_) 
 + Bug fix: All URLs where being logged instead of only the valid ones <=> Abraham Aranguren (@7a_) 
 + Bug fix: DoS testing was taking into account transactions out of scope <=> Abraham Aranguren (@7a_) 
 + Bug fix: DoS plugin (and DB transaction manager) crashed when transaction DB empty <=> Abraham Aranguren (@7a_) 
 + Moved DirBuster to its own plugin: Old, Backup and Unreferenced Files (OWASP-CM-006) <=> Abraham Aranguren (@7a_) 
 + Moved each scanner to its own plugin for ease of review and flexibility (i.e. I want to run X but not Y, etc): arachni, wapiti, w3af, etc now have their own plugins <=> Abraham Aranguren (@7a_) 
 + Bug fix: Added check on plugin handler so that grep plugins are skipped when Transaction DB is empty (Grep plugins grep the DB so no DB = fail) <=> Abraham Aranguren (@7a_) 
 + Bug fix: Vuln search box was broken due to jquery port changes <=> Abraham Aranguren (@7a_) 
 + Added check so that passive plugins are not run if the target ip is an RFC1918 address (aka "private" or "LAN" address) <=> Abraham Aranguren (@7a_) 
 + Added passive Testing for Admin Interfaces (OWASP-CM-007) <=> Abraham Aranguren (@7a_) 
 + Split URL DB into "potential URL" (maybe third-party tool false positive) and "URL" (vetted) DBs -> potential URLs to be checked by spider plugins <=> Abraham Aranguren (@7a_) 
 + Improved Extract URLs mechanism to Visit links (adding to DB, which helps grep plugins) if >= 1 active plugin enabled + associated bugfixes, UI and timing improvements <=> Abraham Aranguren (@7a_) 
 + Improved log UI to indicate if there are error messages or not without having to click the button + Significant Log UI navigation improvements <=> Abraham Aranguren (@7a_) 
 + Implemented persistence via localStorage, serious JavaScript refactoring: Now there is a single Review JSON object, code simplified a lot <=> Abraham Aranguren (@7a_) 
 + Made the choice between localStorage and sessvars configurable so that the user can choose and use some form of persistance (sessvars) even on old browsers. <=> Abraham Aranguren (@7a_) 
 + Because of above 2 lines the Storage has been abstracted into separate libraries: the abstraction (sessvars or localStorage) is loaded depending on configuration setting <=> Abraham Aranguren (@7a_) 
 + Implemented ability to add notes to the results of each plugin, this is saved in the JavaScript storage as well <=> Abraham Aranguren (@7a_) 
 + Added a Filter tab at the top that includes the icons available to review each plugin and allows filtering by flag, by comments present, striken-through, etc <=> Abraham Aranguren (@7a_) 
 + Fixed lots of bugs in filter above, added "review size" and "total size" columns to top table for visibility of memory in use, the columns are updated on the fly <=> Abraham Aranguren (@7a_) 
 + Added a hidden token div inside plugin reports so that the report can detect whether a plugin's content has changed or not: If changed highlight tab background to white <=> Abraham Aranguren (@7a_) 
 + Added a counter to the filter so that the user has visibility about how many plugins matched the filter (handy to find bugs too) <=> Abraham Aranguren (@7a_) 
 + Made rating flags configurable: the user can now choose which flag icons they wish to view on the screen (i.e. only low, medium and high icons, etc) <=> Abraham Aranguren (@7a_) 
 + Added a new Grep plugin based on URL classification for "Old Backup and Unreferenced Files (OWASP-CM-006)" <=> Abraham Aranguren (@7a_) 
 + Bug fix: the grep plugin for "Old Backup and Unreferenced Files (OWASP-CM-006)" was showing URLs with 404 responses <=> Abraham Aranguren (@7a_) 
 + Bug fix: Solved a storage capacity calculation issue when sessvars was chosen as the JavaScript storage <=> Abraham Aranguren (@7a_) 
 + Installed the latest stable whatweb version, which fixed some issues after updating BT5 R1 <=> Abraham Aranguren (@7a_) 
 + Enabled filter on load: Refreshing the report will now 1) Click on the Filter tab + 2) Click on the "show completed plugins only" filter => Showing only available info <=> Abraham Aranguren (@7a_) 
 + Bug fix: The unique html counter db was being corrupted under special circumstances (6+ multi-runs) <=> Abraham Aranguren (@7a_) 
 + Moved suggested commands from active fingerprint to passive: They are only suggested. Also created powerful primitive to suggest commands more efficiently <=> Abraham Aranguren (@7a_) 
 + Bug fix: Spider was using the previous DB instead of the one for scraped/potential URLs <=> Abraham Aranguren (@7a_) 
 + Bug fix/Enhancement: Serious improvements to CMS Explorer import dictionaries script: Dictionaries are now converted into DirBuster format and CMS-specific <=> Abraham Aranguren (@7a_) 
 + After above, created new configuration lines for CMS-specific dictionaries: all, wordpress all, wordpress plugins, etc from the DirBuster format import (thx CMS Explorer). <=> Abraham Aranguren (@7a_) 

18/11/2011 - 0.04 pre-alpha release - Lots of improvements, widely unpublished
 + Re-architecture to simplify code a bit more (general clean-up) <=> Abraham Aranguren (@7a_) 
 + Lots of bug fixes <=> Abraham Aranguren (@7a_) 
 + Implemented (hopefully) robust error/exception handling that facilitates bug reporting and tries to save as much partial data as possible for the user when a crash happens <=> Abraham Aranguren (@7a_) 
 + Implemented new HTTP method support in reporter module (HEAD, OPTIONS, TRACE, DEBUG and PUT -PUT still buggy-) <=> Abraham Aranguren (@7a_) 
 + Improved DB format and implemented a few caching functions to speed the framework <=> Abraham Aranguren (@7a_) 
 + Implemented naming convention to distinguish scope from external DB transactions <=> Abraham Aranguren (@7a_) 
 + Implemented logging of transaction parts separately as well as in full: 4 files saved per transaction -> full, request, resp. headers and resp. body <=> Abraham Aranguren (@7a_) 
 + Created new Reporting functions to show Transactions as tables easily from plugins (reporter.py: DrawHTTPTransactionTable and relatives) <=> Abraham Aranguren (@7a_) 
 + Created new mRandom module to build random strings on the fly <=> Abraham Aranguren (@7a_) 
 + Centralised helper functions into a single library called general.py (will consider separating when there are more functions) <=> Abraham Aranguren (@7a_) 
 + Improved Transaction log and main report significantly and started to customise CSS a bit <=> Abraham Aranguren (@7a_) 
 + Main config.cfg split into framework_config.cfg and user_config.cfg to keep settings separate, the framework loads all settings on the Config object <=> Abraham Aranguren (@7a_) 
 + Added outbound proxy support for owtf requests only and a proxy check on start-up <=> Abraham Aranguren (@7a_) 
 + Serious refactoring of database and related fixes elsewhere in the framework: Now broken down into: db, url_manager, transaction_manager and run_manager <=> Abraham Aranguren (@7a_) 
 + Moved plugin_handler and plugin_helper into a plugin module (aka "directory") <=> Abraham Aranguren (@7a_) 
 + Significant improvements in Header Analysis and Reporting <=> Abraham Aranguren (@7a_) 
 + Lots of error handling bug fixes <=> Abraham Aranguren (@7a_) 
 + Moved transaction.py and requester.py into a http module (aka "directory") <=> Abraham Aranguren (@7a_) 
 + Added handy links section to report at the top: OWASP Testing Guide, CVSS advanced calculator, Hackvertor, etc <=> Abraham Aranguren (@7a_) 
 + Changed grep plugin behaviour: Grep plugins will automatically be run after semi_passive and then again after active plugins run + always overwritten <=> Abraham Aranguren (@7a_) 
 + Built reusable response pattern matching primitives <=> Abraham Aranguren (@7a_) 
 + Fixed nasty run DB data corruption bug (only happened on the first 2 runs) <=> Abraham Aranguren (@7a_) 
 + Added autocomplete plugin that looks for password fields <=> Abraham Aranguren (@7a_) 

01/11/2011 - 0.01 pre-alpha release - Basic proof of concept, widely unpublished :) <=> Abraham Aranguren (@7a_) 
