/*
    This Yara ruleset is under the GNU-GPLv2 license (http://www.gnu.org/licenses/gpl-2.0.html) and open to any user or organization, as long as you use it under this license.
*/

rule CVE_2018_20250 : AceArchive UNACEV2_DLL_EXP
{
    meta:
        description = "Generic rule for hostile ACE archive using CVE-2018-20250"
        author = "xylitol@temari.fr"
        date = "2019-03-17"
        reference = "https://research.checkpoint.com/extracting-code-execution-from-winrar/"
        // May only the challenge guide you
    strings:
        $string1 = "**ACE**" ascii wide
        $string2 = "*UNREGISTERED VERSION*" ascii wide
        // $hexstring1 = C:\C:\
        $hexstring1 = {?? 3A 5C ?? 3A 5C}
        // $hexstring2 = C:\C:C:..
        $hexstring2 = {?? 3A 5C ?? 3A ?? 3A 2E}
    condition:  
         $string1 at 7 and $string2 at 31 and 1 of ($hexstring*)
}
