/*
    This Yara ruleset is under the GNU-GPLv2 license (http://www.gnu.org/licenses/gpl-2.0.html) and open to any user or organization, as    long as you use it under this license.
*/

/*
	Androguard module used in this rule file is under development by people at https://koodous.com/.

	You can get it, along with installation instructions, at https://github.com/Koodous/androguard-yara
*/

import "androguard"

rule hacking_team : stcert android
{
	meta:
		author = "Fernando Denis https://twitter.com/fdrg21"
		reference = "https://koodous.com/"
		description = "This rule detects the apk related to hackingteam - These certificates are presents in mailboxes od hackingteam"
		samples = "c605df5dbb9d9fb1d687d59e4d90eba55b3201f8dd4fa51ec80aa3780d6e3e6e"

	strings:
		$string_a_1 = "280128120000Z0W1"
		$string_a_2 = "E6FFF4C5062FBDC9"
		$string_a_3 = "886FEC93A75D2AC1"
		$string_a_4 = "121120104150Z"
		
		$string_b_1 = "&inbox_timestamp > 0 and is_permanent=1"
		$string_b_2 = "contact_id = ? AND mimetype = ?"
		
		$string_c = "863d9effe70187254d3c5e9c76613a99"
		
		$string_d = "nv-sa1"

	condition:
		(any of ($string_a_*) and any of ($string_b_*) and $string_c and $string_d) or
		androguard.certificate.sha1("B1BC968BD4F49D622AA89A81F2150152A41D829C") or 	  
		androguard.certificate.sha1("3FEC88BA49773680E2A3040483806F56E6E8502E") or 
		androguard.certificate.sha1("B0A4A4880FA5345D6B3B00C0C588A39815D3872E") or 
		androguard.certificate.sha1("EC2184676D4AE153E63987326666BA0C554A4A60") or 
		androguard.certificate.sha1("A7394CBAB09D35C69DA7FABB1A7870BE987A5F77")	or
		androguard.certificate.sha1("A1131C7F816D65670567D6C7041F30E380754022") or
		androguard.certificate.sha1("4E40663CC29C1FE7A436810C79CAB8F52474133B") or
		androguard.certificate.sha1("159B4F6C03D43F27339E06ABFD2DE8D8D65516BC") or
		androguard.certificate.sha1("3EEE4E45B174405D64F877EFC7E5905DCCD73816") or
		androguard.certificate.sha1("9CE815802A672B75C078D920A5D506BBBAC0D5C9") or
		androguard.certificate.sha1("C4CF31DBEF79393FD2AD617E79C27BFCF19EFBB3") or
		androguard.certificate.sha1("2125821BC97CF4B7591E5C771C06C9C96D24DF8F")
		//97257C6D8F6DA60EA27D2388D9AE252657FF3304 this certification could be stolen
		//03EA873D5D13707B0C278A0055E452416054E27B this certification could be stolen
		//B8D5E3F0BCAD2EB03BB34AEE2B3F63FC5162C56B this certification could be stolen
}
