/* 		Yara rule to detect ELF Linux process injector toolkit "mandibule" generic.
   		name: TOOLKIT_Mandibule.yar analyzed by unixfreaxjp. 
		result:
		TOOLKIT_Mandibule ./mandibule//mandibule-dynx86-stripped
		TOOLKIT_Mandibule ./mandibule//mandibule-dynx86-UNstripped
		TOOLKIT_Mandibule ./mandibule//mandibule-dun64-UNstripped
		TOOLKIT_Mandibule ./mandibule//mandibule-dyn64-stripped

   		This Yara ruleset is under the GNU-GPLv2 license (http://www.gnu.org/licenses/gpl-2.0.html) 
   		and  open to any user or organization, as long as you use it under this license.
*/

private rule is__str_mandibule_gen1 {
	meta:
		author = "unixfreaxjp"
		date = "2018-05-31"
	strings:
		$str01 = "shared arguments too big" fullword nocase wide ascii
		$str02 = "self inject pid: %" fullword nocase wide ascii
		$str03 = "injected shellcode at 0x%lx" fullword nocase wide ascii        	
		$str04 = "target pid: %d" fullword nocase wide ascii        	
		$str05 = "mapping '%s' into memory at 0x%lx" fullword nocase wide ascii
		$str06 = "shellcode injection addr: 0x%lx" fullword nocase wide ascii
		$str07 = "loading elf at: 0x%llx" fullword nocase wide ascii
	condition:
                4 of them
}

private rule is__hex_top_mandibule64 {
	meta:
		author = "unixfreaxjp"
		date = "2018-05-31"
	strings:
		$hex01 = { 48 8D 05 43 01 00 00 48 89 E7 FF D0 } // st
		$hex02 = { 53 48 83 EC 50 48 89 7C 24 08 48 8B 44 24 08 } // mn
		$hex03 = { 48 81 EC 18 02 00 00 89 7C 24 1C 48 89 74 } // pt
		$hex04 = { 53 48 81 EC 70 01 01 00 48 89 7C 24 08 48 8D 44 24 20 48 05 00 00 } // ld
	condition:
                3 of them 
}

private rule is__hex_mid_mandibule32 {
	meta:
		author = "unixfreaxjp"
		date = "2018-06-01"
	strings:
		$hex05 = { E8 09 07 00 00 81 C1 FC 1F 00 00 8D 81 26 E1 FF FF } // st
		$hex06 = { 56 53 83 EC 24 E8 E1 05 00 00 81 C3 D0 1E 00 00 8B 44 24 30} // mn
		$hex07 = { 81 C3 E8 29 00 00 C7 44 24 0C } // pt
		$hex08 = { E8 C6 D5 FF FF 83 C4 0C 68 00 01 00 00 } // ld
	condition:
                3 of them 
}

rule TOOLKIT_Mandibule {
	meta:
		description = "Generic detection for ELF Linux process injector mandibule generic"
		reference = "https://imgur.com/a/MuHSZtC"
		author = "unixfreaxjp"
		org = "MalwareMustDie"
		date = "2018-06-01"
	condition:
		((is__str_mandibule_gen1) or (is__hex_mid_mandibule32))
		or ((is__str_mandibule_gen1) or (is__hex_top_mandibule64))
		and is__elf
		and filesize < 30KB 
}
