# Generated by Django 5.1.5 on 2025-03-03 15:46

import uuid

import django.db.models.deletion
from django.db import migrations, models

import api.db_utils
import api.rls
from api.rls import RowLevelSecurityConstraint


class Migration(migrations.Migration):
    dependencies = [
        ("api", "0013_integrations_enum"),
    ]

    operations = [
        migrations.CreateModel(
            name="Integration",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("inserted_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("enabled", models.BooleanField(default=False)),
                ("connected", models.BooleanField(blank=True, null=True)),
                (
                    "connection_last_checked_at",
                    models.DateTimeField(blank=True, null=True),
                ),
                (
                    "integration_type",
                    api.db_utils.IntegrationTypeEnumField(
                        choices=[
                            ("amazon_s3", "Amazon S3"),
                            ("saml", "SAML"),
                            ("aws_security_hub", "AWS Security Hub"),
                            ("jira", "JIRA"),
                            ("slack", "Slack"),
                        ]
                    ),
                ),
                ("configuration", models.JSONField(default=dict)),
                ("_credentials", models.BinaryField(db_column="credentials")),
                (
                    "tenant",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="api.tenant"
                    ),
                ),
            ],
            options={"db_table": "integrations", "abstract": False},
        ),
        migrations.AddConstraint(
            model_name="integration",
            constraint=RowLevelSecurityConstraint(
                "tenant_id",
                name="rls_on_integration",
                statements=["SELECT", "INSERT", "UPDATE", "DELETE"],
            ),
        ),
        migrations.CreateModel(
            name="IntegrationProviderRelationship",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("inserted_at", models.DateTimeField(auto_now_add=True)),
                (
                    "integration",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="api.integration",
                    ),
                ),
                (
                    "provider",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="api.provider"
                    ),
                ),
                (
                    "tenant",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="api.tenant"
                    ),
                ),
            ],
            options={
                "db_table": "integration_provider_mappings",
                "constraints": [
                    models.UniqueConstraint(
                        fields=("integration_id", "provider_id"),
                        name="unique_integration_provider_rel",
                    ),
                ],
            },
        ),
        migrations.AddConstraint(
            model_name="IntegrationProviderRelationship",
            constraint=RowLevelSecurityConstraint(
                "tenant_id",
                name="rls_on_integrationproviderrelationship",
                statements=["SELECT", "INSERT", "UPDATE", "DELETE"],
            ),
        ),
        migrations.AddField(
            model_name="integration",
            name="providers",
            field=models.ManyToManyField(
                blank=True,
                related_name="integrations",
                through="api.IntegrationProviderRelationship",
                to="api.provider",
            ),
        ),
    ]
