# Generated by Django 5.1.8 on 2025-05-21 11:37

import uuid

import django.db.models.deletion
from django.db import migrations, models

import api.db_utils
import api.rls
from api.rls import RowLevelSecurityConstraint


class Migration(migrations.Migration):
    dependencies = [
        ("api", "0026_provider_secret_gcp_service_account"),
    ]

    operations = [
        migrations.CreateModel(
            name="ComplianceRequirementOverview",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("inserted_at", models.DateTimeField(auto_now_add=True)),
                ("compliance_id", models.TextField(blank=False)),
                ("framework", models.TextField(blank=False)),
                ("version", models.TextField(blank=True)),
                ("description", models.TextField(blank=True)),
                ("region", models.TextField(blank=False)),
                ("requirement_id", models.TextField(blank=False)),
                (
                    "requirement_status",
                    api.db_utils.StatusEnumField(
                        choices=[
                            ("FAIL", "Fail"),
                            ("PASS", "Pass"),
                            ("MANUAL", "Manual"),
                        ]
                    ),
                ),
                ("passed_checks", models.IntegerField(default=0)),
                ("failed_checks", models.IntegerField(default=0)),
                ("total_checks", models.IntegerField(default=0)),
                (
                    "scan",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="compliance_requirements_overviews",
                        related_query_name="compliance_requirements_overview",
                        to="api.scan",
                    ),
                ),
                (
                    "tenant",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="api.tenant"
                    ),
                ),
            ],
            options={
                "db_table": "compliance_requirements_overviews",
                "abstract": False,
                "indexes": [
                    models.Index(
                        fields=["tenant_id", "scan_id"], name="cro_tenant_scan_idx"
                    ),
                    models.Index(
                        fields=["tenant_id", "scan_id", "compliance_id"],
                        name="cro_scan_comp_idx",
                    ),
                    models.Index(
                        fields=["tenant_id", "scan_id", "compliance_id", "region"],
                        name="cro_scan_comp_reg_idx",
                    ),
                    models.Index(
                        fields=[
                            "tenant_id",
                            "scan_id",
                            "compliance_id",
                            "requirement_id",
                        ],
                        name="cro_scan_comp_req_idx",
                    ),
                    models.Index(
                        fields=[
                            "tenant_id",
                            "scan_id",
                            "compliance_id",
                            "requirement_id",
                            "region",
                        ],
                        name="cro_scan_comp_req_reg_idx",
                    ),
                ],
                "constraints": [
                    models.UniqueConstraint(
                        fields=(
                            "tenant_id",
                            "scan_id",
                            "compliance_id",
                            "requirement_id",
                            "region",
                        ),
                        name="unique_tenant_compliance_requirement_overview",
                    )
                ],
            },
        ),
        migrations.AddConstraint(
            model_name="ComplianceRequirementOverview",
            constraint=RowLevelSecurityConstraint(
                "tenant_id",
                name="rls_on_compliancerequirementoverview",
                statements=["SELECT", "INSERT", "UPDATE", "DELETE"],
            ),
        ),
    ]
