import { Chip } from "@heroui/chip";
import React from "react";

export type FindingStatus = "FAIL" | "PASS" | "MANUAL" | "MUTED";

const statusColorMap: Record<
  FindingStatus,
  "danger" | "warning" | "success" | "default"
> = {
  FAIL: "danger",
  PASS: "success",
  MANUAL: "warning",
  MUTED: "default",
};

export const StatusFindingBadge = ({
  status,
  size = "sm",
  value,
  ...props
}: {
  status: FindingStatus;
  size?: "sm" | "md" | "lg";
  value?: string | number;
}) => {
  const color = statusColorMap[status];

  return (
    <Chip
      className="border-none px-2 py-0"
      size={size}
      variant="flat"
      color={color}
      {...props}
    >
      <span className="text-default-600 text-xs font-light tracking-wide">
        {status.charAt(0).toUpperCase() + status.slice(1).toLowerCase()}
        {value !== undefined && `: ${value}`}
      </span>
    </Chip>
  );
};
