# Generated by Django 5.1.14 on 2025-12-03 13:38

import uuid

import django.db.models.deletion
from django.db import migrations, models

import api.rls


class Migration(migrations.Migration):
    dependencies = [
        ("api", "0060_attack_surface_overview"),
    ]

    operations = [
        migrations.CreateModel(
            name="DailySeveritySummary",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("date", models.DateField()),
                ("critical", models.IntegerField(default=0)),
                ("high", models.IntegerField(default=0)),
                ("medium", models.IntegerField(default=0)),
                ("low", models.IntegerField(default=0)),
                ("informational", models.IntegerField(default=0)),
                ("muted", models.IntegerField(default=0)),
                (
                    "provider",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="daily_severity_summaries",
                        related_query_name="daily_severity_summary",
                        to="api.provider",
                    ),
                ),
                (
                    "scan",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="daily_severity_summaries",
                        related_query_name="daily_severity_summary",
                        to="api.scan",
                    ),
                ),
                (
                    "tenant",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="api.tenant",
                    ),
                ),
            ],
            options={
                "db_table": "daily_severity_summaries",
                "abstract": False,
            },
        ),
        migrations.AddIndex(
            model_name="dailyseveritysummary",
            index=models.Index(
                fields=["tenant_id", "id"],
                name="dss_tenant_id_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="dailyseveritysummary",
            index=models.Index(
                fields=["tenant_id", "provider_id"],
                name="dss_tenant_provider_idx",
            ),
        ),
        migrations.AddConstraint(
            model_name="dailyseveritysummary",
            constraint=models.UniqueConstraint(
                fields=("tenant_id", "provider", "date"),
                name="unique_daily_severity_summary",
            ),
        ),
        migrations.AddConstraint(
            model_name="dailyseveritysummary",
            constraint=api.rls.RowLevelSecurityConstraint(
                "tenant_id",
                name="rls_on_dailyseveritysummary",
                statements=["SELECT", "INSERT", "UPDATE", "DELETE"],
            ),
        ),
    ]
